/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;

public class MethodDeclarationLocator
extends PatternLocator {
    protected MethodDeclarationPattern pattern;

    public MethodDeclarationLocator(MethodDeclarationPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    protected void clear() {
    }

    @Override
    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    @Override
    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        String declaringType;
        if (!this.matchesName(this.pattern.simpleName, node.getName().toCharArray())) {
            return 0;
        }
        List arguments = node.getArguments();
        if (this.pattern.parameterNames != null) {
            int argsLength;
            int length = this.pattern.parameterNames.length;
            int n = argsLength = arguments == null ? 0 : arguments.size();
            if (length != argsLength) {
                return 0;
            }
        }
        if (!this.checkTypeName(declaringType = node.getDeclaringTypeName())) {
            return 1;
        }
        return nodeSet.addMatch(node, 3);
    }

    @Override
    public int matchContainer() {
        return 7;
    }

    @Override
    public SearchMatch newDeclarationMatch(ASTNode reference, IModelElement element, int accuracy, MatchLocator locator) {
        return super.newDeclarationMatch(reference, element, accuracy, locator);
    }

    @Override
    protected int referenceType() {
        return 9;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    @Override
    public int match(CallExpression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IModelElement element, int accuracy, MatchLocator locator) {
    }

    private boolean checkTypeName(String declaringType) {
        if (this.pattern.enclosingTypeNames != null && this.pattern.enclosingTypeNames.length > 0) {
            if (declaringType != null) {
                char[] cArray;
                ISearchPatternProcessor processor = DLTKLanguageManager.getSearchPatternProcessor(this.pattern.getToolkit());
                if (processor != null) {
                    cArray = processor.getDelimiterReplacementString().toCharArray();
                } else {
                    char[] cArray2 = new char[1];
                    cArray = cArray2;
                    cArray2[0] = 46;
                }
                char[] delimeter = cArray;
                char[] typeName = this.pattern.enclosingTypeNames[0];
                if (typeName == null) {
                    return true;
                }
                int i = 1;
                while (i < this.pattern.enclosingTypeNames.length) {
                    typeName = CharOperation.concatWithSeparator(typeName, this.pattern.enclosingTypeNames[i], delimeter);
                    ++i;
                }
                if (!this.matchesName(typeName, declaringType.toCharArray())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

