/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.autoedit;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocAutoIndentStrategy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class AutoEditStrategyForJs
implements IAutoEditStrategy {
    private IAutoEditStrategy[] fStrategies;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        IAutoEditStrategy[] strats = this.getAutoEditStrategies(document);
        int i = 0;
        while (i < strats.length) {
            strats[i].customizeDocumentCommand(document, command);
            ++i;
        }
    }

    public IAutoEditStrategy[] getAutoEditStrategies(IDocument document) {
        if (this.fStrategies != null) {
            return this.fStrategies;
        }
        String partitioning = "org.eclipse.wst.html.SCRIPT";
        this.fStrategies = new IAutoEditStrategy[]{new SmartSemicolonAutoEditStrategy(partitioning), new JavaAutoIndentStrategy(partitioning, this.getJavaProject(document), null), new JavaDocAutoIndentStrategy(partitioning)};
        return this.fStrategies;
    }

    private IJavaScriptProject getJavaProject(IDocument document) {
        IDOMModel model = null;
        IJavaScriptProject javaProject = null;
        try {
            model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model == null) {
                return null;
            }
            String baseLocation = model.getBaseLocation();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baseLocation);
            IProject project = null;
            if (filePath.segmentCount() > 0) {
                project = root.getProject(filePath.segment(0));
            }
            if (project != null) {
                javaProject = JavaScriptCore.create(project);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return javaProject;
    }
}

