/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvParsingException;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParserSettings;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.Preconditions;

class CsvArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvSource> {
    private static final String LINE_SEPARATOR = "\n";
    private CsvSource annotation;

    CsvArgumentsProvider() {
    }

    @Override
    public void accept(CsvSource annotation) {
        this.annotation = annotation;
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(this.annotation.delimiter());
        ((CsvFormat)settings.getFormat()).setLineSeparator(LINE_SEPARATOR);
        ((CsvFormat)settings.getFormat()).setQuote('\'');
        ((CsvFormat)settings.getFormat()).setQuoteEscape('\'');
        settings.setEmptyValue(this.annotation.emptyValue());
        settings.setAutoConfigurationEnabled(false);
        CsvParser csvParser = new CsvParser(settings);
        AtomicLong index = new AtomicLong(0L);
        return Arrays.stream(this.annotation.value()).map(line -> {
            String[] parsedLine = null;
            try {
                parsedLine = csvParser.parseLine(line + LINE_SEPARATOR);
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
            Preconditions.notNull((Object)parsedLine, () -> "Line at index " + index.get() + " contains invalid CSV: \"" + line + "\"");
            return parsedLine;
        }).peek(values -> index.incrementAndGet()).map(Arguments::of);
    }

    static void handleCsvException(Throwable throwable, Annotation annotation) {
        BlacklistedExceptions.rethrowIfBlacklisted((Throwable)throwable);
        if (throwable instanceof PreconditionViolationException) {
            throw (PreconditionViolationException)throwable;
        }
        throw new CsvParsingException("Failed to parse CSV input configured via " + annotation, throwable);
    }
}

