/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.CFServiceOffering;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.AvailableService;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizard;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardPageLeftPanel;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardPageRightPanel;
import org.eclipse.cft.server.ui.internal.wizards.ServiceInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class CloudFoundryServiceWizardPage
extends WizardPage {
    final CloudFoundryServiceWizard parent;
    private CloudFoundryServiceWizardPageLeftPanel leftPanel;
    private CloudFoundryServiceWizardPageRightPanel rightPanel;
    private CloudFoundryServer cloudServer;
    Composite topComp;
    private List<AvailableService> availableServices;
    private List<String> existingCloudServiceNames = new ArrayList<String>();

    public CloudFoundryServiceWizardPage(CloudFoundryServer cloudServer, CloudFoundryServiceWizard parent) {
        super(CloudFoundryServiceWizardPage.class.getName());
        this.parent = parent;
        this.cloudServer = cloudServer;
        this.setTitle(Messages.CloudFoundryServiceWizardPage_TTILE_SERVICE_CONFIG);
        this.setDescription(Messages.CloudFoundryServiceWizardPage_TEXT_FINISH);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(cloudServer.getServer().getServerType().getId());
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
        this.availableServices = this.updateConfiguration();
        if (this.availableServices == null && parent.getParent() != null) {
            parent.getParent().close();
            return;
        }
    }

    public void setVisible(boolean isVis) {
        super.setVisible(isVis);
        this.leftPanel.createInnerLayoutList(this.availableServices, this.leftPanel.layoutList);
    }

    private List<AvailableService> updateConfiguration() {
        ArrayList<AvailableService> result;
        block9: {
            GetServiceResult getServiceResult;
            block8: {
                result = new ArrayList<AvailableService>();
                GetServiceOfferingsRunnable runnable = new GetServiceOfferingsRunnable();
                ProgressMonitorDialog monitorDlg = new ProgressMonitorDialog(this.getShell());
                monitorDlg.run(true, true, (IRunnableWithProgress)runnable);
                getServiceResult = runnable.getGetServiceOperationResult();
                if (getServiceResult != GetServiceResult.SUCCESS) break block8;
                if (runnable.getServiceOfferingResult() == null) break block9;
                if (runnable.getServiceOfferingResult().size() > 0) {
                    int index = 0;
                    for (CFServiceOffering o : runnable.getServiceOfferingResult()) {
                        result.add(new AvailableService(o.getName(), o.getDescription(), index, o));
                        ++index;
                    }
                    break block9;
                }
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.CloudFoundryServiceWizard_NO_SERVICES_AVAILABLE_TITLE, (String)Messages.CloudFoundryServiceWizard_NO_SERVICES_AVAILABLE_BODY);
                return null;
            }
            try {
                if (getServiceResult == GetServiceResult.ERROR) {
                    return null;
                }
                return null;
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getCause() != null ? e.getCause() : e;
                String msg = ex.getMessage();
                if (msg == null || msg.trim().length() == 0) {
                    msg = Messages.CloudFoundryServiceWizardPage_ERROR_CONFIG_RETRIVE_SEE_LOG_FOR_DETAILS;
                }
                IStatus status = this.cloudServer.error(NLS.bind((String)Messages.CloudFoundryServiceWizardPage_ERROR_CONFIG_RETRIVE, (Object)msg), (Exception)e);
                StatusManager.getManager().handle(status, 1);
                this.setMessage(status.getMessage(), 3);
            }
            catch (InterruptedException interruptedException) {
                if (!Logger.WARNING) break block9;
                Logger.println("/debug/warning", (Object)this, "updateConfiguration", "Failed to load the list of available services.");
            }
        }
        return result;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        main.setLayout((Layout)gridLayout);
        this.topComp = main;
        Composite central = new Composite(main, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        gd.verticalIndent = 10;
        central.setLayoutData((Object)gd);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 15;
        central.setLayout((Layout)fillLayout);
        this.leftPanel = new CloudFoundryServiceWizardPageLeftPanel(this);
        this.leftPanel.createMainWindowComposite(central);
        this.rightPanel = new CloudFoundryServiceWizardPageRightPanel(this);
        this.rightPanel.createMainWindowComposite(central);
        this.rightPanel.setExistingServicesNames(this.existingCloudServiceNames);
        this.setControl((Control)main);
    }

    public List<CFServiceInstance> getServices() {
        ArrayList<CFServiceInstance> result = new ArrayList<CFServiceInstance>();
        List<List<ServiceInstance>> newServices = this.rightPanel.getServiceInstances();
        if (newServices != null) {
            for (List<ServiceInstance> instances : newServices) {
                for (ServiceInstance instance : instances) {
                    result.add(instance.convertToLocalService());
                }
            }
        }
        return result;
    }

    public CloudFoundryServer getCloudServer() {
        return this.cloudServer;
    }

    public void dispose() {
        super.dispose();
        if (this.leftPanel != null) {
            this.leftPanel.dispose();
        }
    }

    protected CloudFoundryServiceWizardPageRightPanel getRight() {
        return this.rightPanel;
    }

    private class GetServiceOfferingsRunnable
    implements IRunnableWithProgress {
        private final List<CFServiceOffering> serviceOfferingResult = new ArrayList<CFServiceOffering>();
        private GetServiceResult result = GetServiceResult.INITIAL;

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                GetServiceOfferingsThread thread = new GetServiceOfferingsThread(monitor);
                thread.start();
                thread.waitForResult(monitor);
                List<CFServiceOffering> serviceOfferings = null;
                if (thread.isOperationComplete()) {
                    if (thread.getException() != null) {
                        throw thread.getException();
                    }
                } else {
                    this.result = GetServiceResult.USER_CANCEL;
                    return;
                }
                serviceOfferings = thread.getServiceOfferings();
                try {
                    Collections.sort(serviceOfferings, new Comparator<CFServiceOffering>(){

                        @Override
                        public int compare(CFServiceOffering o1, CFServiceOffering o2) {
                            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                        }
                    });
                    this.serviceOfferingResult.addAll(serviceOfferings);
                    List allServices = CloudFoundryServiceWizardPage.this.cloudServer.getBehaviour().getServices(monitor);
                    if (allServices != null) {
                        for (CFServiceInstance existingService : allServices) {
                            String name = existingService.getName().toLowerCase();
                            if (CloudFoundryServiceWizardPage.this.existingCloudServiceNames.contains(name)) continue;
                            CloudFoundryServiceWizardPage.this.existingCloudServiceNames.add(name);
                        }
                    }
                    this.result = GetServiceResult.SUCCESS;
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.result = GetServiceResult.USER_CANCEL;
                    throw new InterruptedException();
                }
                catch (Throwable e) {
                    this.result = GetServiceResult.ERROR;
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }

        public GetServiceResult getGetServiceOperationResult() {
            return this.result;
        }

        public List<CFServiceOffering> getServiceOfferingResult() {
            return this.serviceOfferingResult;
        }
    }

    private class GetServiceOfferingsThread
    extends Thread {
        private final IProgressMonitor monitor;
        private final Object lock = new Object();
        private boolean operationComplete = false;
        private Throwable exception;
        private List<CFServiceOffering> serviceOfferings;

        public GetServiceOfferingsThread(IProgressMonitor monitor) {
            this.setName(GetServiceOfferingsThread.class.getName());
            this.setDaemon(true);
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                try {
                    try {
                        this.monitor.beginTask(Messages.CloudFoundryServiceWizardPage_GETTING_AVAILABLE_SERVICES, -1);
                        List localServiceOfferings = CloudFoundryServiceWizardPage.this.cloudServer.getBehaviour().getServiceOfferings((IProgressMonitor)new NullProgressMonitor());
                        Object object = this.lock;
                        synchronized (object) {
                            this.serviceOfferings = localServiceOfferings;
                        }
                    }
                    catch (Throwable e) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.exception = e;
                        }
                        Object object2 = this.lock;
                        synchronized (object2) {
                            this.operationComplete = true;
                            this.lock.notify();
                            break block20;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.operationComplete = true;
                        this.lock.notify();
                    }
                    throw throwable;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.operationComplete = true;
                    this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForResult(IProgressMonitor monitor) {
            try {
                while (!monitor.isCanceled()) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(100L);
                        if (this.operationComplete) {
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Throwable getException() {
            Object object = this.lock;
            synchronized (object) {
                return this.exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CFServiceOffering> getServiceOfferings() {
            Object object = this.lock;
            synchronized (object) {
                return this.serviceOfferings;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOperationComplete() {
            Object object = this.lock;
            synchronized (object) {
                return this.operationComplete;
            }
        }
    }

    private static enum GetServiceResult {
        INITIAL,
        SUCCESS,
        USER_CANCEL,
        ERROR;

    }
}

