/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.runtime.IAdaptable;

public class THNode
implements IAdaptable {
    private THNode fParent;
    private ICElement fElement;
    private List<THNode> fChildren = Collections.emptyList();
    private int fHashCode;
    private boolean fIsFiltered;
    private boolean fIsImplementor;

    public THNode(THNode parent, ICElement decl) {
        this.fParent = parent;
        this.fElement = decl;
        this.fHashCode = Objects.hash(this.fParent, this.fElement);
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof THNode)) {
            return false;
        }
        THNode rhs = (THNode)o;
        if (this.fHashCode != rhs.fHashCode) {
            return false;
        }
        return Objects.equals(this.fElement, rhs.fElement);
    }

    public THNode getParent() {
        return this.fParent;
    }

    public ICElement getElement() {
        return this.fElement;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ICElement.class)) {
            return this.getElement();
        }
        return null;
    }

    public boolean isFiltered() {
        return this.fIsFiltered;
    }

    public void setIsFiltered(boolean val) {
        this.fIsFiltered = val;
    }

    public void addChild(THNode childNode) {
        if (this.fChildren.isEmpty()) {
            this.fChildren = new ArrayList<THNode>();
        }
        this.fChildren.add(childNode);
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public THNode[] getChildren() {
        return this.fChildren.toArray(new THNode[this.fChildren.size()]);
    }

    public void setIsImplementor(boolean val) {
        this.fIsImplementor = val;
    }

    public boolean isImplementor() {
        return this.fIsImplementor;
    }

    public void removeFilteredLeaves() {
        Iterator<THNode> iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            THNode child = iterator.next();
            child.removeFilteredLeaves();
            if (!child.isFiltered() || child.hasChildren()) continue;
            iterator.remove();
        }
    }

    public void removeNonImplementorLeaves() {
        Iterator<THNode> iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            THNode child = iterator.next();
            child.removeNonImplementorLeaves();
            if (child.isImplementor() || child.hasChildren()) continue;
            iterator.remove();
        }
    }
}

