/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourcePermissionOwner;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.utils.CommonUtils;

public class DBPConnectionType
implements DBPDataSourcePermissionOwner {
    public static final DBPConnectionType DEV = new DBPConnectionType("dev", ModelMessages.dbp_connection_type_table_development, "255,255,255", ModelMessages.dbp_connection_type_table_regular_development_database, true, false, false, true, null);
    public static final DBPConnectionType TEST = new DBPConnectionType("test", ModelMessages.dbp_connection_type_table_test, "196,255,181", ModelMessages.dbp_connection_type_table_test_database, true, false, true, true, null);
    public static final DBPConnectionType PROD = new DBPConnectionType("prod", ModelMessages.dbp_connection_type_table_production, "247,159,129", ModelMessages.dbp_connection_type_table_production_database, false, true, true, true, null);
    public static final DBPConnectionType[] SYSTEM_TYPES = new DBPConnectionType[]{DEV, TEST, PROD};
    public static final DBPConnectionType DEFAULT_TYPE = DEV;
    private String id;
    private String name;
    private String color;
    private String description;
    private boolean autocommit;
    private boolean confirmExecute;
    private boolean confirmDataChange;
    private final boolean predefined;
    private List<DBPDataSourcePermission> connectionModifyRestrictions;

    public DBPConnectionType(DBPConnectionType source) {
        this(source.id, source.name, source.color, source.description, source.autocommit, source.confirmExecute, source.confirmDataChange, source.predefined, source.connectionModifyRestrictions);
    }

    public DBPConnectionType(String id, String name, String color, String description, boolean autocommit, boolean confirmExecute, boolean confirmDataChange) {
        this(id, name, color, description, autocommit, confirmExecute, confirmDataChange, false, null);
    }

    private DBPConnectionType(String id, String name, String color, String description, boolean autocommit, boolean confirmExecute, boolean confirmDataChange, boolean predefined, List<DBPDataSourcePermission> connectionModifyRestrictions) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.description = description;
        this.autocommit = autocommit;
        this.confirmExecute = confirmExecute;
        this.confirmDataChange = confirmDataChange;
        this.predefined = predefined;
        this.connectionModifyRestrictions = connectionModifyRestrictions;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public boolean isConfirmExecute() {
        return this.confirmExecute;
    }

    public void setConfirmExecute(boolean confirmExecute) {
        this.confirmExecute = confirmExecute;
    }

    public boolean isConfirmDataChange() {
        return this.confirmDataChange;
    }

    public void setConfirmDataChange(boolean confirmDataChange) {
        this.confirmDataChange = confirmDataChange;
    }

    @Override
    public boolean hasModifyPermission(DBPDataSourcePermission permission) {
        return this.connectionModifyRestrictions == null || !this.connectionModifyRestrictions.contains((Object)permission);
    }

    @Override
    public List<DBPDataSourcePermission> getModifyPermission() {
        if (CommonUtils.isEmpty(this.connectionModifyRestrictions)) {
            return Collections.emptyList();
        }
        return new ArrayList<DBPDataSourcePermission>(this.connectionModifyRestrictions);
    }

    @Override
    public void setModifyPermissions(@Nullable Collection<DBPDataSourcePermission> permissions) {
        this.connectionModifyRestrictions = CommonUtils.isEmpty(permissions) ? null : new ArrayList<DBPDataSourcePermission>(permissions);
    }

    public boolean equals(Object obj) {
        return obj instanceof DBPConnectionType && this.id.equals(((DBPConnectionType)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

