/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.utils.CommonUtils;

public class ScriptSelectorPanel {
    private static final Log log = Log.getLog(ScriptSelectorPanel.class);
    public static final String CONFIG_BOUNDS_PARAM = "bounds";
    private final IWorkbenchWindow workbenchWindow;
    private final Shell popup;
    private final Text patternText;
    private final TreeViewer scriptViewer;
    private final Button newButton;
    private volatile FilterJob filterJob;

    public ScriptSelectorPanel(final @NotNull IWorkbenchWindow workbenchWindow, final @NotNull DBPDataSourceContainer[] containers, final @NotNull IFolder rootFolder) {
        this.workbenchWindow = workbenchWindow;
        Shell parent = this.workbenchWindow.getShell();
        this.popup = new Shell(parent, 112);
        if (containers.length == 1) {
            this.popup.setText("Choose SQL script for '" + containers[0].getName() + "'");
            this.popup.setImage(DBeaverIcons.getImage((DBPImage)containers[0].getDriver().getIcon()));
        } else {
            this.popup.setText("Choose SQL script");
        }
        this.popup.setLayout((Layout)new FillLayout());
        Rectangle bounds = new Rectangle(100, 100, 500, 200);
        String boundsStr = this.getBoundsSettings().get(CONFIG_BOUNDS_PARAM);
        if (boundsStr != null && !boundsStr.isEmpty()) {
            String[] bc = boundsStr.split(",");
            try {
                bounds = new Rectangle(Integer.parseInt(bc[0]), Integer.parseInt(bc[1]), Integer.parseInt(bc[2]), Integer.parseInt(bc[3]));
            }
            catch (NumberFormatException e) {
                log.warn((Object)e);
            }
        }
        Rectangle displayBounds = workbenchWindow.getShell().getDisplay().getBounds();
        if (bounds.x + bounds.width > displayBounds.width) {
            bounds.width = displayBounds.width - bounds.x;
            if (bounds.width < 100) {
                bounds.width = 100;
            }
        }
        this.popup.setBounds(bounds);
        Composite composite = new Composite((Composite)this.popup, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this.patternText = new Text(composite, 0);
        this.patternText.setLayoutData((Object)new GridData(768));
        this.patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScriptSelectorPanel.this.filterJob != null) {
                    return;
                }
                ScriptSelectorPanel.this.filterJob = new FilterJob();
                ScriptSelectorPanel.this.filterJob.schedule(250L);
            }
        });
        Color fg = this.patternText.getForeground();
        Color bg = this.patternText.getBackground();
        composite.setForeground(fg);
        composite.setBackground(bg);
        this.newButton = new Button(composite, 0x800008);
        this.newButton.setText("&New Script");
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptSelectorPanel.this.popup.dispose();
                try {
                    IFile scriptFile = SQLEditorUtils.createNewScript(DBWorkbench.getPlatform().getWorkspace().getProject(rootFolder.getProject()), rootFolder, containers.length == 0 ? null : containers[0]);
                    OpenHandler.openResource((IResource)scriptFile, workbenchWindow);
                }
                catch (CoreException ex) {
                    log.error((Object)ex);
                }
            }
        });
        ((GridData)UIUtils.createHorizontalLine((Composite)composite).getLayoutData()).horizontalSpan = 2;
        Tree scriptTree = new Tree(composite, 65540);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        scriptTree.setLayoutData((Object)gd);
        scriptTree.setForeground(fg);
        scriptTree.setBackground(bg);
        scriptTree.setLinesVisible(true);
        this.scriptViewer = new TreeViewer(scriptTree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.scriptViewer);
        this.scriptViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof SQLEditorUtils.ResourceInfo) {
                    List<SQLEditorUtils.ResourceInfo> children = ((SQLEditorUtils.ResourceInfo)parentElement).getChildren();
                    return CommonUtils.isEmpty(children) ? null : children.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof SQLEditorUtils.ResourceInfo) {
                    List<SQLEditorUtils.ResourceInfo> children = ((SQLEditorUtils.ResourceInfo)element).getChildren();
                    return !CommonUtils.isEmpty(children);
                }
                return false;
            }
        });
        ViewerColumnController columnController = new ViewerColumnController("scriptSelectorViewer", (ColumnViewer)this.scriptViewer);
        columnController.addColumn("Script", "Resource name", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)element;
                if (!ri.isDirectory()) {
                    if (ri.getDataSource() == null) {
                        return DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT);
                    }
                    return DBeaverIcons.getImage((DBPImage)ri.getDataSource().getDriver().getIcon());
                }
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER);
            }

            public String getText(Object element) {
                return ((SQLEditorUtils.ResourceInfo)element).getName();
            }

            public String getToolTipText(Object element) {
                DBPDataSourceContainer dataSource = ((SQLEditorUtils.ResourceInfo)element).getDataSource();
                return dataSource == null ? null : dataSource.getName();
            }

            public Image getToolTipImage(Object element) {
                DBPDataSourceContainer dataSource = ((SQLEditorUtils.ResourceInfo)element).getDataSource();
                return dataSource == null ? null : DBeaverIcons.getImage((DBPImage)dataSource.getDriver().getIcon());
            }
        });
        columnController.addColumn("Time", "Modification time", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){
            private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

            public String getText(Object element) {
                File localFile = ((SQLEditorUtils.ResourceInfo)element).getLocalFile();
                if (localFile.isDirectory()) {
                    return null;
                }
                return this.sdf.format(new Date(localFile.lastModified()));
            }
        });
        columnController.addColumn("Info", "Script preview", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Color getForeground(Object element) {
                return ScriptSelectorPanel.this.popup.getDisplay().getSystemColor(17);
            }

            public String getToolTipText(Object element) {
                SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)element;
                String description = ri.getDescription();
                return description == null ? null : description.trim();
            }
        });
        columnController.createColumns();
        columnController.sortByColumn(1, 128);
        scriptTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ArrayList<SQLEditorUtils.ResourceInfo> files = new ArrayList<SQLEditorUtils.ResourceInfo>();
                Object[] objectArray = ((IStructuredSelection)ScriptSelectorPanel.this.scriptViewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (!((SQLEditorUtils.ResourceInfo)item).isDirectory()) {
                        files.add((SQLEditorUtils.ResourceInfo)item);
                    }
                    ++n2;
                }
                if (files.isEmpty()) {
                    return;
                }
                ScriptSelectorPanel.this.popup.dispose();
                for (SQLEditorUtils.ResourceInfo ri : files) {
                    OpenHandler.openResourceEditor(ScriptSelectorPanel.this.workbenchWindow, ri);
                }
            }
        });
        scriptTree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                final TreeItem item = (TreeItem)event.item;
                final SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)item.getData();
                if (ri != null && !ri.isDirectory() && CommonUtils.isEmpty((String)item.getText(2))) {
                    UIUtils.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!item.isDisposed()) {
                                item.setText(2, CommonUtils.getSingleLineString((String)CommonUtils.notEmpty((String)ri.getDescription())));
                            }
                        }
                    });
                }
            }
        });
        this.patternText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Tree tree = ScriptSelectorPanel.this.scriptViewer.getTree();
                if (e.keyCode == 0x1000002) {
                    ScriptSelectorPanel.this.scriptViewer.setSelection((ISelection)new StructuredSelection(tree.getItem(0).getData()));
                    tree.setFocus();
                } else if (e.keyCode == 0x1000001) {
                    ScriptSelectorPanel.this.scriptViewer.setSelection((ISelection)new StructuredSelection(tree.getItem(tree.getItemCount() - 1).getData()));
                    tree.setFocus();
                }
            }
        });
        final Listener focusFilter = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget != ScriptSelectorPanel.this.scriptViewer.getTree() && event.widget != ScriptSelectorPanel.this.patternText && event.widget != ScriptSelectorPanel.this.newButton) {
                    ScriptSelectorPanel.this.popup.dispose();
                }
            }
        };
        this.popup.getDisplay().addFilter(15, focusFilter);
        this.popup.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Rectangle bounds = ScriptSelectorPanel.this.popup.getBounds();
                ScriptSelectorPanel.this.getBoundsSettings().put(ScriptSelectorPanel.CONFIG_BOUNDS_PARAM, String.valueOf(bounds.x) + "," + bounds.y + "," + bounds.width + "," + bounds.height);
                ScriptSelectorPanel.this.popup.getDisplay().removeFilter(15, focusFilter);
            }
        });
    }

    IDialogSettings getBoundsSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.ScriptSelectorPanel");
    }

    public void showTree(List<SQLEditorUtils.ResourceInfo> scriptFiles) {
        this.popup.layout();
        this.popup.setVisible(true);
        this.loadScriptTree(scriptFiles);
        Tree tree = this.scriptViewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        columns[0].pack();
        columns[0].setWidth(columns[0].getWidth() + 10);
        columns[1].pack();
        columns[2].setWidth(1600);
        this.patternText.setFocus();
    }

    private void loadScriptTree(List<SQLEditorUtils.ResourceInfo> scriptFiles) {
        this.scriptViewer.setInput(scriptFiles);
        this.scriptViewer.expandToLevel(2);
    }

    private class FilterJob
    extends UIJob {
        public FilterJob() {
            super("Filter scripts");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ScriptSelectorPanel.this.filterJob = null;
            ScriptSelectorPanel.this.scriptViewer.setFilters(new ViewerFilter[]{new ScriptFilter()});
            ScriptSelectorPanel.this.scriptViewer.expandAll();
            Tree tree = ScriptSelectorPanel.this.scriptViewer.getTree();
            if (tree.getItemCount() > 0) {
                ScriptSelectorPanel.this.scriptViewer.reveal(tree.getItem(0).getData());
            }
            return Status.OK_STATUS;
        }
    }

    private class ScriptFilter
    extends ViewerFilter {
        private final String pattern;

        public ScriptFilter() {
            this.pattern = ScriptSelectorPanel.this.patternText.getText().toLowerCase(Locale.ENGLISH);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IResource resource = ((SQLEditorUtils.ResourceInfo)element).getResource();
            if (resource instanceof IFolder) {
                return this.isAnyChildMatches((SQLEditorUtils.ResourceInfo)element);
            }
            return ((SQLEditorUtils.ResourceInfo)element).getName().toLowerCase(Locale.ENGLISH).contains(this.pattern);
        }

        private boolean isAnyChildMatches(SQLEditorUtils.ResourceInfo ri) {
            for (SQLEditorUtils.ResourceInfo child : ri.getChildren()) {
                if (!(child.getResource() instanceof IFolder ? this.isAnyChildMatches(child) : child.getName().toLowerCase(Locale.ENGLISH).contains(this.pattern))) continue;
                return true;
            }
            return false;
        }
    }
}

