/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { HOST, NEXT, PARENT, QUERIES } from './view';
/**
 * Below are constants for LContainer indices to help us look up LContainer members
 * without having to remember the specific indices.
 * Uglify will inline these when minifying so there shouldn't be a cost.
 * @type {?}
 */
export const ACTIVE_INDEX = 0;
/** @type {?} */
export const VIEWS = 1;
// PARENT, NEXT, QUERIES, and HOST are indices 2, 3, 4, and 5.
// As we already have these constants in LView, we don't need to re-create them.
/** @type {?} */
export const NATIVE = 6;
/** @type {?} */
export const RENDER_PARENT = 7;
// Because interfaces in TS/JS cannot be instanceof-checked this means that we
// need to rely on predictable characteristics of data-structures to check if they
// are what we expect for them to be. The `LContainer` interface code below has a
// fixed length and the constant value below references that. Using the length value
// below we can predictably gaurantee that we are dealing with an `LContainer` array.
// This value MUST be kept up to date with the length of the `LContainer` array
// interface below so that runtime type checking can work.
/** @type {?} */
export const LCONTAINER_LENGTH = 8;
/**
 * The state associated with a container.
 *
 * This is an array so that its structure is closer to LView. This helps
 * when traversing the view tree (which is a mix of containers and component
 * views), so we can jump to viewOrContainer[NEXT] in the same way regardless
 * of type.
 * @record
 */
export function LContainer() { }
if (false) {
    /* Skipping unnamed member:
    [ACTIVE_INDEX]: number;*/
    /* Skipping unnamed member:
    [VIEWS]: LView[];*/
    /* Skipping unnamed member:
    [PARENT]: LView|null;*/
    /* Skipping unnamed member:
    [NEXT]: LView|LContainer|null;*/
    /* Skipping unnamed member:
    [QUERIES]: LQueries|null;*/
    /* Skipping unnamed member:
    [HOST]: RElement|RComment|StylingContext|LView;*/
    /* Skipping unnamed member:
    [NATIVE]: RComment;*/
    /* Skipping unnamed member:
    [RENDER_PARENT]: RElement|null;*/
}
// Note: This hack is necessary so we don't erroneously get a circular dependency
// failure based on types.
/** @type {?} */
export const unusedValueExportToPlacateAjd = 1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29udGFpbmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvcmVuZGVyMy9pbnRlcmZhY2VzL2NvbnRhaW5lci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQVdBLE9BQU8sRUFBQyxJQUFJLEVBQVMsSUFBSSxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUMsTUFBTSxRQUFRLENBQUM7Ozs7Ozs7QUFRMUQsTUFBTSxPQUFPLFlBQVksR0FBRyxDQUFDOztBQUM3QixNQUFNLE9BQU8sS0FBSyxHQUFHLENBQUM7Ozs7QUFHdEIsTUFBTSxPQUFPLE1BQU0sR0FBRyxDQUFDOztBQUN2QixNQUFNLE9BQU8sYUFBYSxHQUFHLENBQUM7Ozs7Ozs7OztBQVE5QixNQUFNLE9BQU8saUJBQWlCLEdBQUcsQ0FBQzs7Ozs7Ozs7OztBQVVsQyxnQ0F3RUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFJRCxNQUFNLE9BQU8sNkJBQTZCLEdBQUcsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtMUXVlcmllc30gZnJvbSAnLi9xdWVyeSc7XG5pbXBvcnQge1JDb21tZW50LCBSRWxlbWVudH0gZnJvbSAnLi9yZW5kZXJlcic7XG5pbXBvcnQge1N0eWxpbmdDb250ZXh0fSBmcm9tICcuL3N0eWxpbmcnO1xuaW1wb3J0IHtIT1NULCBMVmlldywgTkVYVCwgUEFSRU5ULCBRVUVSSUVTfSBmcm9tICcuL3ZpZXcnO1xuXG5cbi8qKlxuICogQmVsb3cgYXJlIGNvbnN0YW50cyBmb3IgTENvbnRhaW5lciBpbmRpY2VzIHRvIGhlbHAgdXMgbG9vayB1cCBMQ29udGFpbmVyIG1lbWJlcnNcbiAqIHdpdGhvdXQgaGF2aW5nIHRvIHJlbWVtYmVyIHRoZSBzcGVjaWZpYyBpbmRpY2VzLlxuICogVWdsaWZ5IHdpbGwgaW5saW5lIHRoZXNlIHdoZW4gbWluaWZ5aW5nIHNvIHRoZXJlIHNob3VsZG4ndCBiZSBhIGNvc3QuXG4gKi9cbmV4cG9ydCBjb25zdCBBQ1RJVkVfSU5ERVggPSAwO1xuZXhwb3J0IGNvbnN0IFZJRVdTID0gMTtcbi8vIFBBUkVOVCwgTkVYVCwgUVVFUklFUywgYW5kIEhPU1QgYXJlIGluZGljZXMgMiwgMywgNCwgYW5kIDUuXG4vLyBBcyB3ZSBhbHJlYWR5IGhhdmUgdGhlc2UgY29uc3RhbnRzIGluIExWaWV3LCB3ZSBkb24ndCBuZWVkIHRvIHJlLWNyZWF0ZSB0aGVtLlxuZXhwb3J0IGNvbnN0IE5BVElWRSA9IDY7XG5leHBvcnQgY29uc3QgUkVOREVSX1BBUkVOVCA9IDc7XG4vLyBCZWNhdXNlIGludGVyZmFjZXMgaW4gVFMvSlMgY2Fubm90IGJlIGluc3RhbmNlb2YtY2hlY2tlZCB0aGlzIG1lYW5zIHRoYXQgd2Vcbi8vIG5lZWQgdG8gcmVseSBvbiBwcmVkaWN0YWJsZSBjaGFyYWN0ZXJpc3RpY3Mgb2YgZGF0YS1zdHJ1Y3R1cmVzIHRvIGNoZWNrIGlmIHRoZXlcbi8vIGFyZSB3aGF0IHdlIGV4cGVjdCBmb3IgdGhlbSB0byBiZS4gVGhlIGBMQ29udGFpbmVyYCBpbnRlcmZhY2UgY29kZSBiZWxvdyBoYXMgYVxuLy8gZml4ZWQgbGVuZ3RoIGFuZCB0aGUgY29uc3RhbnQgdmFsdWUgYmVsb3cgcmVmZXJlbmNlcyB0aGF0LiBVc2luZyB0aGUgbGVuZ3RoIHZhbHVlXG4vLyBiZWxvdyB3ZSBjYW4gcHJlZGljdGFibHkgZ2F1cmFudGVlIHRoYXQgd2UgYXJlIGRlYWxpbmcgd2l0aCBhbiBgTENvbnRhaW5lcmAgYXJyYXkuXG4vLyBUaGlzIHZhbHVlIE1VU1QgYmUga2VwdCB1cCB0byBkYXRlIHdpdGggdGhlIGxlbmd0aCBvZiB0aGUgYExDb250YWluZXJgIGFycmF5XG4vLyBpbnRlcmZhY2UgYmVsb3cgc28gdGhhdCBydW50aW1lIHR5cGUgY2hlY2tpbmcgY2FuIHdvcmsuXG5leHBvcnQgY29uc3QgTENPTlRBSU5FUl9MRU5HVEggPSA4O1xuXG4vKipcbiAqIFRoZSBzdGF0ZSBhc3NvY2lhdGVkIHdpdGggYSBjb250YWluZXIuXG4gKlxuICogVGhpcyBpcyBhbiBhcnJheSBzbyB0aGF0IGl0cyBzdHJ1Y3R1cmUgaXMgY2xvc2VyIHRvIExWaWV3LiBUaGlzIGhlbHBzXG4gKiB3aGVuIHRyYXZlcnNpbmcgdGhlIHZpZXcgdHJlZSAod2hpY2ggaXMgYSBtaXggb2YgY29udGFpbmVycyBhbmQgY29tcG9uZW50XG4gKiB2aWV3cyksIHNvIHdlIGNhbiBqdW1wIHRvIHZpZXdPckNvbnRhaW5lcltORVhUXSBpbiB0aGUgc2FtZSB3YXkgcmVnYXJkbGVzc1xuICogb2YgdHlwZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMQ29udGFpbmVyIGV4dGVuZHMgQXJyYXk8YW55PiB7XG4gIC8qKlxuICAgKiBUaGUgbmV4dCBhY3RpdmUgaW5kZXggaW4gdGhlIHZpZXdzIGFycmF5IHRvIHJlYWQgb3Igd3JpdGUgdG8uIFRoaXMgaGVscHMgdXNcbiAgICoga2VlcCB0cmFjayBvZiB3aGVyZSB3ZSBhcmUgaW4gdGhlIHZpZXdzIGFycmF5LlxuICAgKiBJbiB0aGUgY2FzZSB0aGUgTENvbnRhaW5lciBpcyBjcmVhdGVkIGZvciBhIFZpZXdDb250YWluZXJSZWYsXG4gICAqIGl0IGlzIHNldCB0byBudWxsIHRvIGlkZW50aWZ5IHRoaXMgc2NlbmFyaW8sIGFzIGluZGljZXMgYXJlIFwiYWJzb2x1dGVcIiBpbiB0aGF0IGNhc2UsXG4gICAqIGkuZS4gcHJvdmlkZWQgZGlyZWN0bHkgYnkgdGhlIHVzZXIgb2YgdGhlIFZpZXdDb250YWluZXJSZWYgQVBJLlxuICAgKi9cbiAgW0FDVElWRV9JTkRFWF06IG51bWJlcjtcblxuICAvKipcbiAgICogQSBsaXN0IG9mIHRoZSBjb250YWluZXIncyBjdXJyZW50bHkgYWN0aXZlIGNoaWxkIHZpZXdzLiBWaWV3cyB3aWxsIGJlIGluc2VydGVkXG4gICAqIGhlcmUgYXMgdGhleSBhcmUgYWRkZWQgYW5kIHNwbGljZWQgZnJvbSBoZXJlIHdoZW4gdGhleSBhcmUgcmVtb3ZlZC4gV2UgbmVlZFxuICAgKiB0byBrZWVwIGEgcmVjb3JkIG9mIGN1cnJlbnQgdmlld3Mgc28gd2Uga25vdyB3aGljaCB2aWV3cyBhcmUgYWxyZWFkeSBpbiB0aGUgRE9NXG4gICAqIChhbmQgZG9uJ3QgbmVlZCB0byBiZSByZS1hZGRlZCkgYW5kIHNvIHdlIGNhbiByZW1vdmUgdmlld3MgZnJvbSB0aGUgRE9NIHdoZW4gdGhleVxuICAgKiBhcmUgbm8gbG9uZ2VyIHJlcXVpcmVkLlxuICAgKi9cbiAgW1ZJRVdTXTogTFZpZXdbXTtcblxuICAvKipcbiAgICogQWNjZXNzIHRvIHRoZSBwYXJlbnQgdmlldyBpcyBuZWNlc3Nhcnkgc28gd2UgY2FuIHByb3BhZ2F0ZSBiYWNrXG4gICAqIHVwIGZyb20gaW5zaWRlIGEgY29udGFpbmVyIHRvIHBhcmVudFtORVhUXS5cbiAgICovXG4gIFtQQVJFTlRdOiBMVmlld3xudWxsO1xuXG4gIC8qKlxuICAgKiBUaGlzIGFsbG93cyB1cyB0byBqdW1wIGZyb20gYSBjb250YWluZXIgdG8gYSBzaWJsaW5nIGNvbnRhaW5lciBvciBjb21wb25lbnRcbiAgICogdmlldyB3aXRoIHRoZSBzYW1lIHBhcmVudCwgc28gd2UgY2FuIHJlbW92ZSBsaXN0ZW5lcnMgZWZmaWNpZW50bHkuXG4gICAqL1xuICBbTkVYVF06IExWaWV3fExDb250YWluZXJ8bnVsbDtcblxuICAvKipcbiAgICogUXVlcmllcyBhY3RpdmUgZm9yIHRoaXMgY29udGFpbmVyIC0gYWxsIHRoZSB2aWV3cyBpbnNlcnRlZCB0byAvIHJlbW92ZWQgZnJvbVxuICAgKiB0aGlzIGNvbnRhaW5lciBhcmUgcmVwb3J0ZWQgdG8gcXVlcmllcyByZWZlcmVuY2VkIGhlcmUuXG4gICAqL1xuICBbUVVFUklFU106IExRdWVyaWVzfG51bGw7XG5cbiAgLyoqXG4gICAqIFRoZSBob3N0IGVsZW1lbnQgb2YgdGhpcyBMQ29udGFpbmVyLlxuICAgKlxuICAgKiBUaGUgaG9zdCBjb3VsZCBiZSBhbiBMVmlldyBpZiB0aGlzIGNvbnRhaW5lciBpcyBvbiBhIGNvbXBvbmVudCBub2RlLlxuICAgKiBJbiB0aGF0IGNhc2UsIHRoZSBjb21wb25lbnQgTFZpZXcgaXMgaXRzIEhPU1QuXG4gICAqXG4gICAqIEl0IGNvdWxkIGFsc28gYmUgYSBzdHlsaW5nIGNvbnRleHQgaWYgdGhpcyBpcyBhIG5vZGUgd2l0aCBhIHN0eWxlL2NsYXNzXG4gICAqIGJpbmRpbmcuXG4gICAqL1xuICBbSE9TVF06IFJFbGVtZW50fFJDb21tZW50fFN0eWxpbmdDb250ZXh0fExWaWV3O1xuXG4gIC8qKiBUaGUgY29tbWVudCBlbGVtZW50IHRoYXQgc2VydmVzIGFzIGFuIGFuY2hvciBmb3IgdGhpcyBMQ29udGFpbmVyLiAqL1xuICBbTkFUSVZFXTogUkNvbW1lbnQ7XG5cbiAgLyoqXG4gICAqIFBhcmVudCBFbGVtZW50IHdoaWNoIHdpbGwgY29udGFpbiB0aGUgbG9jYXRpb24gd2hlcmUgYWxsIG9mIHRoZSB2aWV3cyB3aWxsIGJlXG4gICAqIGluc2VydGVkIGludG8gdG8uXG4gICAqXG4gICAqIElmIGByZW5kZXJQYXJlbnRgIGlzIGBudWxsYCBpdCBpcyBoZWFkbGVzcy4gVGhpcyBtZWFucyB0aGF0IGl0IGlzIGNvbnRhaW5lZFxuICAgKiBpbiBhbm90aGVyIHZpZXcgd2hpY2ggaW4gdHVybiBpcyBjb250YWluZWQgaW4gYW5vdGhlciBjb250YWluZXIgYW5kXG4gICAqIHRoZXJlZm9yZSBpdCBkb2VzIG5vdCB5ZXQgaGF2ZSBpdHMgb3duIHBhcmVudC5cbiAgICpcbiAgICogSWYgYHJlbmRlclBhcmVudGAgaXMgbm90IGBudWxsYCB0aGVuIGl0IG1heSBiZTpcbiAgICogLSBzYW1lIGFzIGB0Q29udGFpbmVyTm9kZS5wYXJlbnRgIGluIHdoaWNoIGNhc2UgaXQgaXMganVzdCBhIG5vcm1hbCBjb250YWluZXIuXG4gICAqIC0gZGlmZmVyZW50IGZyb20gYHRDb250YWluZXJOb2RlLnBhcmVudGAgaW4gd2hpY2ggY2FzZSBpdCBoYXMgYmVlbiByZS1wcm9qZWN0ZWQuXG4gICAqICAgSW4gb3RoZXIgd29yZHMgYHRDb250YWluZXJOb2RlLnBhcmVudGAgaXMgbG9naWNhbCBwYXJlbnQgd2hlcmUgYXNcbiAgICogICBgdENvbnRhaW5lck5vZGUucHJvamVjdGVkUGFyZW50YCBpcyByZW5kZXIgcGFyZW50LlxuICAgKlxuICAgKiBXaGVuIHZpZXdzIGFyZSBpbnNlcnRlZCBpbnRvIGBMQ29udGFpbmVyYCB0aGVuIGByZW5kZXJQYXJlbnRgIGlzOlxuICAgKiAtIGBudWxsYCwgd2UgYXJlIGluIGEgdmlldywga2VlcCBnb2luZyB1cCBhIGhpZXJhcmNoeSB1bnRpbCBhY3R1YWxcbiAgICogICBgcmVuZGVyUGFyZW50YCBpcyBmb3VuZC5cbiAgICogLSBub3QgYG51bGxgLCB0aGVuIHVzZSB0aGUgYHByb2plY3RlZFBhcmVudC5uYXRpdmVgIGFzIHRoZSBgUkVsZW1lbnRgIHRvIGluc2VydFxuICAgKiB2aWV3cyBpbnRvLlxuICAgKi9cbiAgW1JFTkRFUl9QQVJFTlRdOiBSRWxlbWVudHxudWxsO1xufVxuXG4vLyBOb3RlOiBUaGlzIGhhY2sgaXMgbmVjZXNzYXJ5IHNvIHdlIGRvbid0IGVycm9uZW91c2x5IGdldCBhIGNpcmN1bGFyIGRlcGVuZGVuY3lcbi8vIGZhaWx1cmUgYmFzZWQgb24gdHlwZXMuXG5leHBvcnQgY29uc3QgdW51c2VkVmFsdWVFeHBvcnRUb1BsYWNhdGVBamQgPSAxO1xuIl19