(function() {
  var CompositeDisposable, WrapGuideElement;

  CompositeDisposable = require('atom').CompositeDisposable;

  WrapGuideElement = require('./wrap-guide-element');

  module.exports = {
    activate: function() {
      this.subscriptions = new CompositeDisposable();
      this.wrapGuides = new Map();
      return this.subscriptions.add(atom.workspace.observeTextEditors((function(_this) {
        return function(editor) {
          var editorElement, wrapGuideElement;
          if (_this.wrapGuides.has(editor)) {
            return;
          }
          editorElement = atom.views.getView(editor);
          wrapGuideElement = new WrapGuideElement(editor, editorElement);
          _this.wrapGuides.set(editor, wrapGuideElement);
          return _this.subscriptions.add(editor.onDidDestroy(function() {
            _this.wrapGuides.get(editor).destroy();
            return _this.wrapGuides["delete"](editor);
          }));
        };
      })(this)));
    },
    deactivate: function() {
      this.subscriptions.dispose();
      this.wrapGuides.forEach(function(wrapGuide, editor) {
        return wrapGuide.destroy();
      });
      return this.wrapGuides.clear();
    },
    uniqueAscending: function(list) {
      return (list.filter(function(item, index) {
        return list.indexOf(item) === index;
      })).sort(function(a, b) {
        return a - b;
      });
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
