Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeyBindingResolverView = (function () {
  function KeyBindingResolverView() {
    var _this = this;

    _classCallCheck(this, KeyBindingResolverView);

    this.keystrokes = null;
    this.usedKeyBinding = null;
    this.unusedKeyBindings = [];
    this.unmatchedKeyBindings = [];
    this.partiallyMatchedBindings = [];
    this.attached = false;
    this.disposables = new _atom.CompositeDisposable();
    this.keybindingDisposables = new _atom.CompositeDisposable();

    this.disposables.add(atom.workspace.getBottomDock().observeActivePaneItem(function (item) {
      if (item === _this) {
        _this.attach();
      } else {
        _this.detach();
      }
    }));

    this.disposables.add(atom.workspace.getBottomDock().observeVisible(function (visible) {
      if (visible) {
        if (atom.workspace.getBottomDock().getActivePaneItem() === _this) _this.attach();
      } else {
        _this.detach();
      }
    }));

    _etch2['default'].initialize(this);
  }

  _createClass(KeyBindingResolverView, [{
    key: 'getTitle',
    value: function getTitle() {
      return 'Key Binding Resolver';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'keyboard';
    }
  }, {
    key: 'getDefaultLocation',
    value: function getDefaultLocation() {
      return 'bottom';
    }
  }, {
    key: 'getAllowedLocations',
    value: function getAllowedLocations() {
      // TODO: Support left and right possibly
      return ['bottom'];
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return 'atom://keybinding-resolver';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'keybinding-resolver/KeyBindingResolverView'
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.detach();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'attach',
    value: function attach() {
      var _this2 = this;

      if (this.attached) return;

      this.attached = true;
      this.keybindingDisposables = new _atom.CompositeDisposable();
      this.keybindingDisposables.add(atom.keymaps.onDidMatchBinding(function (_ref) {
        var keystrokes = _ref.keystrokes;
        var binding = _ref.binding;
        var keyboardEventTarget = _ref.keyboardEventTarget;
        var eventType = _ref.eventType;

        if (eventType === 'keyup' && binding == null) {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget }).filter(function (b) {
          return b !== binding;
        });

        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return b !== binding && !unusedKeyBindings.includes(b);
        });

        _this2.update({ usedKeyBinding: binding, unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));

      this.keybindingDisposables.add(atom.keymaps.onDidPartiallyMatchBindings(function (_ref2) {
        var keystrokes = _ref2.keystrokes;
        var partiallyMatchedBindings = _ref2.partiallyMatchedBindings;

        _this2.update({ keystrokes: keystrokes, partiallyMatchedBindings: partiallyMatchedBindings });
      }));

      this.keybindingDisposables.add(atom.keymaps.onDidFailToMatchBinding(function (_ref3) {
        var keystrokes = _ref3.keystrokes;
        var keyboardEventTarget = _ref3.keyboardEventTarget;
        var eventType = _ref3.eventType;

        if (eventType === 'keyup') {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget });
        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return !unusedKeyBindings.includes(b);
        });

        _this2.update({ unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));
    }
  }, {
    key: 'detach',
    value: function detach() {
      if (!this.attached) return;

      this.attached = false;
      this.keybindingDisposables.dispose();
      this.keybindingDisposables = null;
    }
  }, {
    key: 'update',
    value: function update(props) {
      this.keystrokes = props.keystrokes;
      this.usedKeyBinding = props.usedKeyBinding;
      this.unusedKeyBindings = props.unusedKeyBindings || [];
      this.unmatchedKeyBindings = props.unmatchedKeyBindings || [];
      this.partiallyMatchedBindings = props.partiallyMatchedBindings || [];
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'key-binding-resolver' },
        _etch2['default'].dom(
          'div',
          { className: 'panel-heading' },
          this.renderKeystrokes()
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panel-body' },
          this.renderKeyBindings()
        )
      );
    }
  }, {
    key: 'renderKeystrokes',
    value: function renderKeystrokes() {
      if (this.keystrokes) {
        if (this.partiallyMatchedBindings.length > 0) {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke highlight-info' },
            this.keystrokes,
            ' (partial)'
          );
        } else {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke highlight-info' },
            this.keystrokes
          );
        }
      } else {
        return _etch2['default'].dom(
          'span',
          null,
          'Press any key'
        );
      }
    }
  }, {
    key: 'renderKeyBindings',
    value: function renderKeyBindings() {
      var _this3 = this;

      if (this.partiallyMatchedBindings.length > 0) {
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            this.partiallyMatchedBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this3.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'keystrokes' },
                  binding.keystrokes
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this3.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      } else {
        var usedKeyBinding = '';
        if (this.usedKeyBinding) {
          usedKeyBinding = _etch2['default'].dom(
            'tr',
            { className: 'used' },
            _etch2['default'].dom(
              'td',
              { className: 'copy', onclick: function () {
                  return _this3.copyKeybinding(_this3.usedKeyBinding);
                } },
              _etch2['default'].dom('span', { className: 'icon icon-clippy' })
            ),
            _etch2['default'].dom(
              'td',
              { className: 'command' },
              this.usedKeyBinding.command
            ),
            _etch2['default'].dom(
              'td',
              { className: 'selector' },
              this.usedKeyBinding.selector
            ),
            _etch2['default'].dom(
              'td',
              { className: 'source', onclick: function () {
                  return _this3.openKeybindingFile(_this3.usedKeyBinding.source);
                } },
              this.usedKeyBinding.source
            )
          );
        }
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            usedKeyBinding,
            this.unusedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this3.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this3.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            }),
            this.unmatchedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unmatched' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this3.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this3.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      }
    }
  }, {
    key: 'isInAsarArchive',
    value: function isInAsarArchive(pathToCheck) {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      return pathToCheck.startsWith('' + resourcePath + _path2['default'].sep) && _path2['default'].extname(resourcePath) === '.asar';
    }
  }, {
    key: 'extractBundledKeymap',
    value: function extractBundledKeymap(bundledKeymapPath) {
      var metadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
      var bundledKeymaps = metadata ? metadata._atomKeymaps : {};
      var keymapName = _path2['default'].basename(bundledKeymapPath);
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(bundledKeymaps[keymapName] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'extractBundledPackageKeymap',
    value: function extractBundledPackageKeymap(keymapRelativePath) {
      var packageName = keymapRelativePath.split(_path2['default'].sep)[1];
      var keymapName = _path2['default'].basename(keymapRelativePath);
      var metadata = atom.packages.packagesCache[packageName] || {};
      var keymaps = metadata.keymaps || {};
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(keymaps[keymapRelativePath] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'openKeybindingFile',
    value: function openKeybindingFile(keymapPath) {
      if (this.isInAsarArchive(keymapPath)) {
        keymapPath = this.extractBundledKeymap(keymapPath);
      } else if (keymapPath.startsWith('core:node_modules')) {
        keymapPath = this.extractBundledPackageKeymap(keymapPath.replace('core:', ''));
      } else if (keymapPath.startsWith('core:')) {
        keymapPath = this.extractBundledKeymap(keymapPath.replace('core:', ''));
      }

      atom.workspace.open(keymapPath);
    }
  }, {
    key: 'copyKeybinding',
    value: function copyKeybinding(binding) {
      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      var escapedKeystrokes = binding.keystrokes.replace(/\\/g, '\\\\'); // Escape backslashes
      if (keymapExtension === '.cson') {
        content = '\'' + binding.selector + '\':\n  \'' + escapedKeystrokes + '\': \'' + binding.command + '\'\n';
      } else {
        content = '"' + binding.selector + '": {\n  "' + escapedKeystrokes + '": "' + binding.command + '"\n}\n';
      }

      atom.notifications.addInfo('Keybinding Copied');
      return atom.clipboard.write(content);
    }
  }]);

  return KeyBindingResolverView;
})();

exports['default'] = KeyBindingResolverView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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