"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _moment = _interopRequireDefault(require("moment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/updatePrReviewCommentMutation.graphql");

  if (node.hash && node.hash !== "d7b4e823f4604a2b193a1faceb3fcfca") {
    console.error("The definition of 'updatePrReviewCommentMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/updatePrReviewCommentMutation.graphql");
};

var _default = (environment, {
  commentId,
  commentBody
}) => {
  const variables = {
    input: {
      pullRequestReviewCommentId: commentId,
      body: commentBody
    }
  };
  const optimisticResponse = {
    updatePullRequestReviewComment: {
      pullRequestReviewComment: {
        id: commentId,
        lastEditedAt: (0, _moment["default"])().toISOString(),
        body: commentBody,
        bodyHTML: (0, _helpers.renderMarkdown)(commentBody)
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInVwZGF0ZS1wci1yZXZpZXctY29tbWVudC5qcyJdLCJuYW1lcyI6WyJtdXRhdGlvbiIsImVudmlyb25tZW50IiwiY29tbWVudElkIiwiY29tbWVudEJvZHkiLCJ2YXJpYWJsZXMiLCJpbnB1dCIsInB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudElkIiwiYm9keSIsIm9wdGltaXN0aWNSZXNwb25zZSIsInVwZGF0ZVB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudCIsInB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudCIsImlkIiwibGFzdEVkaXRlZEF0IiwidG9JU09TdHJpbmciLCJib2R5SFRNTCIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVqZWN0Iiwib25Db21wbGV0ZWQiLCJvbkVycm9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBRUE7O0FBQ0E7O0FBRUE7Ozs7QUFMQTtBQU9BLE1BQU1BLFFBQVE7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQSxDQUFkOztlQWFlLENBQUNDLFdBQUQsRUFBYztBQUFDQyxFQUFBQSxTQUFEO0FBQVlDLEVBQUFBO0FBQVosQ0FBZCxLQUEyQztBQUN4RCxRQUFNQyxTQUFTLEdBQUc7QUFDaEJDLElBQUFBLEtBQUssRUFBRTtBQUNMQyxNQUFBQSwwQkFBMEIsRUFBRUosU0FEdkI7QUFFTEssTUFBQUEsSUFBSSxFQUFFSjtBQUZEO0FBRFMsR0FBbEI7QUFPQSxRQUFNSyxrQkFBa0IsR0FBRztBQUN6QkMsSUFBQUEsOEJBQThCLEVBQUU7QUFDOUJDLE1BQUFBLHdCQUF3QixFQUFFO0FBQ3hCQyxRQUFBQSxFQUFFLEVBQUVULFNBRG9CO0FBRXhCVSxRQUFBQSxZQUFZLEVBQUUsMEJBQVNDLFdBQVQsRUFGVTtBQUd4Qk4sUUFBQUEsSUFBSSxFQUFFSixXQUhrQjtBQUl4QlcsUUFBQUEsUUFBUSxFQUFFLDZCQUFlWCxXQUFmO0FBSmM7QUFESTtBQURQLEdBQTNCO0FBV0EsU0FBTyxJQUFJWSxPQUFKLENBQVksQ0FBQ0MsT0FBRCxFQUFVQyxNQUFWLEtBQXFCO0FBQ3RDLG9DQUNFaEIsV0FERixFQUVFO0FBQ0VELE1BQUFBLFFBREY7QUFFRUksTUFBQUEsU0FGRjtBQUdFSSxNQUFBQSxrQkFIRjtBQUlFVSxNQUFBQSxXQUFXLEVBQUVGLE9BSmY7QUFLRUcsTUFBQUEsT0FBTyxFQUFFRjtBQUxYLEtBRkY7QUFVRCxHQVhNLENBQVA7QUFZRCxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuNDAuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBpc3RhbmJ1bCBpZ25vcmUgZmlsZSAqL1xuXG5pbXBvcnQge2NvbW1pdE11dGF0aW9uLCBncmFwaHFsfSBmcm9tICdyZWFjdC1yZWxheSc7XG5pbXBvcnQgbW9tZW50IGZyb20gJ21vbWVudCc7XG5cbmltcG9ydCB7cmVuZGVyTWFya2Rvd259IGZyb20gJy4uL2hlbHBlcnMnO1xuXG5jb25zdCBtdXRhdGlvbiA9IGdyYXBocWxgXG4gIG11dGF0aW9uIHVwZGF0ZVByUmV2aWV3Q29tbWVudE11dGF0aW9uKCRpbnB1dDogVXBkYXRlUHVsbFJlcXVlc3RSZXZpZXdDb21tZW50SW5wdXQhKSB7XG4gICAgdXBkYXRlUHVsbFJlcXVlc3RSZXZpZXdDb21tZW50KGlucHV0OiAkaW5wdXQpIHtcbiAgICAgIHB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudCB7XG4gICAgICAgIGlkXG4gICAgICAgIGxhc3RFZGl0ZWRBdFxuICAgICAgICBib2R5XG4gICAgICAgIGJvZHlIVE1MXG4gICAgICB9XG4gICAgfVxuICB9XG5gO1xuXG5leHBvcnQgZGVmYXVsdCAoZW52aXJvbm1lbnQsIHtjb21tZW50SWQsIGNvbW1lbnRCb2R5fSkgPT4ge1xuICBjb25zdCB2YXJpYWJsZXMgPSB7XG4gICAgaW5wdXQ6IHtcbiAgICAgIHB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudElkOiBjb21tZW50SWQsXG4gICAgICBib2R5OiBjb21tZW50Qm9keSxcbiAgICB9LFxuICB9O1xuXG4gIGNvbnN0IG9wdGltaXN0aWNSZXNwb25zZSA9IHtcbiAgICB1cGRhdGVQdWxsUmVxdWVzdFJldmlld0NvbW1lbnQ6IHtcbiAgICAgIHB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDoge1xuICAgICAgICBpZDogY29tbWVudElkLFxuICAgICAgICBsYXN0RWRpdGVkQXQ6IG1vbWVudCgpLnRvSVNPU3RyaW5nKCksXG4gICAgICAgIGJvZHk6IGNvbW1lbnRCb2R5LFxuICAgICAgICBib2R5SFRNTDogcmVuZGVyTWFya2Rvd24oY29tbWVudEJvZHkpLFxuICAgICAgfSxcbiAgICB9LFxuICB9O1xuXG4gIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgY29tbWl0TXV0YXRpb24oXG4gICAgICBlbnZpcm9ubWVudCxcbiAgICAgIHtcbiAgICAgICAgbXV0YXRpb24sXG4gICAgICAgIHZhcmlhYmxlcyxcbiAgICAgICAgb3B0aW1pc3RpY1Jlc3BvbnNlLFxuICAgICAgICBvbkNvbXBsZXRlZDogcmVzb2x2ZSxcbiAgICAgICAgb25FcnJvcjogcmVqZWN0LFxuICAgICAgfSxcbiAgICApO1xuICB9KTtcbn07XG4iXX0=