"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _createPullRequestTile = _interopRequireDefault(require("../views/create-pull-request-tile"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CurrentPullRequestContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    const head = this.props.branches.getHeadBranch();

    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }

    const pushRemote = this.props.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/currentPullRequestContainerQuery.graphql");

      if (node.hash && node.hash !== "b571ac1d752d4d13bc8e9bdffedb0a5e") {
        console.error("The definition of 'currentPullRequestContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/currentPullRequestContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit,
      checkSuiteCount: _helpers.CHECK_SUITE_PAGE_SIZE,
      checkSuiteCursor: null,
      checkRunCount: _helpers.CHECK_RUN_PAGE_SIZE,
      checkRunCursor: null
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    this.sub.dispose();
    this.sub = this.props.remoteOperationObserver.onDidComplete(() => this.forceUpdate());
    return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
      isLoading: false
    }, this.controllerProps()));
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;
    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      workspace: this.props.workspace,
      endpoint: this.props.endpoint,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react["default"].createElement(_createPullRequestTile["default"], {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenReviews: this.props.onOpenReviews,
      emptyComponent: this.renderEmptyTile,
      needReviewsButton: true
    };
  }

}

exports["default"] = CurrentPullRequestContainer;

_defineProperty(CurrentPullRequestContainer, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }).isRequired,
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search constraints
  limit: _propTypes["default"].number,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  // Actions
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired,
  onCreatePr: _propTypes["default"].func.isRequired
});

_defineProperty(CurrentPullRequestContainer, "defaultProps", {
  limit: 5
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImN1cnJlbnQtcHVsbC1yZXF1ZXN0LWNvbnRhaW5lci5qcyJdLCJuYW1lcyI6WyJDdXJyZW50UHVsbFJlcXVlc3RDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJzdWIiLCJEaXNwb3NhYmxlIiwicmVuZGVyIiwiZW52aXJvbm1lbnQiLCJSZWxheU5ldHdvcmtMYXllck1hbmFnZXIiLCJnZXRFbnZpcm9ubWVudEZvckhvc3QiLCJlbmRwb2ludCIsInRva2VuIiwiaGVhZCIsImJyYW5jaGVzIiwiZ2V0SGVhZEJyYW5jaCIsImlzUHJlc2VudCIsInJlbmRlckVtcHR5UmVzdWx0IiwicHVzaCIsImdldFB1c2giLCJpc1JlbW90ZVRyYWNraW5nIiwicHVzaFJlbW90ZSIsInJlbW90ZXMiLCJ3aXRoTmFtZSIsImdldFJlbW90ZU5hbWUiLCJpc0dpdGh1YlJlcG8iLCJxdWVyeSIsInZhcmlhYmxlcyIsImhlYWRPd25lciIsImdldE93bmVyIiwiaGVhZE5hbWUiLCJnZXRSZXBvIiwiaGVhZFJlZiIsImdldFJlbW90ZVJlZiIsImZpcnN0IiwibGltaXQiLCJjaGVja1N1aXRlQ291bnQiLCJDSEVDS19TVUlURV9QQUdFX1NJWkUiLCJjaGVja1N1aXRlQ3Vyc29yIiwiY2hlY2tSdW5Db3VudCIsIkNIRUNLX1JVTl9QQUdFX1NJWkUiLCJjaGVja1J1bkN1cnNvciIsInJlbmRlclF1ZXJ5UmVzdWx0IiwiZGlzcG9zZSIsInJlbW90ZU9wZXJhdGlvbk9ic2VydmVyIiwib25EaWRDb21wbGV0ZSIsImZvcmNlVXBkYXRlIiwiY29udHJvbGxlclByb3BzIiwiZXJyb3IiLCJyZXRyeSIsInJlcG9zaXRvcnkiLCJyZWYiLCJhc3NvY2lhdGVkUHVsbFJlcXVlc3RzIiwidG90YWxDb3VudCIsIm5vZGVzIiwid29ya3NwYWNlIiwiaXNzdWVpc2giLCJnZXRIZWFkUmVwb3NpdG9yeUlEIiwiaWQiLCJyZW5kZXJFbXB0eVRpbGUiLCJyZW1vdGUiLCJhaGVhZENvdW50IiwicHVzaEluUHJvZ3Jlc3MiLCJvbkNyZWF0ZVByIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJ0aXRsZSIsIm9uT3Blbklzc3VlaXNoIiwib25PcGVuUmV2aWV3cyIsImVtcHR5Q29tcG9uZW50IiwibmVlZFJldmlld3NCdXR0b24iLCJQcm9wVHlwZXMiLCJzaGFwZSIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJkZWZhdWx0QnJhbmNoUmVmIiwicHJlZml4IiwibmFtZSIsIkVuZHBvaW50UHJvcFR5cGUiLCJudW1iZXIiLCJPcGVyYXRpb25TdGF0ZU9ic2VydmVyUHJvcFR5cGUiLCJSZW1vdGVQcm9wVHlwZSIsIlJlbW90ZVNldFByb3BUeXBlIiwiQnJhbmNoU2V0UHJvcFR5cGUiLCJib29sIiwib2JqZWN0IiwiZnVuYyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUdBOztBQUNBOztBQUNBOzs7Ozs7Ozs7Ozs7QUFFZSxNQUFNQSwyQkFBTixTQUEwQ0Msa0JBQU1DLFNBQWhELENBQTBEO0FBc0N2RUMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjtBQUNBLDJCQUFTLElBQVQsRUFBZSxtQkFBZixFQUFvQyxpQkFBcEM7QUFFQSxTQUFLQyxHQUFMLEdBQVcsSUFBSUMsb0JBQUosRUFBWDtBQUNEOztBQUVEQyxFQUFBQSxNQUFNLEdBQUc7QUFDUCxVQUFNQyxXQUFXLEdBQUdDLHFDQUF5QkMscUJBQXpCLENBQStDLEtBQUtOLEtBQUwsQ0FBV08sUUFBMUQsRUFBb0UsS0FBS1AsS0FBTCxDQUFXUSxLQUEvRSxDQUFwQjs7QUFFQSxVQUFNQyxJQUFJLEdBQUcsS0FBS1QsS0FBTCxDQUFXVSxRQUFYLENBQW9CQyxhQUFwQixFQUFiOztBQUNBLFFBQUksQ0FBQ0YsSUFBSSxDQUFDRyxTQUFMLEVBQUwsRUFBdUI7QUFDckIsYUFBTyxLQUFLQyxpQkFBTCxFQUFQO0FBQ0Q7O0FBQ0QsVUFBTUMsSUFBSSxHQUFHTCxJQUFJLENBQUNNLE9BQUwsRUFBYjs7QUFDQSxRQUFJLENBQUNELElBQUksQ0FBQ0YsU0FBTCxFQUFELElBQXFCLENBQUNFLElBQUksQ0FBQ0UsZ0JBQUwsRUFBMUIsRUFBbUQ7QUFDakQsYUFBTyxLQUFLSCxpQkFBTCxFQUFQO0FBQ0Q7O0FBQ0QsVUFBTUksVUFBVSxHQUFHLEtBQUtqQixLQUFMLENBQVdrQixPQUFYLENBQW1CQyxRQUFuQixDQUE0QkwsSUFBSSxDQUFDTSxhQUFMLEVBQTVCLENBQW5COztBQUNBLFFBQUksQ0FBQ0gsVUFBVSxDQUFDTCxTQUFYLEVBQUQsSUFBMkIsQ0FBQ0ssVUFBVSxDQUFDSSxZQUFYLEVBQWhDLEVBQTJEO0FBQ3pELGFBQU8sS0FBS1IsaUJBQUwsRUFBUDtBQUNEOztBQUVELFVBQU1TLEtBQUs7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQSxNQUFYOztBQTRCQSxVQUFNQyxTQUFTLEdBQUc7QUFDaEJDLE1BQUFBLFNBQVMsRUFBRVAsVUFBVSxDQUFDUSxRQUFYLEVBREs7QUFFaEJDLE1BQUFBLFFBQVEsRUFBRVQsVUFBVSxDQUFDVSxPQUFYLEVBRk07QUFHaEJDLE1BQUFBLE9BQU8sRUFBRWQsSUFBSSxDQUFDZSxZQUFMLEVBSE87QUFJaEJDLE1BQUFBLEtBQUssRUFBRSxLQUFLOUIsS0FBTCxDQUFXK0IsS0FKRjtBQUtoQkMsTUFBQUEsZUFBZSxFQUFFQyw4QkFMRDtBQU1oQkMsTUFBQUEsZ0JBQWdCLEVBQUUsSUFORjtBQU9oQkMsTUFBQUEsYUFBYSxFQUFFQyw0QkFQQztBQVFoQkMsTUFBQUEsY0FBYyxFQUFFO0FBUkEsS0FBbEI7QUFXQSxXQUNFLGdDQUFDLHlCQUFEO0FBQ0UsTUFBQSxXQUFXLEVBQUVqQyxXQURmO0FBRUUsTUFBQSxTQUFTLEVBQUVtQixTQUZiO0FBR0UsTUFBQSxLQUFLLEVBQUVELEtBSFQ7QUFJRSxNQUFBLE1BQU0sRUFBRSxLQUFLZ0I7QUFKZixNQURGO0FBUUQ7O0FBRUR6QixFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixTQUFLWixHQUFMLENBQVNzQyxPQUFUO0FBQ0EsU0FBS3RDLEdBQUwsR0FBVyxLQUFLRCxLQUFMLENBQVd3Qyx1QkFBWCxDQUFtQ0MsYUFBbkMsQ0FBaUQsTUFBTSxLQUFLQyxXQUFMLEVBQXZELENBQVg7QUFFQSxXQUFPLGdDQUFDLGtEQUFEO0FBQTRCLE1BQUEsU0FBUyxFQUFFO0FBQXZDLE9BQWtELEtBQUtDLGVBQUwsRUFBbEQsRUFBUDtBQUNEOztBQUVETCxFQUFBQSxpQkFBaUIsQ0FBQztBQUFDTSxJQUFBQSxLQUFEO0FBQVE1QyxJQUFBQSxLQUFSO0FBQWU2QyxJQUFBQTtBQUFmLEdBQUQsRUFBd0I7QUFDdkMsUUFBSUEsS0FBSixFQUFXO0FBQ1QsV0FBSzVDLEdBQUwsQ0FBU3NDLE9BQVQ7QUFDQSxXQUFLdEMsR0FBTCxHQUFXLEtBQUtELEtBQUwsQ0FBV3dDLHVCQUFYLENBQW1DQyxhQUFuQyxDQUFpREksS0FBakQsQ0FBWDtBQUNEOztBQUVELFFBQUlELEtBQUosRUFBVztBQUNULGFBQ0UsZ0NBQUMsa0RBQUQ7QUFDRSxRQUFBLFNBQVMsRUFBRSxLQURiO0FBRUUsUUFBQSxLQUFLLEVBQUVBO0FBRlQsU0FHTSxLQUFLRCxlQUFMLEVBSE4sRUFERjtBQU9EOztBQUVELFFBQUkzQyxLQUFLLEtBQUssSUFBZCxFQUFvQjtBQUNsQixhQUNFLGdDQUFDLGtEQUFEO0FBQ0UsUUFBQSxTQUFTLEVBQUU7QUFEYixTQUVNLEtBQUsyQyxlQUFMLEVBRk4sRUFERjtBQU1EOztBQUVELFFBQUksQ0FBQzNDLEtBQUssQ0FBQzhDLFVBQVAsSUFBcUIsQ0FBQzlDLEtBQUssQ0FBQzhDLFVBQU4sQ0FBaUJDLEdBQTNDLEVBQWdEO0FBQzlDLGFBQU8sZ0NBQUMsa0RBQUQ7QUFBNEIsUUFBQSxTQUFTLEVBQUU7QUFBdkMsU0FBa0QsS0FBS0osZUFBTCxFQUFsRCxFQUFQO0FBQ0Q7O0FBRUQsVUFBTUssc0JBQXNCLEdBQUdoRCxLQUFLLENBQUM4QyxVQUFOLENBQWlCQyxHQUFqQixDQUFxQkMsc0JBQXBEO0FBRUEsV0FDRSxnQ0FBQyxrQ0FBRDtBQUNFLE1BQUEsS0FBSyxFQUFFQSxzQkFBc0IsQ0FBQ0MsVUFEaEM7QUFFRSxNQUFBLE9BQU8sRUFBRUQsc0JBQXNCLENBQUNFLEtBRmxDO0FBR0UsTUFBQSxTQUFTLEVBQUUsS0FIYjtBQUlFLE1BQUEsU0FBUyxFQUFFLEtBQUtsRCxLQUFMLENBQVdtRCxTQUp4QjtBQUtFLE1BQUEsUUFBUSxFQUFFLEtBQUtuRCxLQUFMLENBQVdPLFFBTHZCO0FBTUUsTUFBQSxZQUFZLEVBQUU2QyxRQUFRLElBQUlBLFFBQVEsQ0FBQ0MsbUJBQVQsT0FBbUMsS0FBS3JELEtBQUwsQ0FBVzhDLFVBQVgsQ0FBc0JRO0FBTnJGLE9BT00sS0FBS1gsZUFBTCxFQVBOLEVBREY7QUFXRDs7QUFFRFksRUFBQUEsZUFBZSxHQUFHO0FBQ2hCLFdBQ0UsZ0NBQUMsaUNBQUQ7QUFDRSxNQUFBLFVBQVUsRUFBRSxLQUFLdkQsS0FBTCxDQUFXOEMsVUFEekI7QUFFRSxNQUFBLE1BQU0sRUFBRSxLQUFLOUMsS0FBTCxDQUFXd0QsTUFGckI7QUFHRSxNQUFBLFFBQVEsRUFBRSxLQUFLeEQsS0FBTCxDQUFXVSxRQUh2QjtBQUlFLE1BQUEsVUFBVSxFQUFFLEtBQUtWLEtBQUwsQ0FBV3lELFVBSnpCO0FBS0UsTUFBQSxjQUFjLEVBQUUsS0FBS3pELEtBQUwsQ0FBVzBELGNBTDdCO0FBTUUsTUFBQSxVQUFVLEVBQUUsS0FBSzFELEtBQUwsQ0FBVzJEO0FBTnpCLE1BREY7QUFVRDs7QUFFREMsRUFBQUEsb0JBQW9CLEdBQUc7QUFDckIsU0FBSzNELEdBQUwsQ0FBU3NDLE9BQVQ7QUFDRDs7QUFFREksRUFBQUEsZUFBZSxHQUFHO0FBQ2hCLFdBQU87QUFDTGtCLE1BQUFBLEtBQUssRUFBRSwwQkFERjtBQUVMQyxNQUFBQSxjQUFjLEVBQUUsS0FBSzlELEtBQUwsQ0FBVzhELGNBRnRCO0FBR0xDLE1BQUFBLGFBQWEsRUFBRSxLQUFLL0QsS0FBTCxDQUFXK0QsYUFIckI7QUFJTEMsTUFBQUEsY0FBYyxFQUFFLEtBQUtULGVBSmhCO0FBS0xVLE1BQUFBLGlCQUFpQixFQUFFO0FBTGQsS0FBUDtBQU9EOztBQTFMc0U7Ozs7Z0JBQXBEckUsMkIsZUFDQTtBQUNqQjtBQUNBa0QsRUFBQUEsVUFBVSxFQUFFb0Isc0JBQVVDLEtBQVYsQ0FBZ0I7QUFDMUJiLElBQUFBLEVBQUUsRUFBRVksc0JBQVVFLE1BQVYsQ0FBaUJDLFVBREs7QUFFMUJDLElBQUFBLGdCQUFnQixFQUFFSixzQkFBVUMsS0FBVixDQUFnQjtBQUNoQ0ksTUFBQUEsTUFBTSxFQUFFTCxzQkFBVUUsTUFBVixDQUFpQkMsVUFETztBQUVoQ0csTUFBQUEsSUFBSSxFQUFFTixzQkFBVUUsTUFBVixDQUFpQkM7QUFGUyxLQUFoQjtBQUZRLEdBQWhCLEVBTVRBLFVBUmM7QUFVakI7QUFDQTlELEVBQUFBLFFBQVEsRUFBRWtFLDZCQUFpQkosVUFYVjtBQVlqQjdELEVBQUFBLEtBQUssRUFBRTBELHNCQUFVRSxNQUFWLENBQWlCQyxVQVpQO0FBY2pCO0FBQ0F0QyxFQUFBQSxLQUFLLEVBQUVtQyxzQkFBVVEsTUFmQTtBQWlCakI7QUFDQWxDLEVBQUFBLHVCQUF1QixFQUFFbUMsMkNBQStCTixVQWxCdkM7QUFtQmpCYixFQUFBQSxNQUFNLEVBQUVvQiwyQkFBZVAsVUFuQk47QUFvQmpCbkQsRUFBQUEsT0FBTyxFQUFFMkQsOEJBQWtCUixVQXBCVjtBQXFCakIzRCxFQUFBQSxRQUFRLEVBQUVvRSw4QkFBa0JULFVBckJYO0FBc0JqQlosRUFBQUEsVUFBVSxFQUFFUyxzQkFBVVEsTUF0Qkw7QUF1QmpCaEIsRUFBQUEsY0FBYyxFQUFFUSxzQkFBVWEsSUFBVixDQUFlVixVQXZCZDtBQXlCakJsQixFQUFBQSxTQUFTLEVBQUVlLHNCQUFVYyxNQUFWLENBQWlCWCxVQXpCWDtBQTJCakI7QUFDQVAsRUFBQUEsY0FBYyxFQUFFSSxzQkFBVWUsSUFBVixDQUFlWixVQTVCZDtBQTZCakJOLEVBQUFBLGFBQWEsRUFBRUcsc0JBQVVlLElBQVYsQ0FBZVosVUE3QmI7QUE4QmpCVixFQUFBQSxVQUFVLEVBQUVPLHNCQUFVZSxJQUFWLENBQWVaO0FBOUJWLEM7O2dCQURBekUsMkIsa0JBa0NHO0FBQ3BCbUMsRUFBQUEsS0FBSyxFQUFFO0FBRGEsQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjQwLjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge1F1ZXJ5UmVuZGVyZXIsIGdyYXBocWx9IGZyb20gJ3JlYWN0LXJlbGF5JztcbmltcG9ydCB7RGlzcG9zYWJsZX0gZnJvbSAnZXZlbnQta2l0JztcblxuaW1wb3J0IHthdXRvYmluZCwgQ0hFQ0tfU1VJVEVfUEFHRV9TSVpFLCBDSEVDS19SVU5fUEFHRV9TSVpFfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCB7XG4gIFJlbW90ZVByb3BUeXBlLCBSZW1vdGVTZXRQcm9wVHlwZSwgQnJhbmNoU2V0UHJvcFR5cGUsIE9wZXJhdGlvblN0YXRlT2JzZXJ2ZXJQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZSxcbn0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgSXNzdWVpc2hMaXN0Q29udHJvbGxlciwge0JhcmVJc3N1ZWlzaExpc3RDb250cm9sbGVyfSBmcm9tICcuLi9jb250cm9sbGVycy9pc3N1ZWlzaC1saXN0LWNvbnRyb2xsZXInO1xuaW1wb3J0IENyZWF0ZVB1bGxSZXF1ZXN0VGlsZSBmcm9tICcuLi92aWV3cy9jcmVhdGUtcHVsbC1yZXF1ZXN0LXRpbGUnO1xuaW1wb3J0IFJlbGF5TmV0d29ya0xheWVyTWFuYWdlciBmcm9tICcuLi9yZWxheS1uZXR3b3JrLWxheWVyLW1hbmFnZXInO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDdXJyZW50UHVsbFJlcXVlc3RDb250YWluZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIC8vIFJlbGF5IHBheWxvYWRcbiAgICByZXBvc2l0b3J5OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIGRlZmF1bHRCcmFuY2hSZWY6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIHByZWZpeDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICBuYW1lOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICB9KSxcbiAgICB9KS5pc1JlcXVpcmVkLFxuXG4gICAgLy8gQ29ubmVjdGlvblxuICAgIGVuZHBvaW50OiBFbmRwb2ludFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgdG9rZW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcblxuICAgIC8vIFNlYXJjaCBjb25zdHJhaW50c1xuICAgIGxpbWl0OiBQcm9wVHlwZXMubnVtYmVyLFxuXG4gICAgLy8gUmVwb3NpdG9yeSBtb2RlbCBhdHRyaWJ1dGVzXG4gICAgcmVtb3RlT3BlcmF0aW9uT2JzZXJ2ZXI6IE9wZXJhdGlvblN0YXRlT2JzZXJ2ZXJQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHJlbW90ZTogUmVtb3RlUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICByZW1vdGVzOiBSZW1vdGVTZXRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGJyYW5jaGVzOiBCcmFuY2hTZXRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGFoZWFkQ291bnQ6IFByb3BUeXBlcy5udW1iZXIsXG4gICAgcHVzaEluUHJvZ3Jlc3M6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG5cbiAgICB3b3Jrc3BhY2U6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcblxuICAgIC8vIEFjdGlvbnNcbiAgICBvbk9wZW5Jc3N1ZWlzaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBvbk9wZW5SZXZpZXdzOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9uQ3JlYXRlUHI6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGxpbWl0OiA1LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gICAgYXV0b2JpbmQodGhpcywgJ3JlbmRlclF1ZXJ5UmVzdWx0JywgJ3JlbmRlckVtcHR5VGlsZScpO1xuXG4gICAgdGhpcy5zdWIgPSBuZXcgRGlzcG9zYWJsZSgpO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IGVudmlyb25tZW50ID0gUmVsYXlOZXR3b3JrTGF5ZXJNYW5hZ2VyLmdldEVudmlyb25tZW50Rm9ySG9zdCh0aGlzLnByb3BzLmVuZHBvaW50LCB0aGlzLnByb3BzLnRva2VuKTtcblxuICAgIGNvbnN0IGhlYWQgPSB0aGlzLnByb3BzLmJyYW5jaGVzLmdldEhlYWRCcmFuY2goKTtcbiAgICBpZiAoIWhlYWQuaXNQcmVzZW50KCkpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlbmRlckVtcHR5UmVzdWx0KCk7XG4gICAgfVxuICAgIGNvbnN0IHB1c2ggPSBoZWFkLmdldFB1c2goKTtcbiAgICBpZiAoIXB1c2guaXNQcmVzZW50KCkgfHwgIXB1c2guaXNSZW1vdGVUcmFja2luZygpKSB7XG4gICAgICByZXR1cm4gdGhpcy5yZW5kZXJFbXB0eVJlc3VsdCgpO1xuICAgIH1cbiAgICBjb25zdCBwdXNoUmVtb3RlID0gdGhpcy5wcm9wcy5yZW1vdGVzLndpdGhOYW1lKHB1c2guZ2V0UmVtb3RlTmFtZSgpKTtcbiAgICBpZiAoIXB1c2hSZW1vdGUuaXNQcmVzZW50KCkgfHwgIXB1c2hSZW1vdGUuaXNHaXRodWJSZXBvKCkpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlbmRlckVtcHR5UmVzdWx0KCk7XG4gICAgfVxuXG4gICAgY29uc3QgcXVlcnkgPSBncmFwaHFsYFxuICAgICAgcXVlcnkgY3VycmVudFB1bGxSZXF1ZXN0Q29udGFpbmVyUXVlcnkoXG4gICAgICAgICRoZWFkT3duZXI6IFN0cmluZyFcbiAgICAgICAgJGhlYWROYW1lOiBTdHJpbmchXG4gICAgICAgICRoZWFkUmVmOiBTdHJpbmchXG4gICAgICAgICRmaXJzdDogSW50IVxuICAgICAgICAkY2hlY2tTdWl0ZUNvdW50OiBJbnQhXG4gICAgICAgICRjaGVja1N1aXRlQ3Vyc29yOiBTdHJpbmdcbiAgICAgICAgJGNoZWNrUnVuQ291bnQ6IEludCFcbiAgICAgICAgJGNoZWNrUnVuQ3Vyc29yOiBTdHJpbmdcbiAgICAgICkge1xuICAgICAgICByZXBvc2l0b3J5KG93bmVyOiAkaGVhZE93bmVyLCBuYW1lOiAkaGVhZE5hbWUpIHtcbiAgICAgICAgICByZWYocXVhbGlmaWVkTmFtZTogJGhlYWRSZWYpIHtcbiAgICAgICAgICAgIGFzc29jaWF0ZWRQdWxsUmVxdWVzdHMoZmlyc3Q6ICRmaXJzdCwgc3RhdGVzOiBbT1BFTl0pIHtcbiAgICAgICAgICAgICAgdG90YWxDb3VudFxuICAgICAgICAgICAgICBub2RlcyB7XG4gICAgICAgICAgICAgICAgLi4uaXNzdWVpc2hMaXN0Q29udHJvbGxlcl9yZXN1bHRzIEBhcmd1bWVudHMoXG4gICAgICAgICAgICAgICAgICBjaGVja1N1aXRlQ291bnQ6ICRjaGVja1N1aXRlQ291bnRcbiAgICAgICAgICAgICAgICAgIGNoZWNrU3VpdGVDdXJzb3I6ICRjaGVja1N1aXRlQ3Vyc29yXG4gICAgICAgICAgICAgICAgICBjaGVja1J1bkNvdW50OiAkY2hlY2tSdW5Db3VudFxuICAgICAgICAgICAgICAgICAgY2hlY2tSdW5DdXJzb3I6ICRjaGVja1J1bkN1cnNvclxuICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIGA7XG4gICAgY29uc3QgdmFyaWFibGVzID0ge1xuICAgICAgaGVhZE93bmVyOiBwdXNoUmVtb3RlLmdldE93bmVyKCksXG4gICAgICBoZWFkTmFtZTogcHVzaFJlbW90ZS5nZXRSZXBvKCksXG4gICAgICBoZWFkUmVmOiBwdXNoLmdldFJlbW90ZVJlZigpLFxuICAgICAgZmlyc3Q6IHRoaXMucHJvcHMubGltaXQsXG4gICAgICBjaGVja1N1aXRlQ291bnQ6IENIRUNLX1NVSVRFX1BBR0VfU0laRSxcbiAgICAgIGNoZWNrU3VpdGVDdXJzb3I6IG51bGwsXG4gICAgICBjaGVja1J1bkNvdW50OiBDSEVDS19SVU5fUEFHRV9TSVpFLFxuICAgICAgY2hlY2tSdW5DdXJzb3I6IG51bGwsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8UXVlcnlSZW5kZXJlclxuICAgICAgICBlbnZpcm9ubWVudD17ZW52aXJvbm1lbnR9XG4gICAgICAgIHZhcmlhYmxlcz17dmFyaWFibGVzfVxuICAgICAgICBxdWVyeT17cXVlcnl9XG4gICAgICAgIHJlbmRlcj17dGhpcy5yZW5kZXJRdWVyeVJlc3VsdH1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckVtcHR5UmVzdWx0KCkge1xuICAgIHRoaXMuc3ViLmRpc3Bvc2UoKTtcbiAgICB0aGlzLnN1YiA9IHRoaXMucHJvcHMucmVtb3RlT3BlcmF0aW9uT2JzZXJ2ZXIub25EaWRDb21wbGV0ZSgoKSA9PiB0aGlzLmZvcmNlVXBkYXRlKCkpO1xuXG4gICAgcmV0dXJuIDxCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlciBpc0xvYWRpbmc9e2ZhbHNlfSB7Li4udGhpcy5jb250cm9sbGVyUHJvcHMoKX0gLz47XG4gIH1cblxuICByZW5kZXJRdWVyeVJlc3VsdCh7ZXJyb3IsIHByb3BzLCByZXRyeX0pIHtcbiAgICBpZiAocmV0cnkpIHtcbiAgICAgIHRoaXMuc3ViLmRpc3Bvc2UoKTtcbiAgICAgIHRoaXMuc3ViID0gdGhpcy5wcm9wcy5yZW1vdGVPcGVyYXRpb25PYnNlcnZlci5vbkRpZENvbXBsZXRlKHJldHJ5KTtcbiAgICB9XG5cbiAgICBpZiAoZXJyb3IpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlclxuICAgICAgICAgIGlzTG9hZGluZz17ZmFsc2V9XG4gICAgICAgICAgZXJyb3I9e2Vycm9yfVxuICAgICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMgPT09IG51bGwpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlclxuICAgICAgICAgIGlzTG9hZGluZz17dHJ1ZX1cbiAgICAgICAgICB7Li4udGhpcy5jb250cm9sbGVyUHJvcHMoKX1cbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgfVxuXG4gICAgaWYgKCFwcm9wcy5yZXBvc2l0b3J5IHx8ICFwcm9wcy5yZXBvc2l0b3J5LnJlZikge1xuICAgICAgcmV0dXJuIDxCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlciBpc0xvYWRpbmc9e2ZhbHNlfSB7Li4udGhpcy5jb250cm9sbGVyUHJvcHMoKX0gLz47XG4gICAgfVxuXG4gICAgY29uc3QgYXNzb2NpYXRlZFB1bGxSZXF1ZXN0cyA9IHByb3BzLnJlcG9zaXRvcnkucmVmLmFzc29jaWF0ZWRQdWxsUmVxdWVzdHM7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPElzc3VlaXNoTGlzdENvbnRyb2xsZXJcbiAgICAgICAgdG90YWw9e2Fzc29jaWF0ZWRQdWxsUmVxdWVzdHMudG90YWxDb3VudH1cbiAgICAgICAgcmVzdWx0cz17YXNzb2NpYXRlZFB1bGxSZXF1ZXN0cy5ub2Rlc31cbiAgICAgICAgaXNMb2FkaW5nPXtmYWxzZX1cbiAgICAgICAgd29ya3NwYWNlPXt0aGlzLnByb3BzLndvcmtzcGFjZX1cbiAgICAgICAgZW5kcG9pbnQ9e3RoaXMucHJvcHMuZW5kcG9pbnR9XG4gICAgICAgIHJlc3VsdEZpbHRlcj17aXNzdWVpc2ggPT4gaXNzdWVpc2guZ2V0SGVhZFJlcG9zaXRvcnlJRCgpID09PSB0aGlzLnByb3BzLnJlcG9zaXRvcnkuaWR9XG4gICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyRW1wdHlUaWxlKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8Q3JlYXRlUHVsbFJlcXVlc3RUaWxlXG4gICAgICAgIHJlcG9zaXRvcnk9e3RoaXMucHJvcHMucmVwb3NpdG9yeX1cbiAgICAgICAgcmVtb3RlPXt0aGlzLnByb3BzLnJlbW90ZX1cbiAgICAgICAgYnJhbmNoZXM9e3RoaXMucHJvcHMuYnJhbmNoZXN9XG4gICAgICAgIGFoZWFkQ291bnQ9e3RoaXMucHJvcHMuYWhlYWRDb3VudH1cbiAgICAgICAgcHVzaEluUHJvZ3Jlc3M9e3RoaXMucHJvcHMucHVzaEluUHJvZ3Jlc3N9XG4gICAgICAgIG9uQ3JlYXRlUHI9e3RoaXMucHJvcHMub25DcmVhdGVQcn1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMuc3ViLmRpc3Bvc2UoKTtcbiAgfVxuXG4gIGNvbnRyb2xsZXJQcm9wcygpIHtcbiAgICByZXR1cm4ge1xuICAgICAgdGl0bGU6ICdDaGVja2VkIG91dCBwdWxsIHJlcXVlc3QnLFxuICAgICAgb25PcGVuSXNzdWVpc2g6IHRoaXMucHJvcHMub25PcGVuSXNzdWVpc2gsXG4gICAgICBvbk9wZW5SZXZpZXdzOiB0aGlzLnByb3BzLm9uT3BlblJldmlld3MsXG4gICAgICBlbXB0eUNvbXBvbmVudDogdGhpcy5yZW5kZXJFbXB0eVRpbGUsXG4gICAgICBuZWVkUmV2aWV3c0J1dHRvbjogdHJ1ZSxcbiAgICB9O1xuICB9XG59XG4iXX0=