"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _commentDecorationsController = _interopRequireDefault(require("../controllers/comment-decorations-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _helpers = require("../helpers");

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _commentPositioningContainer = _interopRequireDefault(require("./comment-positioning-container"));

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommentDecorationsContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithLocalRepositoryData", repoData => {
      if (!repoData) {
        return null;
      }

      return _react["default"].createElement(_observeModel["default"], {
        model: this.props.loginModel,
        fetchParams: [repoData],
        fetchData: this.fetchToken
      }, token => this.renderWithToken(token, {
        repoData
      }));
    });

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        currentRemote: repository.getCurrentGitHubRemote(),
        workingDirectoryPath: repository.getWorkingDirectoryPath()
      });
    });

    _defineProperty(this, "fetchToken", (loginModel, repoData) => {
      const endpoint = repoData.currentRemote.getEndpoint();

      if (!endpoint) {
        return null;
      }

      return loginModel.getToken(endpoint.getLoginAccount());
    });
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.localRepository,
      fetchData: this.fetchRepositoryData
    }, this.renderWithLocalRepositoryData);
  }

  renderWithToken(token, {
    repoData
  }) {
    if (!token || token === _keytarStrategy.UNAUTHENTICATED || token === _keytarStrategy.INSUFFICIENT || token instanceof Error) {
      // we're not going to prompt users to log in to render decorations for comments
      // just let it go and move on with our lives.
      return null;
    }

    const head = repoData.branches.getHeadBranch();

    if (!head.isPresent()) {
      return null;
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return null;
    }

    const pushRemote = repoData.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return null;
    }

    const endpoint = repoData.currentRemote.getEndpoint();

    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/commentDecorationsContainerQuery.graphql");

      if (node.hash && node.hash !== "8154acbf4c24d190f6fdf0254ae73817") {
        console.error("The definition of 'commentDecorationsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/commentDecorationsContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: 1,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithPullRequest(_objectSpread({
        endpoint,
        owner: variables.headOwner,
        repo: variables.headName
      }, queryResult), {
        repoData,
        token
      })
    }));
  }

  renderWithPullRequest({
    error,
    props,
    endpoint,
    owner,
    repo
  }, {
    repoData,
    token
  }) {
    if (error) {
      // eslint-disable-next-line no-console
      console.warn(`error fetching CommentDecorationsContainer data: ${error}`);
      return null;
    }

    if (!props || !props.repository || !props.repository.ref || props.repository.ref.associatedPullRequests.totalCount === 0) {
      // no loading spinner for you
      // just fetch silently behind the scenes like a good little container
      return null;
    }

    const currentPullRequest = props.repository.ref.associatedPullRequests.nodes[0];
    return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
      pullRequest: currentPullRequest,
      reportRelayError: this.props.reportRelayError
    }, ({
      errors,
      summaries,
      commentThreads
    }) => {
      return this.renderWithReviews({
        errors,
        summaries,
        commentThreads
      }, {
        currentPullRequest,
        repoResult: props,
        endpoint,
        owner,
        repo,
        repoData,
        token
      });
    });
  }

  renderWithReviews({
    errors,
    summaries,
    commentThreads
  }, {
    currentPullRequest,
    repoResult,
    endpoint,
    owner,
    repo,
    repoData,
    token
  }) {
    if (errors && errors.length > 0) {
      // eslint-disable-next-line no-console
      console.warn('Errors aggregating reviews and comments for current pull request', ...errors);
      return null;
    }

    if (commentThreads.length === 0) {
      return null;
    }

    return _react["default"].createElement(_prPatchContainer["default"], {
      owner: owner,
      repo: repo,
      number: currentPullRequest.number,
      endpoint: endpoint,
      token: token,
      largeDiffThreshold: Infinity
    }, (patchError, patch) => this.renderWithPatch({
      error: patchError,
      patch
    }, {
      summaries,
      commentThreads,
      currentPullRequest,
      repoResult,
      endpoint,
      owner,
      repo,
      repoData,
      token
    }));
  }

  renderWithPatch({
    error,
    patch
  }, {
    summaries,
    commentThreads,
    currentPullRequest,
    repoResult,
    endpoint,
    owner,
    repo,
    repoData,
    token
  }) {
    if (error) {
      // eslint-disable-next-line no-console
      console.warn('Error fetching patch for current pull request', error);
      return null;
    }

    if (!patch) {
      return null;
    }

    return _react["default"].createElement(_commentPositioningContainer["default"], {
      multiFilePatch: patch,
      commentThreads: commentThreads,
      prCommitSha: currentPullRequest.headRefOid,
      localRepository: this.props.localRepository,
      workdir: repoData.workingDirectoryPath
    }, commentTranslations => {
      if (!commentTranslations) {
        return null;
      }

      return _react["default"].createElement(_commentDecorationsController["default"], {
        endpoint: endpoint,
        owner: owner,
        repo: repo,
        workspace: this.props.workspace,
        commands: this.props.commands,
        repoData: repoData,
        commentThreads: commentThreads,
        commentTranslations: commentTranslations,
        pullRequests: repoResult.repository.ref.associatedPullRequests.nodes
      });
    });
  }

}

exports["default"] = CommentDecorationsContainer;

_defineProperty(CommentDecorationsContainer, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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