/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalAprInputBuffer;
import org.apache.coyote.http11.InternalAprOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProcessor
extends AbstractHttp11Processor<Long> {
    private static final Log log = LogFactory.getLog(Http11AprProcessor.class);
    protected InternalAprInputBuffer inputBuffer = null;
    protected InternalAprOutputBuffer outputBuffer = null;
    protected AprEndpoint.SendfileData sendfileData = null;
    protected String clientCertProvider = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11AprProcessor(int headerBufferSize, boolean rejectIllegalHeaderName, AprEndpoint endpoint, int maxTrailerSize, Set<String> allowedTrailerHeaders, int maxExtensionSize, int maxSwallowSize) {
        super(endpoint);
        this.inputBuffer = new InternalAprInputBuffer(this.request, headerBufferSize, rejectIllegalHeaderName);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalAprOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize, allowedTrailerHeaders, maxExtensionSize, maxSwallowSize);
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            if (!this.getAdapter().event(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            this.getAdapter().log(this.request, this.response, 0L);
            log.error((Object)sm.getString("http11processor.request.process"), t);
        }
        rp.setStage(7);
        if (this.getErrorState().isError() || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        return true;
    }

    @Override
    protected void setSocketTimeout(int timeout) {
        Socket.timeoutSet((Long)this.socketWrapper.getSocket(), timeout * 1000);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Long> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Long> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            this.sendfileData.socket = socketWrapper.getSocket();
            this.sendfileData.keepAliveState = this.keepAlive ? (this.getInputBuffer().available() == 0 ? SendfileKeepAliveState.OPEN : SendfileKeepAliveState.PIPELINED) : SendfileKeepAliveState.NONE;
            switch (((AprEndpoint)this.endpoint).getSendfile().add(this.sendfileData)) {
                case DONE: {
                    return false;
                }
                case PENDING: {
                    this.sendfileInProgress = true;
                    return true;
                }
                case ERROR: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    public void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        long socketRef = (Long)this.socketWrapper.getSocket();
        switch (actionCode) {
            case REQ_HOST_ADDR_ATTRIBUTE: {
                if (this.remoteAddr == null && socketRef != 0L) {
                    try {
                        long sa = Address.get(1, socketRef);
                        this.remoteAddr = Address.getip(sa);
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                }
                this.request.remoteAddr().setString(this.remoteAddr);
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                if (this.localName == null && socketRef != 0L) {
                    try {
                        long sa = Address.get(0, socketRef);
                        this.localName = Address.getnameinfo(sa, 0);
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                }
                this.request.localName().setString(this.localName);
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.remoteHost == null && socketRef != 0L) {
                    try {
                        long sa = Address.get(1, socketRef);
                        this.remoteHost = Address.getnameinfo(sa, 0);
                        if (this.remoteHost == null) {
                            this.remoteHost = Address.getip(sa);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                }
                this.request.remoteHost().setString(this.remoteHost);
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.localAddr == null && socketRef != 0L) {
                    try {
                        long sa = Address.get(0, socketRef);
                        this.localAddr = Address.getip(sa);
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                }
                this.request.localAddr().setString(this.localAddr);
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.remotePort == -1 && socketRef != 0L) {
                    try {
                        long sa = Address.get(1, socketRef);
                        Sockaddr addr = Address.getInfo(sa);
                        this.remotePort = addr.port;
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                }
                this.request.setRemotePort(this.remotePort);
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.localPort == -1 && socketRef != 0L) {
                    try {
                        long sa = Address.get(0, socketRef);
                        Sockaddr addr = Address.getInfo(sa);
                        this.localPort = addr.port;
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                }
                this.request.setLocalPort(this.localPort);
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                if (!this.endpoint.isSSLEnabled() || socketRef == 0L) break;
                try {
                    Object sslO = SSLSocket.getInfoS(socketRef, 2);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    int certLength = SSLSocket.getInfoI(socketRef, 1024);
                    byte[] clientCert = SSLSocket.getInfoB(socketRef, 263);
                    X509Certificate[] certs = null;
                    if (clientCert != null) {
                        if (certLength < 0) {
                            certLength = 0;
                        }
                        certs = new X509Certificate[certLength + 1];
                        CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                        certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                        for (int i = 0; i < certLength; ++i) {
                            byte[] data = SSLSocket.getInfoB(socketRef, 1024 + i);
                            certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                        }
                    }
                    if (certs != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                    }
                    sslO = SSLSocket.getInfoI(socketRef, 3);
                    this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    sslO = SSLSocket.getInfoS(socketRef, 1);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    if ((sslO = SSLSocket.getInfoS(socketRef, 7)) == null) break;
                    this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", sslO);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                if (!this.endpoint.isSSLEnabled() || socketRef == 0L) break;
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    SSLSocket.setVerify(socketRef, 2, ((AprEndpoint)this.endpoint).getSSLVerifyDepth());
                    if (SSLSocket.renegotiate(socketRef) != 0) break;
                    int certLength = SSLSocket.getInfoI(socketRef, 1024);
                    byte[] clientCert = SSLSocket.getInfoB(socketRef, 263);
                    X509Certificate[] certs = null;
                    if (clientCert != null && certLength > -1) {
                        certs = new X509Certificate[certLength + 1];
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                        for (int i = 0; i < certLength; ++i) {
                            byte[] data = SSLSocket.getInfoB(socketRef, 1024 + i);
                            certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                        }
                    }
                    if (certs == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
                break;
            }
            case AVAILABLE: {
                this.request.setAvailable(this.inputBuffer.available());
                break;
            }
            case COMET_BEGIN: {
                this.comet = true;
                break;
            }
            case COMET_END: {
                this.comet = false;
                break;
            }
            case COMET_CLOSE: {
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case COMET_SETTIMEOUT: {
                break;
            }
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.socketWrapper.setTimeout(timeout);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new AprEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer<Long> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Long> getOutputBuffer() {
        return this.outputBuffer;
    }
}

