#ifndef _EFL_UI_MULTI_SELECTABLE_ASYNC_EO_H_
#define _EFL_UI_MULTI_SELECTABLE_ASYNC_EO_H_

#ifndef _EFL_UI_MULTI_SELECTABLE_ASYNC_EO_CLASS_TYPE
#define _EFL_UI_MULTI_SELECTABLE_ASYNC_EO_CLASS_TYPE

typedef Eo Efl_Ui_Multi_Selectable_Async;

#endif

#ifndef _EFL_UI_MULTI_SELECTABLE_ASYNC_EO_TYPES
#define _EFL_UI_MULTI_SELECTABLE_ASYNC_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Interface for getting access to a range of selected items for widgets
 * that provide them asynchronously.
 *
 * The implementor of this interface provides the possibility to select
 * multiple @ref Efl_Ui_Selectable. If not, only @ref Efl_Ui_Single_Selectable
 * should be implemented. A widget can only provide either this interface or
 * @ref Efl_Ui_Multi_Selectable, but not both.
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
#define EFL_UI_MULTI_SELECTABLE_ASYNC_INTERFACE efl_ui_multi_selectable_async_interface_get()

EWAPI const Efl_Class *efl_ui_multi_selectable_async_interface_get(void);

/**
 * @brief The mode type for children selection.
 *
 * @param[in] obj The object.
 * @param[in] mode Type of selection of children
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI void efl_ui_multi_selectable_async_select_mode_set(Eo *obj, Efl_Ui_Select_Mode mode);

/**
 * @brief The mode type for children selection.
 *
 * @param[in] obj The object.
 *
 * @return Type of selection of children
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI Efl_Ui_Select_Mode efl_ui_multi_selectable_async_select_mode_get(const Eo *obj);

/**
 * @brief Gets an iterator of all the selected child of this model.
 *
 * @param[in] obj The object.
 *
 * @return The iterator gives indices of selected children. It is valid until
 * any change is made on the model.
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI Eina_Iterator *efl_ui_multi_selectable_async_selected_iterator_new(Eo *obj) EFL_TRANSFER_OWNERSHIP EINA_WARN_UNUSED_RESULT;

/**
 * @brief Gets an iterator of all the child of this model that are not
 * selected.
 *
 * @param[in] obj The object.
 *
 * @return The iterator gives indices of unselected children. It is valid until
 * any change is made on the model.
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI Eina_Iterator *efl_ui_multi_selectable_async_unselected_iterator_new(Eo *obj) EFL_TRANSFER_OWNERSHIP EINA_WARN_UNUSED_RESULT;

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Select a range of @ref Efl_Ui_Selectable.
 *
 * This will select the range of selectables from @c a to @c b or from @c b to
 * @c a depending on which one comes first. If @c a or @c b are not in the
 * range the widget, an error is returned, and no change is applied. Both of
 * the passed values will also be selected.
 *
 * @param[in] obj The object.
 * @param[in] a One side of the range.
 * @param[in] b The other side of the range.
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI void efl_ui_multi_selectable_async_range_select(Eo *obj, uint64_t a, uint64_t b);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Unselect a range of @ref Efl_Ui_Selectable.
 *
 * This will unselect the range of selectables from @c a to @c b or from @c b
 * to @c a depending on which one comes first. If @c a or @c b are not in the
 * range of the widget, an error is returned, and no change is applied. Both of
 * the passed values will also be unselected.
 *
 * @param[in] obj The object.
 * @param[in] a One side of the range.
 * @param[in] b The other side of the range.
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI void efl_ui_multi_selectable_async_range_unselect(Eo *obj, uint64_t a, uint64_t b);
#endif /* EFL_BETA_API_SUPPORT */

/** Select all @ref Efl_Ui_Selectable
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI void efl_ui_multi_selectable_async_all_select(Eo *obj);

/** Unselect all @ref Efl_Ui_Selectable
 *
 * @ingroup Efl_Ui_Multi_Selectable_Async
 */
EOAPI void efl_ui_multi_selectable_async_all_unselect(Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
