/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.RelativeRenderer;

public class BarRenderer
extends BaseRenderer
implements RelativeRenderer {
    private static final Color COLOR_POS = new Color(225, 130, 130);
    private static final Color COLOR_NEG = new Color(130, 225, 130);
    private static final int X_MARGIN = 2;
    private static final int Y_MARGIN = 3;
    private static final Rectangle BAR_RECT = new Rectangle();
    private long maxValue = 100L;
    private float value = 0.0f;
    protected boolean renderingDiff;
    private static final double FACTOR = 0.55;

    public BarRenderer() {
        this.setOpaque(true);
        this.putClientProperty("ProfilerTableHover_NoHover", this);
    }

    public void setMaxValue(long l) {
        this.maxValue = l;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setValue(Object object, int n) {
        this.value = object == null ? 0.0f : (this.maxValue == 0L ? 0.0f : ((Number)object).floatValue() / (float)this.maxValue);
    }

    @Override
    public void setDiffMode(boolean bl) {
        this.renderingDiff = bl;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        BarRenderer.BAR_RECT.x = this.location.x + 2;
        BarRenderer.BAR_RECT.y = this.location.y + 3;
        BarRenderer.BAR_RECT.height = this.size.height - 6;
        int n = this.size.width - 4;
        if (this.renderingDiff) {
            Color color = this.value < 0.0f ? COLOR_NEG : COLOR_POS;
            int n2 = n / 2;
            if (this.value <= -1.0f) {
                graphics.setColor(color);
                graphics.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, n2, BarRenderer.BAR_RECT.height);
                graphics.setColor(BarRenderer.alternate(color));
                graphics.fillRect(BarRenderer.BAR_RECT.x + n2, BarRenderer.BAR_RECT.y, n - n2, BarRenderer.BAR_RECT.height);
            } else if (this.value >= 1.0f) {
                graphics.setColor(BarRenderer.alternate(color));
                graphics.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, n2, BarRenderer.BAR_RECT.height);
                graphics.setColor(color);
                graphics.fillRect(BarRenderer.BAR_RECT.x + n2, BarRenderer.BAR_RECT.y, n - n2, BarRenderer.BAR_RECT.height);
            } else {
                graphics.setColor(BarRenderer.alternate(color));
                graphics.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, n, BarRenderer.BAR_RECT.height);
                BarRenderer.BAR_RECT.width = (int)((float)n2 * Math.min(Math.abs(this.value), 1.0f));
                if (BarRenderer.BAR_RECT.width > 0) {
                    graphics.setColor(color);
                    if (this.value < 0.0f) {
                        graphics.fillRect(BarRenderer.BAR_RECT.x + n2 - BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
                    } else {
                        graphics.fillRect(BarRenderer.BAR_RECT.x + n2, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
                    }
                }
            }
        } else {
            BarRenderer.BAR_RECT.width = (int)((float)n * Math.min(this.value, 1.0f));
            if (BarRenderer.BAR_RECT.width > 0) {
                graphics.setColor(COLOR_POS);
                graphics.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
            }
            if (BarRenderer.BAR_RECT.width < n) {
                BarRenderer.BAR_RECT.x += BarRenderer.BAR_RECT.width;
                BarRenderer.BAR_RECT.width = n - BarRenderer.BAR_RECT.width;
                graphics.setColor(BarRenderer.alternate(COLOR_POS));
                graphics.fillRect(BarRenderer.BAR_RECT.x, BarRenderer.BAR_RECT.y, BarRenderer.BAR_RECT.width, BarRenderer.BAR_RECT.height);
            }
        }
    }

    private static Color alternate(Color color) {
        return !UIUtils.isDarkResultsBackground() ? BarRenderer.brighter(color) : BarRenderer.darker(color);
    }

    private static Color brighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 2;
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / 0.55), 255), Math.min((int)((double)n2 / 0.55), 255), Math.min((int)((double)n3 / 0.55), 255));
    }

    private static Color darker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.55), 0), Math.max((int)((double)color.getGreen() * 0.55), 0), Math.max((int)((double)color.getBlue() * 0.55), 0));
    }
}

