/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.model;

import java.sql.Connection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class H2DataSource
extends GenericDataSource {
    public static final String H2_URL_PREFIX_TCP = "jdbc:h2:tcp:";
    public static final String H2_URL_PREFIX = "jdbc:h2:";
    public static final String H2_DB_FILE_EXTENSION = ".mv.db";

    public H2DataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel, SQLDialect dialect) throws DBException {
        super(monitor, container, metaModel, dialect);
    }

    public H2DataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        this(monitor, container, metaModel, (SQLDialect)new GenericSQLDialect());
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String url = connectionInfo.getUrl();
        if (url == null || url.startsWith(H2_URL_PREFIX_TCP)) {
            return url;
        }
        if (url.startsWith(H2_URL_PREFIX)) {
            String filePath = url.substring(H2_URL_PREFIX.length());
            String params = null;
            int divPos = filePath.indexOf(63);
            if (divPos != -1) {
                params = filePath.substring(divPos);
                filePath = filePath.substring(0, divPos);
            }
            if (filePath.endsWith(H2_DB_FILE_EXTENSION)) {
                url = H2_URL_PREFIX + filePath.substring(0, filePath.length() - H2_DB_FILE_EXTENSION.length());
                if (params != null) {
                    url = String.valueOf(url) + params;
                }
                return url;
            }
        }
        return super.getConnectionURL(connectionInfo);
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, JDBCRemoteInstance remoteInstance, @NotNull String purpose) throws DBCException {
        return super.openConnection(monitor, remoteInstance, purpose);
    }
}

