/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreTableManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class, PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class};

    @Nullable
    public DBSObjectCache<PostgreTableContainer, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreTableContainer)object.getContainer()).getSchema().tableCache;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, PostgreTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == PostgreTableColumn.class) {
            return object.getAttributes(monitor);
        }
        if (childType == PostgreTableConstraint.class) {
            return object.getConstraints(monitor);
        }
        if (childType == PostgreTableForeign.class) {
            return object.getAssociations(monitor);
        }
        if (childType == PostgreIndex.class) {
            return object.getIndexes(monitor);
        }
        return null;
    }

    protected String beginCreateTableStatement(PostgreTableBase table, String tableName) {
        return "CREATE " + this.getCreateTableType(table) + " " + tableName + " (" + GeneralUtils.getDefaultLineSeparator();
    }

    protected String getCreateTableType(PostgreTableBase table) {
        if (table instanceof PostgreTableForeign) {
            return "FOREIGN TABLE";
        }
        return table.getPersistence().getTableTypeClause();
    }

    protected PostgreTableBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        PostgreSchema schema = (PostgreSchema)container;
        PostgreTableBase table = schema.getDataSource().getServerType().createNewRelation(monitor, schema, PostgreClass.RelKind.r, copyFrom);
        if (CommonUtils.isEmpty((String)table.getName())) {
            this.setTableName(monitor, (DBSObjectContainer)schema, table);
        } else {
            table.setName(this.getNewChildName(monitor, (DBSObjectContainer)schema, table.getName()));
        }
        return table;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        String tableDDL;
        PostgreTableBase tableBase = (PostgreTableBase)command.getObject();
        if (tableBase.isPersisted() && (tableDDL = ((PostgreDataSource)tableBase.getDataSource()).getServerType().readTableDDL(monitor, tableBase)) != null) {
            actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, tableDDL));
            return;
        }
        super.addStructObjectCreateActions(monitor, actions, command, options);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if ((command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) && command.getObject() instanceof PostgreTable) {
            try {
                this.generateAlterActions(monitor, actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreTableRegular table = (PostgreTableRegular)command.getObject();
        String alterPrefix = "ALTER TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
        if (command.hasProperty((Object)"partitionKey")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "PARTITION BY " + table.getPartitionKey()));
        }
        if (command.hasProperty((Object)"hasOids")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + (table.isHasOids() ? "SET WITH OIDS" : "SET WITHOUT OIDS")));
        }
        if (command.hasProperty((Object)"tablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "SET TABLESPACE " + table.getTablespace(monitor).getName()));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, PostgreTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        ddl.append(((PostgreDataSource)tableBase.getDataSource()).getServerType().getTableModifiers(monitor, tableBase, alter));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((PostgreTableBase)command.getObject()).getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        PostgreTableBase table = (PostgreTableBase)command.getObject();
        String tableName = CommonUtils.getOption(options, (String)"useFQN", (boolean)true) ? table.getFullyQualifiedName(DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier((DBSObject)table);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (table instanceof PostgreTableForeign ? "FOREIGN TABLE" : "TABLE") + " " + tableName + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }
}

