/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskConfigPanel;
import org.jkiss.dbeaver.model.task.DBTTaskConfigurator;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizardStub;
import org.jkiss.utils.CommonUtils;

class TaskConfigurationWizardPageTask
extends ActiveWizardPage {
    private static final Log log = Log.getLog(TaskConfigurationWizardPageTask.class);
    private final DBPProject selectedProject;
    private Combo taskTypeCombo;
    private Text taskLabelText;
    private Text taskDescriptionText;
    private Tree taskCategoryTree;
    private DBTTaskType[] taskTypes;
    private Composite configPanelPlaceholder;
    private DBTTaskConfigPanel taskConfigPanel;
    private DBTTaskCategory selectedCategory;
    private DBTTaskType selectedTaskType;
    private String taskName;
    private String taskDescription;
    private Map<String, Object> initialProperties = new LinkedHashMap<String, Object>();
    private TaskImpl task;
    private Map<DBTTaskType, TaskConfigurationWizard> taskWizards = new HashMap<DBTTaskType, TaskConfigurationWizard>();

    TaskConfigurationWizardPageTask(DBTTask task) {
        super(task == null ? "Create new task" : "Edit task");
        this.setTitle(task == null ? "New task properties" : "Edit task properties");
        this.setDescription("Set task name, type and input data");
        this.task = (TaskImpl)task;
        if (this.task != null) {
            this.taskName = this.task.getName();
            this.taskDescription = this.task.getDescription();
            this.selectedTaskType = this.task.getType();
            this.selectedCategory = this.selectedTaskType.getCategory();
        }
        this.selectedProject = NavigatorUtils.getSelectedProject();
    }

    public TaskConfigurationWizard getWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    public DBTTaskCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public DBTTaskType getSelectedTaskType() {
        return this.selectedTaskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public Map<String, Object> getInitialProperties() {
        return this.initialProperties;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        SashForm formSash = new SashForm(parent, 256);
        formSash.setLayoutData((Object)new GridData(1808));
        Group formPanel = UIUtils.createControlGroup((Composite)formSash, (String)"Task info", (int)2, (int)1808, (int)0);
        formPanel.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = e -> this.updatePageCompletion();
        if (this.task == null) {
            UIUtils.createControlLabel((Composite)formPanel, (String)"Category");
            this.taskCategoryTree = new Tree((Composite)formPanel, 2052);
            GridData gd = new GridData(1808);
            gd.heightHint = 100;
            gd.widthHint = 200;
            this.taskCategoryTree.setLayoutData((Object)gd);
            this.taskCategoryTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeItem[] selection = TaskConfigurationWizardPageTask.this.taskCategoryTree.getSelection();
                    if (selection.length == 1) {
                        if (TaskConfigurationWizardPageTask.this.selectedCategory == selection[0].getData()) {
                            return;
                        }
                        TaskConfigurationWizardPageTask.this.selectedCategory = (DBTTaskCategory)selection[0].getData();
                        TaskConfigurationWizardPageTask.this.taskTypeCombo.removeAll();
                        TaskConfigurationWizardPageTask.this.taskTypes = TaskConfigurationWizardPageTask.this.selectedCategory.getTaskTypes();
                        DBTTaskType[] dBTTaskTypeArray = TaskConfigurationWizardPageTask.this.taskTypes;
                        int n = dBTTaskTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DBTTaskType type = dBTTaskTypeArray[n2];
                            TaskConfigurationWizardPageTask.this.taskTypeCombo.add(type.getName());
                            ++n2;
                        }
                        if (TaskConfigurationWizardPageTask.this.taskTypes.length > 0) {
                            TaskConfigurationWizardPageTask.this.taskTypeCombo.select(0);
                            TaskConfigurationWizardPageTask.this.selectedTaskType = TaskConfigurationWizardPageTask.this.taskTypes[0];
                        } else {
                            TaskConfigurationWizardPageTask.this.selectedTaskType = null;
                        }
                        TaskConfigurationWizardPageTask.this.updateTaskTypeSelection();
                    }
                }
            });
            this.addTaskCategories(null, TaskRegistry.getInstance().getRootCategories());
            this.taskTypeCombo = UIUtils.createLabelCombo((Composite)formPanel, (String)"Type", (int)2060);
            this.taskTypeCombo.addModifyListener(modifyListener);
            this.taskTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBTTaskType newTaskType = TaskConfigurationWizardPageTask.this.taskTypeCombo.getSelectionIndex() >= 0 ? TaskConfigurationWizardPageTask.this.taskTypes[TaskConfigurationWizardPageTask.this.taskTypeCombo.getSelectionIndex()] : null;
                    if (TaskConfigurationWizardPageTask.this.selectedTaskType == newTaskType) {
                        return;
                    }
                    TaskConfigurationWizardPageTask.this.selectedTaskType = newTaskType;
                    TaskConfigurationWizardPageTask.this.updateTaskTypeSelection();
                }
            });
        } else {
            UIUtils.createLabelText((Composite)formPanel, (String)"Category", (String)this.task.getType().getCategory().getName(), (int)2056);
            UIUtils.createLabelText((Composite)formPanel, (String)"Type", (String)this.task.getType().getName(), (int)2056);
        }
        this.taskLabelText = UIUtils.createLabelText((Composite)formPanel, (String)"Name", (String)(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getName())), (int)2048);
        this.taskLabelText.addModifyListener(e -> {
            this.taskName = this.taskLabelText.getText();
            modifyListener.modifyText(e);
        });
        UIUtils.createControlLabel((Composite)formPanel, (String)"Description").setLayoutData((Object)new GridData(2));
        this.taskDescriptionText = new Text((Composite)formPanel, 2562);
        this.taskDescriptionText.setText(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getDescription()));
        this.taskDescriptionText.setLayoutData((Object)new GridData(768));
        ((GridData)this.taskDescriptionText.getLayoutData()).heightHint = this.taskDescriptionText.getLineHeight() * 5;
        this.taskDescriptionText.addModifyListener(e -> {
            this.taskDescription = this.taskDescriptionText.getText();
            modifyListener.modifyText(e);
        });
        UIUtils.asyncExec(() -> {
            boolean bl = this.taskLabelText.setFocus();
        });
        this.configPanelPlaceholder = UIUtils.createComposite((Composite)formSash, (int)1);
        if (this.task != null) {
            this.updateTaskTypeSelection();
        }
        formSash.setWeights(new int[]{500, 500});
        this.setControl((Control)formSash);
    }

    private void updateTaskTypeSelection() {
        UIUtils.disposeChildControls((Composite)this.configPanelPlaceholder);
        this.taskConfigPanel = null;
        if (this.selectedCategory != null && this.selectedCategory.supportsConfigurator()) {
            try {
                DBTTaskConfigurator configurator = this.selectedCategory.createConfigurator();
                DBTTaskConfigPanel configPage = configurator.createInputConfigurator(UIUtils.getDefaultRunnableContext(), this.selectedTaskType);
                if (configPage != null) {
                    this.taskConfigPanel = configPage;
                    this.taskConfigPanel.createControl((Object)this.configPanelPlaceholder, (Object)this.getTaskWizard(), () -> ((TaskConfigurationWizardPageTask)this).updatePageCompletion());
                    if (this.task != null) {
                        this.taskConfigPanel.loadSettings();
                        this.updatePageCompletion();
                    }
                } else {
                    UIUtils.disposeChildControls((Composite)this.configPanelPlaceholder);
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Task configurator error", "Error creating task configuration UI", (Throwable)e);
            }
        }
        if (this.taskConfigPanel == null) {
            Group group = UIUtils.createControlGroup((Composite)this.configPanelPlaceholder, (String)"", (int)1, (int)1808, (int)0);
            group.setLayoutData((Object)new GridData(1808));
            Label emptyLabel = new Label((Composite)group, 0);
            emptyLabel.setText("No configuration");
            GridData gd = new GridData(68);
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            emptyLabel.setLayoutData((Object)gd);
        }
        this.getShell().layout(true, true);
        this.getWizard().getContainer().updateButtons();
    }

    private void addTaskCategories(TreeItem parentItem, DBTTaskCategory[] categories) {
        DBTTaskCategory[] dBTTaskCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskCategory cat = dBTTaskCategoryArray[n2];
            TreeItem item = parentItem == null ? new TreeItem(this.taskCategoryTree, 0) : new TreeItem(parentItem, 0);
            item.setText(cat.getName());
            item.setImage(DBeaverIcons.getImage((DBPImage)(cat.getIcon() == null ? DBIcon.TREE_TASK : cat.getIcon())));
            item.setData((Object)cat);
            this.addTaskCategories(item, cat.getChildren());
            item.setExpanded(true);
            ++n2;
        }
    }

    protected boolean determinePageCompletion() {
        return this.selectedTaskType != null && (this.task != null && !CommonUtils.isEmpty((String)this.task.getName()) || !CommonUtils.isEmpty((String)this.taskName)) && (this.taskConfigPanel == null || this.taskConfigPanel.isComplete());
    }

    public TaskConfigurationWizard getTaskWizard() throws DBException {
        if (!(this.getWizard() instanceof TaskConfigurationWizardStub)) {
            return this.getWizard();
        }
        TaskConfigurationWizard realWizard = this.taskWizards.get(this.selectedTaskType);
        if (realWizard == null) {
            DBTTaskConfigurator configurator = this.selectedCategory.createConfigurator();
            if (this.task == null) {
                this.task = (TaskImpl)this.selectedProject.getTaskManager().createTaskConfiguration(this.selectedTaskType, CommonUtils.notEmpty((String)this.taskName), this.taskDescription, new LinkedHashMap());
            }
            realWizard = (TaskConfigurationWizard)((Object)configurator.createTaskConfigWizard((DBTTask)this.task));
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            IWorkbenchPart activePart = workbenchWindow.getActivePage().getActivePart();
            ISelection selection = activePart == null || activePart.getSite() == null || activePart.getSite().getSelectionProvider() == null ? null : activePart.getSite().getSelectionProvider().getSelection();
            realWizard.setContainer(this.getContainer());
            realWizard.init(workbenchWindow.getWorkbench(), selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null);
            this.taskConfigPanel.saveSettings();
            this.taskWizards.put(this.selectedTaskType, realWizard);
        }
        return realWizard;
    }

    public void saveSettings() {
        if (this.task != null) {
            this.task.setName(this.taskLabelText.getText());
            this.task.setDescription(this.taskDescriptionText.getText());
            this.task.setType(this.selectedTaskType);
            if (this.taskConfigPanel != null) {
                this.taskConfigPanel.saveSettings();
            }
        }
    }
}

