/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.ErrorReporter;

public class DOTCFGVisualizer<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>>
implements CFGVisualizer<A, S, T> {
    protected String outdir;
    protected boolean verbose;
    protected String checkerName;
    protected StringBuilder sbDigraph;
    protected StringBuilder sbStore;
    protected StringBuilder sbBlock;
    protected Map<String, String> generated;

    @Override
    public void init(Map<String, Object> args) {
        this.outdir = (String)args.get("outdir");
        Object verb = args.get("verbose");
        this.verbose = verb == null ? false : (verb instanceof String ? Boolean.getBoolean((String)verb) : (Boolean)verb);
        this.checkerName = (String)args.get("checkerName");
        this.generated = new HashMap<String, String>();
        this.sbDigraph = new StringBuilder();
        this.sbStore = new StringBuilder();
        this.sbBlock = new StringBuilder();
    }

    @Override
    public @Nullable Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<A, S, T> analysis) {
        String dotgraph = this.generateDotGraph(cfg, entry, analysis);
        String dotfilename = this.dotOutputFileName(cfg.underlyingAST);
        try {
            FileWriter fstream = new FileWriter(dotfilename);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(dotgraph);
            out.close();
        }
        catch (IOException e) {
            ErrorReporter.errorAbort((String)("Error creating dot file: " + dotfilename + "; ensure the path is valid"), (Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("dotFileName", dotfilename);
        return res;
    }

    protected String generateDotGraph(ControlFlowGraph cfg, Block entry, @Nullable Analysis<A, S, T> analysis) {
        this.sbDigraph.setLength(0);
        HashSet<Block> visited = new HashSet<Block>();
        this.sbDigraph.append("digraph {\n");
        Block cur = entry;
        ArrayDeque<Block> worklist = new ArrayDeque<Block>();
        visited.add(entry);
        while (cur != null) {
            if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                ConditionalBlock ccur = (ConditionalBlock)cur;
                Block thenSuccessor = ccur.getThenSuccessor();
                this.addDotEdge(ccur.getId(), thenSuccessor.getId(), "then\\n" + (Object)((Object)ccur.getThenFlowRule()));
                if (!visited.contains(thenSuccessor)) {
                    visited.add(thenSuccessor);
                    worklist.add(thenSuccessor);
                }
                Block elseSuccessor = ccur.getElseSuccessor();
                this.addDotEdge(ccur.getId(), elseSuccessor.getId(), "else\\n" + (Object)((Object)ccur.getElseFlowRule()));
                if (!visited.contains(elseSuccessor)) {
                    visited.add(elseSuccessor);
                    worklist.add(elseSuccessor);
                }
            } else {
                assert (cur instanceof SingleSuccessorBlock);
                Block b = ((SingleSuccessorBlock)cur).getSuccessor();
                if (b != null) {
                    this.addDotEdge(cur.getId(), b.getId(), ((SingleSuccessorBlock)cur).getFlowRule().name());
                    if (!visited.contains(b)) {
                        visited.add(b);
                        worklist.add(b);
                    }
                }
            }
            if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
                ExceptionBlock ecur = (ExceptionBlock)cur;
                for (Map.Entry<TypeMirror, Set<Block>> e : ecur.getExceptionalSuccessors().entrySet()) {
                    Set<Block> blocks = e.getValue();
                    TypeMirror cause = e.getKey();
                    String exception = cause.toString();
                    if (exception.startsWith("java.lang.")) {
                        exception = exception.replace("java.lang.", "");
                    }
                    for (Block b : blocks) {
                        this.addDotEdge(cur.getId(), b.getId(), exception);
                        if (visited.contains(b)) continue;
                        visited.add(b);
                        worklist.add(b);
                    }
                }
            }
            cur = (Block)worklist.poll();
        }
        this.generateDotNodes(visited, cfg, analysis);
        this.sbDigraph.append("}\n");
        return this.sbDigraph.toString();
    }

    protected void generateDotNodes(Set<Block> visited, ControlFlowGraph cfg, @Nullable Analysis<A, S, T> analysis) {
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        this.sbDigraph.append("    node [shape=rectangle];\n\n");
        for (Block v : visited) {
            this.sbDigraph.append("    " + v.getId() + " [");
            if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                this.sbDigraph.append("shape=polygon sides=8 ");
            } else if (v.getType() == Block.BlockType.SPECIAL_BLOCK) {
                this.sbDigraph.append("shape=oval ");
            }
            this.sbDigraph.append("label=\"");
            if (this.verbose) {
                this.sbDigraph.append("Process order: " + processOrder.get(v).toString().replaceAll("[\\[\\]]", "") + "\\n");
            }
            this.visualizeBlock(v, analysis);
        }
        this.sbDigraph.append("\n");
    }

    protected String dotOutputFileName(UnderlyingAST ast) {
        StringBuilder srcloc = new StringBuilder();
        StringBuilder outfile = new StringBuilder(this.outdir);
        outfile.append('/');
        if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            UnderlyingAST.CFGStatement cfgs = (UnderlyingAST.CFGStatement)ast;
            String clsname = cfgs.getClassTree().getSimpleName().toString();
            outfile.append(clsname);
            outfile.append("-initializer-");
            outfile.append(ast.hashCode());
            srcloc.append('<');
            srcloc.append(clsname);
            srcloc.append("::initializer::");
            srcloc.append(((JCTree)cfgs.getCode()).pos);
            srcloc.append('>');
        } else if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgm = (UnderlyingAST.CFGMethod)ast;
            String clsname = cfgm.getClassTree().getSimpleName().toString();
            String methname = cfgm.getMethod().getName().toString();
            outfile.append(clsname);
            outfile.append('-');
            outfile.append(methname);
            srcloc.append('<');
            srcloc.append(clsname);
            srcloc.append("::");
            srcloc.append(methname);
            srcloc.append('(');
            srcloc.append(cfgm.getMethod().getParameters());
            srcloc.append(")::");
            srcloc.append(((JCTree)((Object)cfgm.getMethod())).pos);
            srcloc.append('>');
        } else {
            ErrorReporter.errorAbort((String)("Unexpected AST kind: " + (Object)((Object)ast.getKind()) + " value: " + ast.toString()));
            return null;
        }
        outfile.append('-');
        outfile.append(this.checkerName);
        outfile.append(".dot");
        String out = outfile.toString().replace("<", "_").replace(">", "");
        this.generated.put(srcloc.toString(), out);
        return out;
    }

    protected IdentityHashMap<Block, List<Integer>> getProcessOrder(ControlFlowGraph cfg) {
        IdentityHashMap<Block, List<Integer>> depthFirstOrder = new IdentityHashMap<Block, List<Integer>>();
        int count = 1;
        for (Block b : cfg.getDepthFirstOrderedBlocks()) {
            if (depthFirstOrder.get(b) == null) {
                depthFirstOrder.put(b, new ArrayList());
            }
            depthFirstOrder.get(b).add(count++);
        }
        return depthFirstOrder;
    }

    @Override
    public void visualizeBlock(Block bb, @Nullable Analysis<A, S, T> analysis) {
        this.sbBlock.setLength(0);
        ArrayList<Node> contents = new ArrayList<Node>();
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                contents.addAll(((RegularBlock)bb).getContents());
                break;
            }
            case EXCEPTION_BLOCK: {
                contents.add(((ExceptionBlock)bb).getNode());
                break;
            }
            case CONDITIONAL_BLOCK: {
                break;
            }
            case SPECIAL_BLOCK: {
                break;
            }
            default: {
                assert (false) : "All types of basic blocks covered";
                break;
            }
        }
        boolean notFirst = false;
        for (Node t : contents) {
            if (notFirst) {
                this.sbBlock.append("\\n");
            }
            notFirst = true;
            this.visualizeBlockNode(t, analysis);
        }
        boolean centered = false;
        if (this.sbBlock.length() == 0) {
            centered = true;
            if (bb.getType() == Block.BlockType.SPECIAL_BLOCK) {
                this.visualizeSpecialBlock((SpecialBlock)bb);
            } else {
                if (bb.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                    this.sbDigraph.append(" \",];\n");
                    return;
                }
                this.sbDigraph.append("?? empty ?? \",];\n");
                return;
            }
        }
        if (analysis != null) {
            this.visualizeBlockTransferInput(bb, analysis);
        }
        this.sbDigraph.append((this.sbBlock.toString() + (centered ? "" : "\\n")).replace("\\n", "\\l") + " \",];\n");
    }

    @Override
    public void visualizeSpecialBlock(SpecialBlock sbb) {
        switch (sbb.getSpecialType()) {
            case ENTRY: {
                this.sbBlock.append("<entry>");
                break;
            }
            case EXIT: {
                this.sbBlock.append("<exit>");
                break;
            }
            case EXCEPTIONAL_EXIT: {
                this.sbBlock.append("<exceptional-exit>");
            }
        }
    }

    @Override
    public void visualizeBlockTransferInput(Block bb, Analysis<A, S, T> analysis) {
        assert (analysis != null) : "analysis should be non-null when visualizing the transfer input of a block.";
        TransferInput<A, S> input = analysis.getInput(bb);
        this.sbStore.setLength(0);
        this.sbStore.append("Before:");
        S thenStore = input.getThenStore();
        if (!input.containsTwoStores()) {
            S regularStore = input.getRegularStore();
            this.sbStore.append('[');
            this.visualizeStore(regularStore);
            this.sbStore.append(']');
        } else {
            S elseStore = input.getElseStore();
            this.sbStore.append("[then=");
            this.visualizeStore(thenStore);
            this.sbStore.append(", else=");
            this.visualizeStore(elseStore);
            this.sbStore.append("]");
        }
        this.sbStore.append("\\n~~~~~~~~~\\n");
        this.sbBlock.insert(0, this.sbStore);
        if (this.verbose) {
            Node lastNode;
            switch (bb.getType()) {
                case REGULAR_BLOCK: {
                    List<Node> blockContents = ((RegularBlock)bb).getContents();
                    lastNode = blockContents.get(blockContents.size() - 1);
                    break;
                }
                case EXCEPTION_BLOCK: {
                    lastNode = ((ExceptionBlock)bb).getNode();
                    break;
                }
                default: {
                    lastNode = null;
                }
            }
            if (lastNode != null) {
                this.sbStore.setLength(0);
                this.sbStore.append("\\n~~~~~~~~~\\n");
                this.sbStore.append("After:");
                this.visualizeStore(analysis.getResult().getStoreAfter(lastNode));
                this.sbBlock.append((CharSequence)this.sbStore);
            }
        }
    }

    @Override
    public void visualizeBlockNode(Node t, @Nullable Analysis<A, S, T> analysis) {
        A value;
        this.sbBlock.append(this.prepareString(t.toString()) + "   [ " + this.prepareNodeType(t) + " ]");
        if (analysis != null && (value = analysis.getValue(t)) != null) {
            this.sbBlock.append("    > " + this.prepareString(value.toString()));
        }
    }

    protected String prepareNodeType(Node t) {
        String name = t.getClass().getSimpleName();
        return name.replace("Node", "");
    }

    protected String prepareString(String s) {
        return s.replace("\"", "\\\"");
    }

    protected void addDotEdge(long sId, long eId, String labelContent) {
        this.sbDigraph.append("    " + sId + " -> " + eId + " [label=\"" + labelContent + "\"];\n");
    }

    @Override
    public void visualizeStore(S store) {
        store.visualize(this);
    }

    @Override
    public void visualizeStoreThisVal(A value) {
        this.sbStore.append("  this > " + value + "\\n");
    }

    @Override
    public void visualizeStoreLocalVar(FlowExpressions.LocalVariable localVar, A value) {
        this.sbStore.append("  " + localVar + " > " + this.toStringEscapeDoubleQuotes(value) + "\\n");
    }

    @Override
    public void visualizeStoreFieldVals(FlowExpressions.FieldAccess fieldAccess, A value) {
        this.sbStore.append("  " + fieldAccess + " > " + this.toStringEscapeDoubleQuotes(value) + "\\n");
    }

    @Override
    public void visualizeStoreArrayVal(FlowExpressions.ArrayAccess arrayValue, A value) {
        this.sbStore.append("  " + arrayValue + " > " + this.toStringEscapeDoubleQuotes(value) + "\\n");
    }

    @Override
    public void visualizeStoreMethodVals(FlowExpressions.MethodCall methodCall, A value) {
        this.sbStore.append("  " + methodCall.toString().replace("\"", "\\\"") + " > " + value + "\\n");
    }

    @Override
    public void visualizeStoreClassVals(FlowExpressions.ClassName className, A value) {
        this.sbStore.append("  " + className + " > " + this.toStringEscapeDoubleQuotes(value) + "\\n");
    }

    @Override
    public void visualizeStoreKeyVal(String keyName, Object value) {
        this.sbStore.append("  " + keyName + " = " + value + "\\n");
    }

    protected String escapeDoubleQuotes(String str) {
        return str.replace("\"", "\\\"");
    }

    protected String toStringEscapeDoubleQuotes(Object obj) {
        return this.escapeDoubleQuotes(String.valueOf(obj));
    }

    @Override
    public void visualizeStoreHeader(String classCanonicalName) {
        this.sbStore.append(classCanonicalName + " (\\n");
    }

    @Override
    public void visualizeStoreFooter() {
        this.sbStore.append(")");
    }

    @Override
    public void shutdown() {
        try {
            FileWriter fstream = new FileWriter(this.outdir + "/methods.txt", true);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Map.Entry<String, String> kv : this.generated.entrySet()) {
                out.write(kv.getKey());
                out.append('\t');
                out.write(kv.getValue());
                out.append('\n');
            }
            out.close();
        }
        catch (IOException e) {
            ErrorReporter.errorAbort((String)("Error creating methods.txt file in: " + this.outdir + "; ensure the path is valid"), (Throwable)e);
        }
    }
}

