/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreToolTriggerToggle
implements IUserInterfaceTool {
    private boolean isEnable;

    PostgreToolTriggerToggle(boolean enable) {
        this.isEnable = enable;
    }

    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) {
        List triggeList = CommonUtils.filterCollection(objects, PostgreTrigger.class);
        if (!triggeList.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), triggeList);
            dialog.open();
        }
    }

    class SQLDialog
    extends TableToolDialog {
        SQLDialog(IWorkbenchPartSite partSite, List<PostgreTrigger> selectedTrigger) {
            super(partSite, String.valueOf(PostgreToolTriggerToggle.this.isEnable ? "Enable" : "Disable") + " trigger", selectedTrigger);
        }

        protected void generateObjectCommand(List<String> lines, PostgreObject object) {
            lines.add("ALTER TABLE " + ((PostgreTrigger)object).getTable() + " " + (PostgreToolTriggerToggle.this.isEnable ? "ENABLE" : "DISABLE") + " TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)object));
        }

        protected void createControls(Composite parent) {
            this.createObjectsSelector(parent);
        }

        protected boolean needsRefreshOnFinish() {
            return true;
        }
    }
}

