/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.properties.IPropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectAttributeDescriptor;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;

public class ObjectPropertyGroupDescriptor
extends ObjectAttributeDescriptor {
    private PropertyGroup groupInfo;
    private List<ObjectPropertyDescriptor> children = new ArrayList<ObjectPropertyDescriptor>();

    public ObjectPropertyGroupDescriptor(DBPPropertySource source, ObjectPropertyGroupDescriptor parent, Method getter, PropertyGroup groupInfo, IPropertyFilter filter, String locale) {
        super(source, parent, getter, groupInfo.id(), groupInfo.order());
        this.groupInfo = groupInfo;
        ObjectPropertyGroupDescriptor.extractAnnotations(source, this, this.getGetter().getReturnType(), this.children, filter, locale);
    }

    @Override
    public String getCategory() {
        return this.groupInfo.category();
    }

    @Override
    public String getDescription() {
        return this.groupInfo.description();
    }

    public Collection<ObjectPropertyDescriptor> getChildren() {
        return this.children;
    }

    public Object getGroupObject(Object object, DBRProgressMonitor progressMonitor) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.getParent() != null) {
            object = this.getParent().getGroupObject(object, progressMonitor);
        }
        if (this.isLazy(object, false) && progressMonitor == null) {
            throw new IllegalAccessException("Can't read lazy properties with null progress monitor");
        }
        if (this.isLazy()) {
            return this.getGetter().invoke(object, progressMonitor);
        }
        return this.getGetter().invoke(object, new Object[0]);
    }
}

