/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.swing;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Segment;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;

public class HTMLTextComponent
extends HTMLTextArea {
    private boolean neverDisplayed = true;

    public HTMLTextComponent() {
    }

    public HTMLTextComponent(String text) {
        super(text);
    }

    public void addNotify() {
        super.addNotify();
        if (this.neverDisplayed) {
            if (this.isShowing()) {
                this.neverDisplayed = false;
                this.firstDisplayed();
            } else {
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && HTMLTextComponent.this.isShowing()) {
                            HTMLTextComponent.this.neverDisplayed = false;
                            HTMLTextComponent.this.removeHierarchyListener(this);
                            HTMLTextComponent.this.firstDisplayed();
                        }
                    }
                });
            }
        }
    }

    public final boolean neverDisplayed() {
        return this.neverDisplayed;
    }

    protected void firstDisplayed() {
    }

    public EditorKit getEditorKitForContentType(String type) {
        return new CustomHtmlEditorKit();
    }

    private static class CustomHTMLDocument
    extends HTMLDocument {
        private static final int CACHE_BOUNDARY = 1000;
        private char[] segArray;
        private int segOffset;
        private int segCount;
        private boolean segPartialReturn;
        private int lastOffset = -1;
        private int lastLength = -1;

        private CustomHTMLDocument(StyleSheet ss) {
            super(ss);
            this.putProperty("multiByte", Boolean.TRUE);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            if (this.lastOffset == offset && this.lastLength == length) {
                txt.array = this.segArray;
                txt.offset = this.segOffset;
                txt.count = this.segCount;
                txt.setPartialReturn(this.segPartialReturn);
                return;
            }
            super.getText(offset, length, txt);
            if (length > 1000 || this.lastLength <= 1000) {
                this.segArray = txt.array;
                this.segOffset = txt.offset;
                this.segCount = txt.count;
                this.segPartialReturn = txt.isPartialReturn();
                this.lastOffset = offset;
                this.lastLength = length;
            }
        }
    }

    private static class CustomHtmlEditorKit
    extends HTMLEditorKit {
        private CustomHtmlEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            CustomHTMLDocument doc = new CustomHTMLDocument(ss);
            doc.setParser(this.getParser());
            doc.setAsynchronousLoadPriority(4);
            doc.setTokenThreshold(100);
            return doc;
        }
    }
}

