/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCSQLXMLImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;

public class JDBCContentXML
extends JDBCContentLOB {
    private static final Log log = Log.getLog(JDBCContentXML.class);
    protected SQLXML xml;

    public JDBCContentXML(DBPDataSource dataSource, SQLXML xml) {
        super(dataSource);
        this.xml = xml;
    }

    @Override
    public long getLOBLength() throws DBCException {
        return -1L;
    }

    @Override
    @NotNull
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.xml != null) {
            try {
                this.storage = StringContentStorage.createFromReader(this.xml.getCharacterStream());
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading content", e);
            }
            catch (SQLException e) {
                throw new DBCException(e, this.dataSource);
            }
            this.releaseXML();
        }
        return this.storage;
    }

    @Override
    public void release() {
        this.releaseXML();
        super.release();
    }

    private void releaseXML() {
        if (this.xml != null) {
            try {
                this.xml.free();
            }
            catch (Exception e) {
                log.debug(e);
            }
            this.xml = null;
        }
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        block14: {
            try {
                if (this.xml != null) {
                    preparedStatement.setSQLXML(paramIndex, this.xml);
                    break block14;
                }
                if (this.storage != null) {
                    try {
                        preparedStatement.setSQLXML(paramIndex, new JDBCSQLXMLImpl(this.storage));
                    }
                    catch (Throwable e) {
                        if (e instanceof SQLException && !(e instanceof SQLFeatureNotSupportedException)) {
                            throw (SQLException)e;
                        }
                        Reader streamReader = this.storage.getContentReader();
                        try {
                            preparedStatement.setCharacterStream(paramIndex, streamReader);
                            break block14;
                        }
                        catch (Throwable e0) {
                            if (e0 instanceof SQLException && !(e0 instanceof SQLFeatureNotSupportedException)) {
                                throw (SQLException)e0;
                            }
                            long streamLength = ContentUtils.calculateContentLength(this.storage.getContentReader());
                            try {
                                preparedStatement.setCharacterStream(paramIndex, streamReader, streamLength);
                                break block14;
                            }
                            catch (Throwable e1) {
                                if (e1 instanceof SQLException && !(e instanceof SQLFeatureNotSupportedException)) {
                                    throw (SQLException)e1;
                                }
                                preparedStatement.setCharacterStream(paramIndex, streamReader, (int)streamLength);
                            }
                        }
                    }
                    break block14;
                }
                preparedStatement.setNull(paramIndex, 2009);
            }
            catch (SQLException e) {
                throw new DBCException(e, this.dataSource);
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading content", e);
            }
        }
    }

    @Override
    public SQLXML getRawValue() {
        return this.xml;
    }

    @Override
    public boolean isNull() {
        return this.xml == null && this.storage == null;
    }

    @Override
    protected JDBCContentLOB createNewContent() {
        return new JDBCContentXML(this.dataSource, null);
    }

    @Override
    public String getDisplayString(DBDDisplayFormat format) {
        return this.xml == null && this.storage == null ? null : "[XML]";
    }
}

