/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences.format;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.preferences.format.BaseFormatterConfigurationPage;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLExternalFormatterConfigurationPage
extends BaseFormatterConfigurationPage {
    private Text externalCmdText;
    private Button externalUseFile;
    private Spinner externalTimeout;

    @Override
    protected Composite createFormatSettings(Composite parent) {
        Group settingsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Settings", (int)4, (int)768, (int)0);
        this.externalCmdText = UIUtils.createLabelText((Composite)settingsGroup, (String)SQLEditorMessages.pref_page_sql_format_label_external_command_line, (String)"");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.externalCmdText.setLayoutData((Object)gd);
        UIUtils.installContentProposal((Control)this.externalCmdText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"file")}));
        UIUtils.setContentProposalToolTip((Control)this.externalCmdText, (String)SQLEditorMessages.pref_page_sql_format_label_external_set_content_tool_tip, (String[])new String[]{"file"});
        this.externalUseFile = UIUtils.createCheckbox((Composite)settingsGroup, (String)SQLEditorMessages.pref_page_sql_format_label_external_use_temp_file, (String)(String.valueOf(SQLEditorMessages.pref_page_sql_format_label_external_use_temp_file_tip) + " " + GeneralUtils.variablePattern((String)"file")), (boolean)false, (int)2);
        this.externalTimeout = UIUtils.createLabelSpinner((Composite)settingsGroup, (String)SQLEditorMessages.pref_page_sql_format_label_external_exec_timeout, (String)SQLEditorMessages.pref_page_sql_format_label_external_exec_timeout_tip, (int)100, (int)100, (int)10000);
        return parent;
    }

    @Override
    public void loadSettings(DBPPreferenceStore store) {
        super.loadSettings(store);
        this.externalCmdText.setText(store.getString("sql.format.external.cmd"));
        this.externalUseFile.setSelection(store.getBoolean("sql.format.external.file"));
        this.externalTimeout.setSelection(store.getInt("sql.format.external.timeout"));
    }

    @Override
    public void saveSettings(DBPPreferenceStore store) {
        super.saveSettings(store);
        store.setValue("sql.format.external.cmd", this.externalCmdText.getText());
        store.setValue("sql.format.external.file", this.externalUseFile.getSelection());
        store.setValue("sql.format.external.timeout", this.externalTimeout.getSelection());
    }
}

