/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.TreeUtils;

public abstract class AssignmentContext {
    public abstract Element getElementForType();

    public abstract Tree getContextTree();

    public static class LambdaReturnContext
    extends AssignmentContext {
        protected final ExecutableElement method;

        public LambdaReturnContext(ExecutableElement method) {
            this.method = method;
        }

        @Override
        public Element getElementForType() {
            return this.method;
        }

        @Override
        public Tree getContextTree() {
            return null;
        }
    }

    public static class MethodReturnContext
    extends AssignmentContext {
        protected final ExecutableElement method;
        protected final Tree ret;

        public MethodReturnContext(MethodTree method) {
            this.method = TreeUtils.elementFromDeclaration((MethodTree)method);
            this.ret = method.getReturnType();
        }

        @Override
        public Element getElementForType() {
            return this.method;
        }

        @Override
        public Tree getContextTree() {
            return this.ret;
        }
    }

    public static class MethodParameterContext
    extends AssignmentContext {
        protected final ExecutableElement method;
        protected final int paramNum;

        public MethodParameterContext(ExecutableElement method, int paramNum) {
            this.method = method;
            this.paramNum = paramNum;
        }

        @Override
        public Element getElementForType() {
            return this.method.getParameters().get(this.paramNum);
        }

        @Override
        public Tree getContextTree() {
            return null;
        }
    }

    public static class AssignmentLhsContext
    extends AssignmentContext {
        protected final Node node;

        public AssignmentLhsContext(Node node) {
            this.node = node;
        }

        @Override
        public Element getElementForType() {
            Tree tree = this.node.getTree();
            if (tree == null) {
                return null;
            }
            if (tree instanceof ExpressionTree) {
                return TreeUtils.elementFromUse((ExpressionTree)((ExpressionTree)tree));
            }
            if (tree instanceof VariableTree) {
                return TreeUtils.elementFromDeclaration((VariableTree)((VariableTree)tree));
            }
            assert (false) : "unexpected tree";
            return null;
        }

        @Override
        public Tree getContextTree() {
            return this.node.getTree();
        }
    }
}

