#ifndef _EFL_CANVAS_GESTURE_TOUCH_EO_H_
#define _EFL_CANVAS_GESTURE_TOUCH_EO_H_

#ifndef _EFL_CANVAS_GESTURE_TOUCH_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_TOUCH_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture_Touch;

#endif

#ifndef _EFL_CANVAS_GESTURE_TOUCH_EO_TYPES
#define _EFL_CANVAS_GESTURE_TOUCH_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief EFL Gesture Touch class
 *
 * This gesture class defines a method that records touch points and supports
 * properties - first touch point, current touch point, timestamp, multi-touch
 *  and state information.
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
#define EFL_CANVAS_GESTURE_TOUCH_CLASS efl_canvas_gesture_touch_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_touch_class_get(void);

/**
 * @brief Touch point record method
 *
 * @param[in] obj The object.
 * @param[in] tool The finger id
 * @param[in] pos Position of the event
 * @param[in] timestamp The timestamp of the event
 * @param[in] action action of the event
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI void efl_gesture_touch_point_record(Eo *obj, int tool, Eina_Vector2 pos, unsigned int timestamp, Efl_Pointer_Action action);

/**
 * @brief Compute the distance between the last two events
 *
 * @param[in] obj The object.
 * @param[in] tool The finger id
 *
 * @return The distance vector.
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI Eina_Vector2 efl_gesture_touch_delta(const Eo *obj, int tool);

/**
 * @brief Compute the distance between the first touch and the last event.
 *
 * @param[in] obj The object.
 * @param[in] tool The finger id
 *
 * @return The distance vector.
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI Eina_Vector2 efl_gesture_touch_distance(const Eo *obj, int tool);

/**
 * @brief Returns the first touch point.
 *
 * @param[in] obj The object.
 *
 * @return The start position.
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI Eina_Position2D efl_gesture_touch_start_point_get(const Eo *obj);

/**
 * @brief Returns the current touch point.
 *
 * @param[in] obj The object.
 *
 * @return The current position.
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI Eina_Position2D efl_gesture_touch_cur_point_get(const Eo *obj);

/**
 * @brief Returns the timestamp.
 *
 * @param[in] obj The object.
 *
 * @return The timestamp.
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI unsigned int efl_gesture_touch_cur_timestamp_get(const Eo *obj);

/**
 * @brief This property tells if the event is multi touch.
 *
 * @param[in] obj The object.
 *
 * @return returns @c true if its a multi touch
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI Eina_Bool efl_gesture_touch_multi_touch_get(const Eo *obj);

/**
 * @brief This property holds the state of the touch event.
 *
 * @param[in] obj The object.
 *
 * @return touch event state
 *
 * @ingroup Efl_Canvas_Gesture_Touch
 */
EOAPI Efl_Canvas_Gesture_Touch_State efl_gesture_touch_state_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
