/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OBRXMLWriter {
    public static ContentHandler newHandler(OutputStream outputStream, String string, boolean bl) throws TransformerConfigurationException {
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        Transformer transformer = sAXTransformerFactory.newTransformer();
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.setOutputProperty("encoding", string);
        transformer.setOutputProperty("indent", bl ? "yes" : "no");
        transformerHandler.setResult(streamResult);
        return transformerHandler;
    }

    public static void writeManifests(Iterator iterator, ContentHandler contentHandler, boolean bl) throws SAXException {
        int n = bl ? 4 : 1;
        contentHandler.startDocument();
        AttributesImpl attributesImpl = new AttributesImpl();
        contentHandler.startElement("", "repository", "repository", attributesImpl);
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            BundleInfo bundleInfo;
            ManifestAndLocation manifestAndLocation = (ManifestAndLocation)iterator.next();
            try {
                bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.setUri(manifestAndLocation.getUri());
                ++n2;
            }
            catch (ParseException parseException) {
                ++n3;
                IvyContext.getContext().getMessageLogger().log("Rejected " + manifestAndLocation.getUri() + ": " + parseException.getMessage(), n);
                continue;
            }
            OBRXMLWriter.saxBundleInfo(bundleInfo, contentHandler);
        }
        contentHandler.endElement("", "repository", "repository");
        contentHandler.endDocument();
        Message.info(n2 + " bundle" + (n2 > 1 ? "s" : "") + " added, " + n3 + " bundle" + (n3 > 1 ? "s" : "") + " rejected.");
    }

    public static void writeBundles(Iterator iterator, ContentHandler contentHandler) throws SAXException {
        contentHandler.startDocument();
        AttributesImpl attributesImpl = new AttributesImpl();
        contentHandler.startElement("", "repository", "repository", attributesImpl);
        while (iterator.hasNext()) {
            BundleInfo bundleInfo = (BundleInfo)iterator.next();
            OBRXMLWriter.saxBundleInfo(bundleInfo, contentHandler);
        }
        contentHandler.endElement("", "repository", "repository");
        contentHandler.endDocument();
    }

    private static void saxBundleInfo(BundleInfo bundleInfo, ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        OBRXMLWriter.addAttr(attributesImpl, "symbolicname", bundleInfo.getSymbolicName());
        OBRXMLWriter.addAttr(attributesImpl, "version", bundleInfo.getRawVersion());
        if (bundleInfo.getUri() != null) {
            OBRXMLWriter.addAttr(attributesImpl, "uri", bundleInfo.getUri().toString());
        }
        contentHandler.startElement("", "resource", "resource", attributesImpl);
        for (Object object : bundleInfo.getCapabilities()) {
            OBRXMLWriter.saxCapability((BundleCapability)object, contentHandler);
        }
        for (BundleRequirement bundleRequirement : bundleInfo.getRequirements()) {
            OBRXMLWriter.saxRequirement(bundleRequirement, contentHandler);
        }
        contentHandler.endElement("", "resource", "resource");
        contentHandler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxCapability(BundleCapability bundleCapability, ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = bundleCapability.getType();
        OBRXMLWriter.addAttr(attributesImpl, "name", string);
        contentHandler.startElement("", "capability", "capability", attributesImpl);
        if (!string.equals("bundle")) {
            if (string.equals("package")) {
                Set set;
                OBRXMLWriter.saxCapabilityProperty("package", bundleCapability.getName(), contentHandler);
                Version version = bundleCapability.getRawVersion();
                if (version != null) {
                    OBRXMLWriter.saxCapabilityProperty("version", version.toString(), contentHandler);
                }
                if ((set = ((ExportPackage)bundleCapability).getUses()) != null && !set.isEmpty()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string2 : set) {
                        if (stringBuffer.length() != 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(string2);
                    }
                    OBRXMLWriter.saxCapabilityProperty("uses", stringBuffer.toString(), contentHandler);
                }
            } else if (string.equals("service")) {
                OBRXMLWriter.saxCapabilityProperty("service", bundleCapability.getName(), contentHandler);
                Version version = bundleCapability.getRawVersion();
                if (version != null) {
                    OBRXMLWriter.saxCapabilityProperty("version", version.toString(), contentHandler);
                }
            }
        }
        contentHandler.endElement("", "capability", "capability");
        contentHandler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxCapabilityProperty(String string, String string2, ContentHandler contentHandler) throws SAXException {
        OBRXMLWriter.saxCapabilityProperty(string, null, string2, contentHandler);
    }

    private static void saxCapabilityProperty(String string, String string2, String string3, ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        OBRXMLWriter.addAttr(attributesImpl, "n", string);
        if (string2 != null) {
            OBRXMLWriter.addAttr(attributesImpl, "t", string2);
        }
        OBRXMLWriter.addAttr(attributesImpl, "v", string3);
        contentHandler.startElement("", "p", "p", attributesImpl);
        contentHandler.endElement("", "p", "p");
        contentHandler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxRequirement(BundleRequirement bundleRequirement, ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        OBRXMLWriter.addAttr(attributesImpl, "name", bundleRequirement.getType());
        if ("optional".equals(bundleRequirement.getResolution())) {
            OBRXMLWriter.addAttr(attributesImpl, "optional", Boolean.TRUE.toString());
        }
        OBRXMLWriter.addAttr(attributesImpl, "filter", OBRXMLWriter.buildFilter(bundleRequirement));
        contentHandler.startElement("", "require", "require", attributesImpl);
        contentHandler.endElement("", "require", "require");
        contentHandler.characters("\n".toCharArray(), 0, 1);
    }

    private static String buildFilter(BundleRequirement bundleRequirement) {
        StringBuffer stringBuffer = new StringBuffer();
        VersionRange versionRange = bundleRequirement.getVersion();
        if (versionRange != null) {
            OBRXMLWriter.appendVersion(stringBuffer, versionRange);
        }
        stringBuffer.append('(');
        stringBuffer.append(bundleRequirement.getType());
        stringBuffer.append("=");
        stringBuffer.append(bundleRequirement.getName());
        stringBuffer.append(')');
        if (versionRange != null) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static void appendVersion(StringBuffer stringBuffer, VersionRange versionRange) {
        Version version;
        stringBuffer.append("(&");
        Version version2 = versionRange.getStartVersion();
        if (version2 != null) {
            if (!versionRange.isStartExclusive()) {
                stringBuffer.append("(version>=");
                stringBuffer.append(version2.toString());
                stringBuffer.append(')');
            } else {
                stringBuffer.append("(!");
                stringBuffer.append("(version<=");
                stringBuffer.append(version2.toString());
                stringBuffer.append("))");
            }
        }
        if ((version = versionRange.getEndVersion()) != null) {
            if (!versionRange.isEndExclusive()) {
                stringBuffer.append("(version<=");
                stringBuffer.append(version.toString());
                stringBuffer.append(')');
            } else {
                stringBuffer.append("(!");
                stringBuffer.append("(version>=");
                stringBuffer.append(version.toString());
                stringBuffer.append("))");
            }
        }
    }

    private static void addAttr(AttributesImpl attributesImpl, String string, String string2) {
        if (string2 != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
    }

    private static void addAttr(AttributesImpl attributesImpl, String string, Object object) {
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", object.toString());
        }
    }
}

