/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.extensions.TargetWithVariantExtKt;
import com.jetbrains.extenstions.ContextAnchor;
import com.jetbrains.extenstions.ModuleBasedContextAnchor;
import com.jetbrains.extenstions.NameAndElement;
import com.jetbrains.extenstions.QNameResolveContext;
import com.jetbrains.extenstions.QualifiedNameExtKt;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.targetBasedConfiguration.PyRunTargetVariant;
import com.jetbrains.python.run.targetBasedConfiguration.TargetWithVariant;
import com.jetbrains.python.testing.ConfigField;
import com.jetbrains.python.testing.ConfigurationTarget$WhenMappings;
import com.jetbrains.python.testing.PyAbstractTestConfiguration;
import com.jetbrains.python.testing.PyQNameResolveAndSplitUtilsKt;
import com.jetbrains.python.testing.QualifiedNameParts;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0000J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R$\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/jetbrains/python/testing/ConfigurationTarget;", "Lcom/jetbrains/python/run/targetBasedConfiguration/TargetWithVariant;", "target", "", "targetType", "Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;", "(Ljava/lang/String;Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;)V", "target$annotations", "()V", "getTarget", "()Ljava/lang/String;", "setTarget", "(Ljava/lang/String;)V", "targetType$annotations", "getTargetType", "()Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;", "setTargetType", "(Lcom/jetbrains/python/run/targetBasedConfiguration/PyRunTargetVariant;)V", "asPsiElement", "Lcom/intellij/psi/PsiElement;", "configuration", "Lcom/jetbrains/python/testing/PyAbstractTestConfiguration;", "checkValid", "", "component1", "component2", "copy", "copyTo", "dst", "equals", "", "other", "", "generateArgumentsLine", "", "getArgumentsForPythonTarget", "getElementDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashCode", "", "toString", "intellij.python.community.impl"})
public final class ConfigurationTarget
implements TargetWithVariant {
    @NotNull
    private String target;
    @NotNull
    private PyRunTargetVariant targetType;

    public final void copyTo(@NotNull ConfigurationTarget dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        dst.setTarget(this.getTarget());
        dst.setTargetType(this.getTargetType());
    }

    public final void checkValid() {
        if (this.getTargetType() != PyRunTargetVariant.CUSTOM) {
            CharSequence charSequence = this.getTarget();
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new RuntimeConfigurationWarning("Target not provided");
            }
        }
        if (this.getTargetType() == PyRunTargetVariant.PYTHON && !TargetWithVariantExtKt.isWellFormed(this)) {
            throw (Throwable)new RuntimeConfigurationError("Provide a qualified name of function, class or a module");
        }
    }

    @Nullable
    public final PsiElement asPsiElement(@NotNull PyAbstractTestConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        return TargetWithVariantExtKt.asPsiElement(this, configuration, configuration.getWorkingDirectoryAsVirtual$intellij_python_community_impl());
    }

    @NotNull
    public final List<String> generateArgumentsLine(@NotNull PyAbstractTestConfiguration configuration) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        switch (ConfigurationTarget$WhenMappings.$EnumSwitchMapping$0[this.getTargetType().ordinal()]) {
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = this.getArgumentsForPythonTarget(configuration);
                break;
            }
            case 3: {
                String string;
                Object[] objectArray = new String[2];
                objectArray[0] = "--path";
                String string2 = this.getTarget();
                int n = 1;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                objectArray2[n] = string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                list = CollectionsKt.listOf((Object[])objectArray3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<String> getArgumentsForPythonTarget(PyAbstractTestConfiguration configuration) {
        VirtualFile elementFile;
        PsiElement psiElement = this.asPsiElement(configuration);
        if (psiElement == null) {
            throw (Throwable)new ExecutionException("Can't resolve " + this.getTarget() + ". Try to remove configuration and generate it again");
        }
        PsiElement element = psiElement;
        if (element instanceof PsiDirectory) {
            Object[] objectArray = new String[2];
            objectArray[0] = "--path";
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"element.virtualFile");
            String string = virtualFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.virtualFile.path");
            objectArray[1] = string;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(configuration.getProject(), null);
        Module module2 = configuration.getModule();
        if (module2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"configuration.module!!");
        ContextAnchor contextAnchor = new ModuleBasedContextAnchor(module2);
        TypeEvalContext typeEvalContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"context");
        QNameResolveContext qNameResolveContext = new QNameResolveContext(contextAnchor, null, typeEvalContext, LocalFileSystem.getInstance().findFileByPath(configuration.getWorkingDirectorySafe()), true, 2, null);
        String string = this.getTarget();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedName, (String)"QualifiedName.fromDottedString(target.trim())");
        QualifiedNameParts qualifiedNameParts = PyQNameResolveAndSplitUtilsKt.tryResolveAndSplit(qualifiedName, qNameResolveContext);
        if (qualifiedNameParts == null) {
            throw (Throwable)new ExecutionException("Can't find file where " + this.getTarget() + " declared. " + "Make sure it is in project root");
        }
        QualifiedNameParts qualifiedNameParts2 = qualifiedNameParts;
        if (!configuration.shouldSeparateTargetPath$intellij_python_community_impl()) {
            PyFile pyFile;
            QualifiedName qNameInsideOfDirectory = QualifiedNameParts.getElementNamePrependingFile$default(qualifiedNameParts2, null, 1, null);
            NameAndElement elementAndName = QualifiedNameExtKt.getElementAndResolvableName$default(qNameInsideOfDirectory, QNameResolveContext.copy$default(qNameResolveContext, null, null, null, null, false, 15, null), false, 2, null);
            if (elementAndName != null) {
                Object[] objectArray = new String[2];
                objectArray[0] = "--target";
                String string3 = elementAndName.getName().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"elementAndName.name.toString()");
                objectArray[1] = string3;
                return CollectionsKt.listOf((Object[])objectArray);
            }
            PsiFile psiFile = element.getContainingFile();
            if (!(psiFile instanceof PyFile)) {
                psiFile = null;
            }
            if ((pyFile = (PyFile)psiFile) == null || (pyFile = PsiFileSystemItemExtKt.getQName((PsiFileSystemItem)pyFile)) == null || (pyFile = pyFile.append(qualifiedNameParts2.getElementName())) == null) {
                throw (Throwable)new ExecutionException("Can't get importable name for " + element.getContainingFile() + ". Is it a python file in project?");
            }
            PyFile name = pyFile;
            Object[] objectArray = new String[2];
            objectArray[0] = "--target";
            String string4 = name.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name.toString()");
            objectArray[1] = string4;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        QualifiedName pyTarget = qualifiedNameParts2.getElementName();
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        VirtualFile virtualFile = elementFile = psiFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"elementFile");
        VirtualFile workingDir = virtualFile.getFileSystem().findFileByPath(configuration.getWorkingDirectorySafe());
        String string5 = workingDir != null ? VfsUtil.getRelativePath((VirtualFile)elementFile, (VirtualFile)workingDir) : null;
        if (string5 == null) {
            string5 = elementFile.getPath();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(if (workingDir != null)\u2026      ?: elementFile.path");
        String fileSystemPartOfTarget = string5;
        if (pyTarget.getComponentCount() == 0) {
            return CollectionsKt.listOf((Object[])new String[]{"--path", fileSystemPartOfTarget});
        }
        return CollectionsKt.listOf((Object[])new String[]{"--target", fileSystemPartOfTarget + "::" + pyTarget});
    }

    @Nullable
    public final VirtualFile getElementDirectory(@NotNull PyAbstractTestConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        if (Intrinsics.areEqual((Object)this.getTarget(), (Object)"")) {
            return null;
        }
        Object object = TargetWithVariantExtKt.asVirtualFile(this);
        if (object == null) {
            PsiElement psiElement = this.asPsiElement(configuration);
            object = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
        }
        if (object == null) {
            return null;
        }
        VirtualFile fileOrDir = object;
        return fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
    }

    @ConfigField
    public static /* synthetic */ void target$annotations() {
    }

    @Override
    @NotNull
    public String getTarget() {
        return this.target;
    }

    public void setTarget(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.target = string;
    }

    @ConfigField
    public static /* synthetic */ void targetType$annotations() {
    }

    @Override
    @NotNull
    public PyRunTargetVariant getTargetType() {
        return this.targetType;
    }

    public void setTargetType(@NotNull PyRunTargetVariant pyRunTargetVariant) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)pyRunTargetVariant), (String)"<set-?>");
        this.targetType = pyRunTargetVariant;
    }

    public ConfigurationTarget(@NotNull String target, @NotNull PyRunTargetVariant targetType) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetType), (String)"targetType");
        this.target = target;
        this.targetType = targetType;
    }

    @NotNull
    public final String component1() {
        return this.getTarget();
    }

    @NotNull
    public final PyRunTargetVariant component2() {
        return this.getTargetType();
    }

    @NotNull
    public final ConfigurationTarget copy(@NotNull String target, @NotNull PyRunTargetVariant targetType) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetType), (String)"targetType");
        return new ConfigurationTarget(target, targetType);
    }

    public static /* synthetic */ ConfigurationTarget copy$default(ConfigurationTarget configurationTarget, String string, PyRunTargetVariant pyRunTargetVariant, int n, Object object) {
        if ((n & 1) != 0) {
            string = configurationTarget.getTarget();
        }
        if ((n & 2) != 0) {
            pyRunTargetVariant = configurationTarget.getTargetType();
        }
        return configurationTarget.copy(string, pyRunTargetVariant);
    }

    @NotNull
    public String toString() {
        return "ConfigurationTarget(target=" + this.getTarget() + ", targetType=" + (Object)((Object)this.getTargetType()) + ")";
    }

    public int hashCode() {
        String string = this.getTarget();
        PyRunTargetVariant pyRunTargetVariant = this.getTargetType();
        return (string != null ? string.hashCode() : 0) * 31 + (pyRunTargetVariant != null ? ((Object)((Object)pyRunTargetVariant)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ConfigurationTarget)) break block3;
                ConfigurationTarget configurationTarget = (ConfigurationTarget)object;
                if (!Intrinsics.areEqual((Object)this.getTarget(), (Object)configurationTarget.getTarget()) || !Intrinsics.areEqual((Object)((Object)this.getTargetType()), (Object)((Object)configurationTarget.getTargetType()))) break block3;
            }
            return true;
        }
        return false;
    }
}

