/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.ProjectScopeBuilderImpl;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyProjectScopeBuilder
extends ProjectScopeBuilderImpl {
    public PyProjectScopeBuilder(Project project) {
        super(project);
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        ProjectAndLibrariesScope projectAndLibrariesScope = new ProjectAndLibrariesScope(this.myProject){

            public boolean isSearchOutsideRootModel() {
                return true;
            }
        };
        if (projectAndLibrariesScope == null) {
            PyProjectScopeBuilder.$$$reportNull$$$0(0);
        }
        return projectAndLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        final FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.myProject);
        ProjectScopeImpl projectScopeImpl = new ProjectScopeImpl(this.myProject, fileIndex){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file instanceof VirtualFileWindow) {
                    return true;
                }
                return fileIndex.isInContent(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/search/PyProjectScopeBuilder$2", "contains"));
            }
        };
        if (projectScopeImpl == null) {
            PyProjectScopeBuilder.$$$reportNull$$$0(1);
        }
        return projectScopeImpl;
    }

    public static GlobalSearchScope excludeSdkTestsScope(Project project) {
        return PyProjectScopeBuilder.excludeSdkTestScope(ProjectScope.getAllScope((Project)project));
    }

    @NotNull
    public static GlobalSearchScope excludeSdkTestScope(@NotNull GlobalSearchScope scope) {
        Sdk sdk;
        Project project;
        GlobalSearchScope exclude;
        if (scope == null) {
            PyProjectScopeBuilder.$$$reportNull$$$0(2);
        }
        GlobalSearchScope globalSearchScope = (exclude = PyProjectScopeBuilder.excludeSdkTestsScope(project = (Project)ObjectUtils.notNull((Object)scope.getProject()), sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk())) != null ? scope.intersectWith(exclude) : scope;
        if (globalSearchScope == null) {
            PyProjectScopeBuilder.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    public static GlobalSearchScope excludeSdkTestsScope(PsiElement anchor) {
        GlobalSearchScope excludeScope;
        Sdk sdk;
        Project project = anchor.getProject();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor);
        if (module2 != null && (sdk = PythonSdkType.findPythonSdk(module2)) != null && (excludeScope = PyProjectScopeBuilder.excludeSdkTestsScope(project, sdk)) != null) {
            return GlobalSearchScope.allScope((Project)project).intersectWith(excludeScope);
        }
        return PyProjectScopeBuilder.excludeSdkTestsScope(project);
    }

    @Nullable
    private static GlobalSearchScope excludeSdkTestsScope(Project project, Sdk sdk) {
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            ArrayList<VirtualFile> excludedDirs = new ArrayList<VirtualFile>();
            VirtualFile libDir = PyProjectScopeBuilder.findLibDir(sdk);
            if (libDir != null) {
                excludedDirs.addAll(PyProjectScopeBuilder.findTestDirs(libDir, "test", "bsddb/test", "ctypes/test", "distutils/tests", "email/test", "importlib/test", "json/tests", "lib2to3/tests", "sqlite3/test", "tkinter/test", "idlelib/testcode.py"));
            }
            excludedDirs.addAll(Arrays.stream(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)).filter(file -> PyTypeShed.INSTANCE.isInside((VirtualFile)file) || PyTypeShed.INSTANCE.isInThirdPartyLibraries((VirtualFile)file)).collect(Collectors.toList()));
            if (!excludedDirs.isEmpty()) {
                GlobalSearchScope scope = PyProjectScopeBuilder.buildUnionScope(project, excludedDirs);
                return GlobalSearchScope.notScope((GlobalSearchScope)scope);
            }
        }
        return null;
    }

    private static GlobalSearchScope buildUnionScope(Project project, List<VirtualFile> testDirs) {
        GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)testDirs.get(0), (boolean)true);
        for (int i = 1; i < testDirs.size(); ++i) {
            scope = scope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)testDirs.get(i), (boolean)true));
        }
        return scope;
    }

    private static List<VirtualFile> findTestDirs(VirtualFile baseDir, String ... relativePaths) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : relativePaths) {
            VirtualFile child = baseDir.findFileByRelativePath(path);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    @Nullable
    public static VirtualFile findLibDir(Sdk sdk) {
        return PyProjectScopeBuilder.findLibDir(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
    }

    public static VirtualFile findVirtualEnvLibDir(Sdk sdk) {
        File root;
        VirtualFile[] classVFiles = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        String homePath = sdk.getHomePath();
        if (homePath != null && (root = PythonSdkType.getVirtualEnvRoot(homePath)) != null) {
            File versionRoot;
            File libRoot = new File(root, "lib");
            Object[] versionRoots = libRoot.listFiles();
            if (versionRoots != null && !SystemInfo.isWindows && (versionRoot = (File)ContainerUtil.find((Object[])versionRoots, file -> file.isDirectory() && file.getName().startsWith("python"))) != null) {
                libRoot = versionRoot;
            }
            String libRootPath = libRoot.getPath();
            for (VirtualFile file2 : classVFiles) {
                if (FileUtil.pathsEqual((String)file2.getPath(), (String)libRootPath)) {
                    return file2;
                }
                VirtualFile parent = file2.getParent();
                if (!"site-packages".equals(file2.getName()) || !FileUtil.pathsEqual((String)parent.getPath(), (String)libRootPath)) continue;
                return parent;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findLibDir(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isValid()) continue;
            if ((file.findChild("__future__.py") != null || file.findChild("__future__.pyc") != null) && file.findChild("xml") != null && file.findChild("email") != null) {
                return file;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() || !file.getName().equals("Lib")) continue;
            return file;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/search/PyProjectScopeBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProjectScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/search/PyProjectScopeBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeSdkTestScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "excludeSdkTestScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

