/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;

public class MessageBusUtil {
    private static <T> Runnable createPublisherRunnable(Project project, Topic<? extends T> topic, Consumer<? super T> listener2) {
        return () -> {
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            listener2.consume(project.getMessageBus().syncPublisher(topic));
        };
    }

    public static <T> void invokeLaterIfNeededOnSyncPublisher(Project project, Topic<? extends T> topic, Consumer<? super T> listener2) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = MessageBusUtil.createPublisherRunnable(project, topic, listener2);
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2);
        }
    }
}

