/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.wrappers;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Collections;

public class PsiEventWrapperAspect
implements PomModelAspect {
    private final TreeAspect myTreeAspect;

    public PsiEventWrapperAspect(PomModel model2, TreeAspect aspect) {
        this.myTreeAspect = aspect;
        model2.registerAspect(PsiEventWrapperAspect.class, (PomModelAspect)this, Collections.singleton(aspect));
    }

    public void update(PomModelEvent event) {
        TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)this.myTreeAspect);
        if (changeSet == null) {
            return;
        }
        PsiEventWrapperAspect.sendAfterEvents(changeSet);
    }

    private static void sendAfterEvents(TreeChangeEvent changeSet) {
        ASTNode rootElement = changeSet.getRootElement();
        PsiFile file2 = (PsiFile)rootElement.getPsi();
        if (!file2.isPhysical()) {
            PsiEventWrapperAspect.promoteNonPhysicalChangesToDocument(rootElement, file2);
            ((PsiManagerImpl)file2.getManager()).afterChange(false);
            return;
        }
        ((TreeChangeEventImpl)changeSet).fireEvents();
    }

    private static void promoteNonPhysicalChangesToDocument(ASTNode rootElement, PsiFile file2) {
        Document document;
        if (file2 instanceof DummyHolder) {
            return;
        }
        if (((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)file2.getProject())).isCommitInProgress()) {
            return;
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        if (vFile instanceof LightVirtualFile && !(vFile instanceof VirtualFileWindow) && (document = FileDocumentManager.getInstance().getCachedDocument(vFile)) != null) {
            CharSequence text2 = rootElement.getChars();
            PsiToDocumentSynchronizer.performAtomically(file2, () -> document.replaceString(0, document.getTextLength(), text2));
        }
    }
}

