/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

class SimpleBanner
extends JPanel {
    private final AnimatedIcon.Default myAnimatedIcon = new AnimatedIcon.Default();
    private boolean myShowProgress;
    protected final JPanel myLeftPanel;
    protected final JLabel myProgress = new JLabel(EmptyIcon.ICON_16);
    protected Component myLeftComponent;
    protected Component myCenterComponent;

    SimpleBanner() {
        super(new BorderLayout(10, 0));
        this.myLeftPanel = new NonOpaquePanel(new FlowLayout(1, 0, 0){

            @Override
            public Dimension preferredLayoutSize(Container target2) {
                return SimpleBanner.this.getPreferredLeftPanelSize(super.preferredLayoutSize(target2));
            }

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                SimpleBanner.this.baselineLayout();
            }
        }){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, 0, width, height + y);
            }
        };
        this.myLeftPanel.add(this.myProgress);
        this.add("West", this.myLeftPanel);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (this.myLeftPanel != null) {
            this.myLeftPanel.setBorder(border);
        }
    }

    Dimension getPreferredLeftPanelSize(Dimension size) {
        return size;
    }

    private void baselineLayout() {
        Component template = this.getBaselineTemplate();
        if (template == null) {
            return;
        }
        int baseline = template.getBaseline(template.getWidth(), template.getHeight());
        if (baseline == -1) {
            return;
        }
        int components = this.myLeftPanel.getComponentCount();
        for (int i = 0; i < components; ++i) {
            Component component = this.myLeftPanel.getComponent(i);
            if (component == template) continue;
            int y = component == this.myProgress ? (int)(JBUIScale.scale((float)1.5f) + (float)(template.getHeight() - component.getHeight()) / 2.0f) : baseline - component.getBaseline(component.getWidth(), component.getHeight());
            component.setLocation(component.getX(), this.getInsets().top + y);
        }
    }

    void setLeftComponent(Component component) {
        if (this.myLeftComponent != null) {
            this.myLeftPanel.remove(this.myLeftComponent);
            this.myLeftComponent = null;
        }
        if (component != null) {
            this.myLeftComponent = component;
            this.myLeftPanel.add(component, 0);
        }
        this.updateProgressBorder();
    }

    void setCenterComponent(Component component) {
        if (this.myCenterComponent != null) {
            this.remove(this.myCenterComponent);
        }
        this.myCenterComponent = component;
        if (component != null) {
            this.add(component);
        }
    }

    void showProgress(boolean start2) {
        this.myShowProgress = start2;
        this.myProgress.setIcon((Icon)(start2 ? this.myAnimatedIcon : EmptyIcon.ICON_16));
        this.updateProgressBorder();
    }

    void updateProgressBorder() {
        this.myProgress.setBorder((Border)(this.myLeftPanel.getComponentCount() == 1 ? JBUI.Borders.emptyLeft((int)10) : null));
    }

    boolean canShow() {
        return this.myLeftComponent != null || this.myCenterComponent != null || this.myShowProgress;
    }

    Component getBaselineTemplate() {
        return this.myCenterComponent;
    }
}

