/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/fileTypes/impl/HashBangFileTypeDetector;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry$FileTypeDetector;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "marker", "", "_version", "", "(Lcom/intellij/openapi/fileTypes/FileType;Ljava/lang/String;I)V", "get_version", "()I", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getMarker", "()Ljava/lang/String;", "detect", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstBytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "firstCharsIfText", "", "getDetectedFileTypes", "", "getVersion", "intellij.platform.ide.impl"})
public class HashBangFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final String marker;
    private final int _version;

    @Nullable
    public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)firstBytes, (String)"firstBytes");
        return FileUtil.isHashBangLine((CharSequence)firstCharsIfText, (String)this.marker) ? this.fileType : null;
    }

    public int getVersion() {
        return this._version;
    }

    @NotNull
    public Collection<FileType> getDetectedFileTypes() {
        return CollectionsKt.listOf((Object)this.fileType);
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final String getMarker() {
        return this.marker;
    }

    public final int get_version() {
        return this._version;
    }

    @JvmOverloads
    public HashBangFileTypeDetector(@NotNull FileType fileType, @NotNull String marker, int _version) {
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        this.fileType = fileType;
        this.marker = marker;
        this._version = _version;
    }

    public /* synthetic */ HashBangFileTypeDetector(FileType fileType, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(fileType, string, n);
    }

    @JvmOverloads
    public HashBangFileTypeDetector(@NotNull FileType fileType, @NotNull String marker) {
        this(fileType, marker, 0, 4, null);
    }
}

