/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0006*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SALT_PREFERENCE_KEY", "", "anonymizedCache", "Ljava/util/HashMap;", "bucket", "", "getBucket", "()I", "build", "getBuild", "()Ljava/lang/String;", "deviceId", "getDeviceId", "salt", "", "sessionId", "getSessionId", "anonymize", "data", "getOrGenerateSalt", "asBucket", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "shortedUUID", "intellij.platform.ide.impl"})
public final class EventLogConfiguration {
    private static final Logger LOG;
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    @NotNull
    private static final String sessionId;
    @NotNull
    private static final String deviceId;
    private static final int bucket;
    @NotNull
    private static final String build;
    private static final byte[] salt;
    private static final HashMap<String, String> anonymizedCache;
    public static final EventLogConfiguration INSTANCE;

    @NotNull
    public final String getSessionId() {
        return sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return deviceId;
    }

    public final int getBucket() {
        return bucket;
    }

    @NotNull
    public final String getBuild() {
        return build;
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (StringUtil.isEmptyOrSpaces((String)data)) {
            return data;
        }
        if (anonymizedCache.containsKey(data)) {
            String string = anonymizedCache.get(data);
            if (string == null) {
                string = "";
            }
            return string;
        }
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putBytes(salt);
        hasher.putString((CharSequence)data, Charsets.UTF_8);
        String string = hasher.hash().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hasher.hash().toString()");
        String result2 = string;
        ((Map)anonymizedCache).put(data, result2);
        return result2;
    }

    private final String shortedUUID(@NotNull String $this$shortedUUID) {
        int start2 = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start2 > 0 && start2 + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID;
            int n = start2 + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $this$shortedUUID;
    }

    private final String asBuildNumber(@NotNull BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.asStringWithoutProductCodeAndSnapshot()");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    private final int asBucket(@NotNull String $this$asBucket) {
        return Math.abs($this$asBucket.hashCode()) % 256;
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        String companyName = applicationInfoEx.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string2 = companyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"companyName");
            String string3 = string2;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        byte[] salt = prefs.getByteArray(SALT_PREFERENCE_KEY, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(SALT_PREFERENCE_KEY, salt);
            LOG.info("Generating salt for the device");
        }
        return salt;
    }

    private EventLogConfiguration() {
    }

    static {
        EventLogConfiguration eventLogConfiguration;
        INSTANCE = eventLogConfiguration = new EventLogConfiguration();
        Logger logger = Logger.getInstance(EventLogConfiguration.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Event\u2026onfiguration::class.java)");
        LOG = logger;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        sessionId = eventLogConfiguration.shortedUUID(string);
        deviceId = DeviceIdManager.INSTANCE.getOrGenerateId();
        bucket = eventLogConfiguration.asBucket(deviceId);
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        build = eventLogConfiguration.asBuildNumber(buildNumber);
        salt = eventLogConfiguration.getOrGenerateSalt();
        anonymizedCache = new HashMap();
    }
}

