/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.TitledHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.refactoring.XmlTagInplaceRenamer;
import com.intellij.xml.refactoring.XmlTagRenameDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagRenameHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.refactoring.XmlTagRenameHandler");

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(0);
        }
        if ((element = XmlTagRenameHandler.getElement(dataContext)) == null || PsiElementRenameHandler.isVetoed((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        XmlTag tag = (XmlTag)parent;
        String prefix = tag.getNamespacePrefix();
        if (StringUtil.isNotEmpty((String)prefix)) {
            Editor editor = XmlTagRenameHandler.getEditor(dataContext);
            assert (editor != null);
            int offset = editor.getCaretModel().getOffset();
            if (offset <= element.getTextRange().getStartOffset() + prefix.length()) {
                return false;
            }
        }
        return XmlTagRenameHandler.isDeclarationOutOfProjectOrAbsent(element.getProject(), dataContext);
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(1);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public String getActionTitle() {
        return "Rename XML tag";
    }

    private static boolean isInplaceRenameAvailable(Editor editor) {
        return editor.getSettings().isVariableInplaceRenameEnabled();
    }

    private static boolean isDeclarationOutOfProjectOrAbsent(@NotNull Project project, DataContext context) {
        PsiElement[] elements;
        if (project == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(2);
        }
        return (elements = BaseRefactoringAction.getPsiElementArray((DataContext)context)).length == 0 || elements.length == 1 && XmlTagRenameHandler.shouldBeRenamedInplace(project, elements);
    }

    private static boolean shouldBeRenamedInplace(Project project, PsiElement[] elements) {
        boolean inProject = PsiManager.getInstance((Project)project).isInProject(elements[0]);
        if (inProject && elements[0] instanceof XmlTag) {
            XmlElementDescriptor descriptor = ((XmlTag)elements[0]).getDescriptor();
            return descriptor instanceof AnyXmlElementDescriptor;
        }
        return !inProject;
    }

    @Nullable
    private static Editor getEditor(@Nullable DataContext context) {
        return (Editor)CommonDataKeys.EDITOR.getData(context);
    }

    @Nullable
    private static PsiElement getElement(@Nullable DataContext context) {
        Editor editor;
        if (context != null && (editor = XmlTagRenameHandler.getEditor(context)) != null) {
            PsiFile psiAtOffset;
            Language language;
            int offset = editor.getCaretModel().getOffset();
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (file instanceof XmlFile) {
                return file.getViewProvider().findElementAt(offset);
            }
            if (file != null && (language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset)) != file.getLanguage() && (psiAtOffset = file.getViewProvider().getPsi(language)) instanceof XmlFile) {
                return psiAtOffset.findElementAt(offset);
            }
        }
        return null;
    }

    private void invoke(@Nullable Editor editor, @NotNull PsiElement element, @Nullable DataContext context) {
        if (element == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(3);
        }
        if (!this.isRenaming(context)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        if (XmlTagRenameHandler.isInplaceRenameAvailable(editor)) {
            XmlTagInplaceRenamer.rename(editor, (XmlTag)element.getParent());
        } else {
            XmlTagRenameDialog.renameXmlTag(editor, element, (XmlTag)element.getParent());
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(4);
        }
        if (!this.isRenaming(dataContext)) {
            return;
        }
        PsiElement element = XmlTagRenameHandler.getElement(dataContext);
        assert (element != null);
        this.invoke(editor, element, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = XmlTagRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        this.invoke(XmlTagRenameHandler.getEditor(dataContext), element, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/refactoring/XmlTagRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeclarationOutOfProjectOrAbsent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

