/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lexer.DtdLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XHtmlHighlightingLexer;
import com.intellij.lexer.XmlHighlightingLexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlFileHighlighter
extends SyntaxHighlighterBase {
    static final ExtensionPointName<EmbeddedTokenHighlighter> EMBEDDED_HIGHLIGHTERS = ExtensionPointName.create((String)"com.intellij.embeddedTokenHighlighter");
    private static final MultiMap<IElementType, TextAttributesKey> ourMap = MultiMap.create();
    private final boolean myIsDtd;
    private boolean myIsXHtml;

    public XmlFileHighlighter() {
        this(false);
    }

    public XmlFileHighlighter(boolean dtd) {
        this.myIsDtd = dtd;
    }

    public XmlFileHighlighter(boolean dtd, boolean xhtml) {
        this.myIsDtd = dtd;
        this.myIsXHtml = xhtml;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        if (this.myIsDtd) {
            DtdLexer dtdLexer = new DtdLexer(true);
            if (dtdLexer == null) {
                XmlFileHighlighter.$$$reportNull$$$0(0);
            }
            return dtdLexer;
        }
        if (this.myIsXHtml) {
            XHtmlHighlightingLexer xHtmlHighlightingLexer = new XHtmlHighlightingLexer();
            if (xHtmlHighlightingLexer == null) {
                XmlFileHighlighter.$$$reportNull$$$0(1);
            }
            return xHtmlHighlightingLexer;
        }
        XmlHighlightingLexer xmlHighlightingLexer = new XmlHighlightingLexer();
        if (xmlHighlightingLexer == null) {
            XmlFileHighlighter.$$$reportNull$$$0(2);
        }
        return xmlHighlightingLexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        // MONITORENTER : clazz
        TextAttributesKey[] textAttributesKeyArray = ourMap.get((Object)tokenType).toArray(TextAttributesKey.EMPTY_ARRAY);
        // MONITOREXIT : clazz
        if (textAttributesKeyArray != null) return textAttributesKeyArray;
        XmlFileHighlighter.$$$reportNull$$$0(3);
        return textAttributesKeyArray;
    }

    @Deprecated
    public static synchronized void registerEmbeddedTokenAttributes(Map<IElementType, TextAttributesKey> _keys1, Map<IElementType, TextAttributesKey> _keys2) {
        HashSet<IElementType> existingKeys = new HashSet<IElementType>(ourMap.keySet());
        XmlFileHighlighter.addMissing(_keys1, existingKeys, ourMap);
        XmlFileHighlighter.addMissing(_keys2, existingKeys, ourMap);
    }

    static void addMissing(Map<IElementType, TextAttributesKey> from, Set<IElementType> existingKeys, MultiMap<IElementType, TextAttributesKey> to) {
        if (from != null) {
            for (Map.Entry<IElementType, TextAttributesKey> entry : from.entrySet()) {
                if (existingKeys.contains(entry.getKey())) continue;
                to.putValue((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    static {
        ourMap.putValue((Object)XmlTokenType.XML_DATA_CHARACTERS, (Object)XmlHighlighterColors.XML_TAG_DATA);
        for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_COMMENT_START, XmlTokenType.XML_COMMENT_END, XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_CONDITIONAL_COMMENT_END, XmlTokenType.XML_CONDITIONAL_COMMENT_END_START, XmlTokenType.XML_CONDITIONAL_COMMENT_START, XmlTokenType.XML_CONDITIONAL_COMMENT_START_END})) {
            ourMap.putValue((Object)type, (Object)XmlHighlighterColors.XML_COMMENT);
        }
        for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE})) {
            ourMap.putValue((Object)type, (Object)XmlHighlighterColors.XML_TAG);
        }
        for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_CONDITIONAL_IGNORE, XmlTokenType.XML_CONDITIONAL_INCLUDE})) {
            ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_TAG_NAME));
        }
        ourMap.putValues((Object)XmlTokenType.XML_NAME, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_ATTRIBUTE_NAME));
        for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_EQ, XmlTokenType.XML_TAG_CHARACTERS, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER})) {
            ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_ATTRIBUTE_VALUE));
        }
        for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_DECL_START, XmlTokenType.XML_DOCTYPE_START, XmlTokenType.XML_DOCTYPE_SYSTEM, XmlTokenType.XML_DOCTYPE_PUBLIC, XmlTokenType.XML_ATTLIST_DECL_START, XmlTokenType.XML_ELEMENT_DECL_START, XmlTokenType.XML_ENTITY_DECL_START})) {
            ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_TAG_NAME));
        }
        for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_SECTION_START, XmlTokenType.XML_CONDITIONAL_SECTION_END, XmlTokenType.XML_DECL_END, XmlTokenType.XML_DOCTYPE_END})) {
            ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_PROLOGUE, XmlHighlighterColors.XML_TAG_NAME));
        }
        ourMap.putValue((Object)XmlTokenType.XML_PI_START, (Object)XmlHighlighterColors.XML_PROLOGUE);
        ourMap.putValue((Object)XmlTokenType.XML_PI_END, (Object)XmlHighlighterColors.XML_PROLOGUE);
        ourMap.putValue((Object)XmlTokenType.XML_CHAR_ENTITY_REF, (Object)XmlHighlighterColors.XML_ENTITY_REFERENCE);
        ourMap.putValue((Object)XmlTokenType.XML_ENTITY_REF_TOKEN, (Object)XmlHighlighterColors.XML_ENTITY_REFERENCE);
        ourMap.putValue((Object)XmlTokenType.XML_BAD_CHARACTER, (Object)HighlighterColors.BAD_CHARACTER);
        for (EmbeddedTokenHighlighter highlighter : EMBEDDED_HIGHLIGHTERS.getExtensionList()) {
            MultiMap<IElementType, TextAttributesKey> attributes = highlighter.getEmbeddedTokenAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                if (ourMap.containsKey(entry.getKey())) continue;
                ourMap.putValues(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/highlighter/XmlFileHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

