/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

public interface NodeOptions {
    public boolean isFlattenPackages();

    public boolean isAbbreviatePackageNames();

    public boolean isHideEmptyMiddlePackages();

    default public boolean isCompactDirectories() {
        return false;
    }

    public boolean isShowLibraryContents();

    public static class Immutable
    implements NodeOptions {
        public static final NodeOptions DEFAULT = new Immutable(null);
        private final boolean myFlattenPackages;
        private final boolean myAbbreviatePackageNames;
        private final boolean myHideEmptyMiddlePackages;
        private final boolean myCompactDirectories;
        private final boolean myShowLibraryContents;

        public Immutable(NodeOptions options) {
            this.myFlattenPackages = options != null && options.isFlattenPackages();
            this.myAbbreviatePackageNames = options != null && options.isAbbreviatePackageNames();
            this.myHideEmptyMiddlePackages = options != null && options.isHideEmptyMiddlePackages();
            this.myCompactDirectories = options != null && options.isCompactDirectories();
            this.myShowLibraryContents = options != null && options.isShowLibraryContents();
        }

        @Override
        public boolean isFlattenPackages() {
            return this.myFlattenPackages;
        }

        @Override
        public boolean isAbbreviatePackageNames() {
            return this.myAbbreviatePackageNames;
        }

        @Override
        public boolean isHideEmptyMiddlePackages() {
            return this.myHideEmptyMiddlePackages;
        }

        @Override
        public boolean isCompactDirectories() {
            return this.myCompactDirectories;
        }

        @Override
        public boolean isShowLibraryContents() {
            return this.myShowLibraryContents;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            NodeOptions options = (NodeOptions)object;
            return options.isFlattenPackages() == this.isFlattenPackages() && options.isAbbreviatePackageNames() == this.isAbbreviatePackageNames() && options.isHideEmptyMiddlePackages() == this.isHideEmptyMiddlePackages() && options.isCompactDirectories() == this.isCompactDirectories() && options.isShowLibraryContents() == this.isShowLibraryContents();
        }

        public int hashCode() {
            int result = this.getClass().hashCode();
            result = 31 * result + Boolean.hashCode(this.isFlattenPackages());
            result = 31 * result + Boolean.hashCode(this.isAbbreviatePackageNames());
            result = 31 * result + Boolean.hashCode(this.isHideEmptyMiddlePackages());
            result = 31 * result + Boolean.hashCode(this.isCompactDirectories());
            result = 31 * result + Boolean.hashCode(this.isShowLibraryContents());
            return result;
        }
    }
}

