/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchResult;

public class SearchResultSet {
    private List<SearchResult> searchResults;
    private Map<SearchCategoryGroupKey, List<SearchResult>> searchResultsByCategory;

    public SearchResultSet(Collection<SearchResult> searchResults) {
        this.searchResults = new ArrayList<SearchResult>(searchResults);
        this.buildCatResults();
    }

    public int getCategoryResultsCount(String cat) {
        SearchCategoryGroupKey key = this.getKeyForCategory(cat);
        List<SearchResult> catResults = this.searchResultsByCategory.get(key);
        if (catResults == null) {
            return 0;
        }
        return catResults.size();
    }

    public List<String> getCategories() {
        ArrayList<String> result = new ArrayList<String>();
        for (SearchCategoryGroupKey searchCategoryGroupKey : new TreeSet<SearchCategoryGroupKey>(this.searchResultsByCategory.keySet())) {
            result.add(searchCategoryGroupKey.groupDescription);
        }
        return result;
    }

    public List<SearchResult> getCategoryResults(String category) {
        SearchCategoryGroupKey key = this.getKeyForCategory(category);
        List<SearchResult> catResults = this.searchResultsByCategory.get(key);
        if (catResults == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SearchResult>(catResults);
    }

    public List<SearchResult> getCategoryResults(String category, int limit) {
        ArrayList<SearchResult> trimmedResult = new ArrayList<SearchResult>();
        SearchCategoryGroupKey key = this.getKeyForCategory(category);
        if (key == null) {
            return Collections.emptyList();
        }
        List<SearchResult> catResults = this.searchResultsByCategory.get(key);
        if (catResults == null) {
            return Collections.emptyList();
        }
        List<SearchResult> trimmedCatResults = catResults.size() > limit ? catResults.subList(0, limit) : catResults;
        trimmedResult.addAll(trimmedCatResults);
        return trimmedResult;
    }

    private SearchCategoryGroupKey getKeyForCategory(String cat) {
        for (SearchCategoryGroupKey searchCategoryGroupKey : this.searchResultsByCategory.keySet()) {
            if (!searchCategoryGroupKey.groupDescription.equals(cat)) continue;
            return searchCategoryGroupKey;
        }
        return null;
    }

    private void buildCatResults() {
        this.searchResultsByCategory = new HashMap<SearchCategoryGroupKey, List<SearchResult>>();
        for (SearchResult searchResult : this.searchResults) {
            String cat = searchResult.getGroupDescription();
            SearchCategory category = searchResult.getCategory();
            SearchCategoryGroupKey key = new SearchCategoryGroupKey(category, cat);
            List<SearchResult> catResults = this.searchResultsByCategory.get(key);
            if (catResults == null) {
                catResults = new ArrayList<SearchResult>();
                this.searchResultsByCategory.put(key, catResults);
            }
            catResults.add(searchResult);
        }
    }

    public List<SearchResult> getSearchResults() {
        return Collections.unmodifiableList(this.searchResults);
    }

    private class SearchCategoryGroupKey
    implements Comparable<SearchCategoryGroupKey> {
        private SearchCategory category;
        private String groupDescription;

        private SearchCategoryGroupKey(SearchCategory searchType, String groupDescription) {
            this.category = searchType;
            this.groupDescription = groupDescription;
        }

        @Override
        public int compareTo(SearchCategoryGroupKey o) {
            int typeDiff = this.category.ordinal() - o.category.ordinal();
            if (typeDiff != 0) {
                return typeDiff;
            }
            return this.groupDescription.compareToIgnoreCase(o.groupDescription);
        }

        public int hashCode() {
            return SearchCategoryGroupKey.class.getSimpleName().hashCode() + this.category.hashCode() + this.category.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SearchCategoryGroupKey)) {
                return false;
            }
            SearchCategoryGroupKey other = (SearchCategoryGroupKey)obj;
            return this.category == other.category && this.groupDescription.equals(other.groupDescription);
        }
    }
}

