/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfGroups;
import de.escape.quincunx.dxf.reader.DxfReporter;
import de.escape.quincunx.dxf.reader.DxfSection;
import de.escape.quincunx.trafo.Point3D;

public class DxfHeader
extends DxfSection {
    public static final int UC_ISO_1 = 0;
    public static final int UC_ISO_2 = 1;
    public static final int UC_DOS437 = 2;
    public static final int UC_DOS850 = 3;
    public static final int UC_DOS852 = 4;
    public static final int UC_DOS855 = 5;
    public static final int UC_DOS857 = 6;
    public static final int UC_DOS860 = 7;
    public static final int UC_DOS861 = 8;
    public static final int UC_DOS863 = 9;
    public static final int UC_DOS864 = 10;
    public static final int UC_DOS865 = 11;
    public static final int UC_DOS869 = 12;
    public static final int UC_MAC = 13;
    public static final int UC_ALL = 14;
    protected String ACADVER;
    protected int ATTMODE = 1;
    protected String DWGCODEPAGE = "DOS437";
    protected Point3D EXTMAX = new Point3D();
    protected Point3D EXTMIN = new Point3D();
    protected int FILLMODE;
    protected Point3D INSBASE = new Point3D();
    protected float LTSCALE = 1.0f;
    protected int PDMODE;
    protected float PDSIZE;
    protected String lastKeyword = "";
    protected int codePage = -1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(DxfGroups grp, DxfReporter reporter) throws DxfException {
        block26: while (true) {
            grp.read();
            switch (grp.number) {
                default: {
                    continue block26;
                }
                case 0: {
                    if ("ENDSEC".equals(grp.valToString())) {
                        return;
                    }
                    throw new DxfException("err!InHeader", new String[]{String.valueOf(grp.getLineNr())});
                }
                case 9: {
                    this.lastKeyword = grp.valToString();
                    continue block26;
                }
                case 1: {
                    if (!this.lastKeyword.equals("$ACADVER")) continue block26;
                    this.ACADVER = grp.valToString();
                    reporter.showStatus("   $ACADVER=" + this.ACADVER);
                    String acadver = this.ACADVER.toUpperCase();
                    if (acadver == null) continue block26;
                    String acadRelease = "???";
                    boolean warn = false;
                    if (acadver.startsWith("AC")) {
                        try {
                            String version = acadver.substring(2);
                            int dxfversion = Integer.parseInt(version);
                            if (dxfversion > 1014) {
                                acadRelease = "> R14";
                                warn = true;
                            } else {
                                switch (dxfversion) {
                                    case 1014: {
                                        acadRelease = "R14";
                                        warn = true;
                                        break;
                                    }
                                    case 1013: {
                                        acadRelease = "AutoDesk internal (>R13)";
                                        warn = true;
                                        break;
                                    }
                                    case 1012: {
                                        acadRelease = "R13";
                                        warn = true;
                                        break;
                                    }
                                    case 1010: 
                                    case 1011: {
                                        warn = true;
                                        acadRelease = "AutoDesk internal (>R12)";
                                        break;
                                    }
                                    case 1009: {
                                        acadRelease = "R11/R12";
                                        break;
                                    }
                                    case 1007: 
                                    case 1008: {
                                        acadRelease = "AutoDesk internal (>R10)";
                                        break;
                                    }
                                    case 1006: {
                                        acadRelease = "R10";
                                        break;
                                    }
                                    case 1005: {
                                        acadRelease = "AutoDesk internal (>R9)";
                                        break;
                                    }
                                    case 1004: {
                                        acadRelease = "R9";
                                        break;
                                    }
                                    case 1003: {
                                        acadRelease = "R8/V2.6";
                                        break;
                                    }
                                    case 1002: {
                                        acadRelease = "R7/V2.5";
                                    }
                                    default: {
                                        if ("2.10".equals(version)) {
                                            acadRelease = "R6/V2.1";
                                            break;
                                        }
                                        if (!"1.50".equals(version)) break;
                                        acadRelease = "R5/V2.0";
                                        break;
                                    }
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (warn) {
                        reporter.showWarningRes("warnAcadReleaseNew", new String[]{acadRelease});
                        continue block26;
                    }
                    reporter.showStatusRes("msgAcadRelease", new String[]{acadRelease});
                    continue block26;
                }
                case 3: {
                    if (!this.lastKeyword.equals("$DWGCODEPAGE")) continue block26;
                    this.DWGCODEPAGE = grp.valToString();
                    reporter.showStatus("   $DWGCODEPAGE=" + this.DWGCODEPAGE);
                    continue block26;
                }
                case 10: {
                    if (this.lastKeyword.equals("$EXTMAX")) {
                        this.EXTMAX.x = grp.valToFloat();
                        continue block26;
                    }
                    if (this.lastKeyword.equals("$EXTMIN")) {
                        this.EXTMIN.x = grp.valToFloat();
                        continue block26;
                    }
                    if (!this.lastKeyword.equals("$INSBASE")) continue block26;
                    this.INSBASE.x = grp.valToFloat();
                    continue block26;
                }
                case 20: {
                    if (this.lastKeyword.equals("$EXTMAX")) {
                        this.EXTMAX.y = grp.valToFloat();
                        continue block26;
                    }
                    if (this.lastKeyword.equals("$EXTMIN")) {
                        this.EXTMIN.y = grp.valToFloat();
                        continue block26;
                    }
                    if (!this.lastKeyword.equals("$INSBASE")) continue block26;
                    this.INSBASE.y = grp.valToFloat();
                    continue block26;
                }
                case 30: {
                    if (this.lastKeyword.equals("$EXTMAX")) {
                        this.EXTMAX.z = grp.valToFloat();
                        continue block26;
                    }
                    if (this.lastKeyword.equals("$EXTMIN")) {
                        this.EXTMIN.z = grp.valToFloat();
                        continue block26;
                    }
                    if (!this.lastKeyword.equals("$INSBASE")) continue block26;
                    this.INSBASE.z = grp.valToFloat();
                    continue block26;
                }
                case 40: {
                    if (this.lastKeyword.equals("$LTSCALE")) {
                        this.LTSCALE = grp.valToFloat();
                        continue block26;
                    }
                    if (!this.lastKeyword.equals("$PDSIZE")) continue block26;
                    this.PDSIZE = grp.valToFloat();
                    continue block26;
                }
                case 70: 
            }
            if (this.lastKeyword.equals("$FILLMODE")) {
                this.FILLMODE = grp.valToInt();
                continue;
            }
            if (!this.lastKeyword.equals("$PDMODE")) continue;
            this.PDMODE = grp.valToInt();
        }
    }

    public int getCodePage() {
        if (this.codePage == -1) {
            this.codePage = this.DWGCODEPAGE.equals("DOS850") ? 3 : (this.DWGCODEPAGE.equals("DOS852") ? 4 : (this.DWGCODEPAGE.equals("DOS855") ? 5 : (this.DWGCODEPAGE.equals("DOS857") ? 6 : (this.DWGCODEPAGE.equals("DOS860") ? 7 : (this.DWGCODEPAGE.equals("DOS861") ? 8 : (this.DWGCODEPAGE.equals("DOS863") ? 9 : (this.DWGCODEPAGE.equals("DOS864") ? 10 : (this.DWGCODEPAGE.equals("DOS865") ? 11 : (this.DWGCODEPAGE.equals("DOS869") ? 12 : (this.DWGCODEPAGE.equals("ISO8859_1") ? 0 : (this.DWGCODEPAGE.equals("ISO8859_2") ? 1 : (this.DWGCODEPAGE.equals("MAC_ROMAN") ? 13 : 2))))))))))));
        }
        return this.codePage;
    }

    public String getACADVER() {
        return this.ACADVER;
    }

    public int getATTMODE() {
        return this.ATTMODE;
    }

    public String getDWGCODEPAGE() {
        return this.DWGCODEPAGE;
    }

    public Point3D getEXTMAX() {
        return this.EXTMAX;
    }

    public Point3D getEXTMIN() {
        return this.EXTMIN;
    }

    public boolean getFILLMODE() {
        return this.FILLMODE != 0;
    }

    public Point3D getINSBASE() {
        return this.INSBASE;
    }

    public int getPDMODE() {
        return this.PDMODE;
    }

    public float getPDSIZE() {
        return this.PDSIZE;
    }

    public float getLTSCALE() {
        return this.LTSCALE;
    }
}

