<?php
declare(strict_types=1);

/**
 *
 * @copyright Copyright (c) 2018, Daniel Calviño Sánchez (danxuliu@gmail.com)
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\Spreed\PublicShare;

use OCP\Util;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Helper class to extend the "publicshare" template from the server.
 *
 * The "loadTalkSidebarUi" method loads additional scripts that, when run on the
 * browser, adjust the page generated by the server to inject the Talk UI as
 * needed.
 */
class TemplateLoader {

	public static function register(EventDispatcherInterface $dispatcher): void {
		$listener = function() {
			self::loadTalkSidebarUi();
		};
		$dispatcher->addListener('OCA\Files_Sharing::loadAdditionalScripts', $listener);
	}

	/**
	 * Load the "Talk sidebar" UI in the public share page for the given share.
	 *
	 * This method should be called when loading additional scripts for the
	 * public share page of the server.
	 */
	public static function loadTalkSidebarUi() {
		Util::addStyle('spreed', 'merged-public-share');
		Util::addScript('spreed', 'merged-public-share');
	}

}
