/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericParameterValueSet;

final class GenericParameter {
    private static int DECIMAL_PARAMETER_DEFAULT_PRECISION = 31;
    private static int DECIMAL_PARAMETER_DEFAULT_SCALE = 15;
    private final GenericParameterValueSet pvs;
    private DataValueDescriptor value;
    int jdbcTypeId;
    String declaredClassName;
    short parameterMode;
    boolean isSet;
    private final boolean isReturnOutputParameter;
    int registerOutType = 0;
    int registerOutScale = -1;
    int registerOutPrecision = -1;

    GenericParameter(GenericParameterValueSet genericParameterValueSet, boolean bl) {
        this.pvs = genericParameterValueSet;
        this.isReturnOutputParameter = bl;
        this.parameterMode = (short)(this.isReturnOutputParameter ? 4 : 1);
    }

    public GenericParameter getClone(GenericParameterValueSet genericParameterValueSet) {
        GenericParameter genericParameter = new GenericParameter(genericParameterValueSet, this.isReturnOutputParameter);
        genericParameter.initialize(this.getValue().cloneValue(false), this.jdbcTypeId, this.declaredClassName);
        genericParameter.isSet = true;
        return genericParameter;
    }

    void initialize(DataValueDescriptor dataValueDescriptor, int n, String string) {
        this.value = dataValueDescriptor;
        this.jdbcTypeId = n;
        this.declaredClassName = string;
    }

    void clear() {
        this.isSet = false;
    }

    DataValueDescriptor getValue() {
        return this.value;
    }

    void setOutParameter(int n, int n2) throws StandardException {
        if (this.registerOutType == n && n2 == this.registerOutScale) {
            return;
        }
        switch (this.parameterMode) {
            default: {
                throw StandardException.newException("XCL22.S", this.getJDBCParameterNumberStr());
            }
            case 2: 
            case 4: 
        }
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(this.jdbcTypeId, n)) {
            throw this.throwInvalidOutParamMap(n);
        }
        this.registerOutType = n;
    }

    private StandardException throwInvalidOutParamMap(int n) {
        String string = Util.typeName(n);
        TypeId typeId = TypeId.getBuiltInTypeId(this.jdbcTypeId);
        String string2 = typeId == null ? this.declaredClassName : typeId.getSQLTypeName();
        StandardException standardException = StandardException.newException("XCL25.S", this.getJDBCParameterNumberStr(), string, string2);
        return standardException;
    }

    void validate() throws StandardException {
        switch (this.parameterMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (this.registerOutType != 0) break;
                throw StandardException.newException("07004", this.getJDBCParameterNumberStr(), RoutineAliasInfo.parameterMode(this.parameterMode));
            }
        }
    }

    int getScale() {
        return this.registerOutScale == -1 ? 0 : this.registerOutScale;
    }

    int getPrecision() {
        return this.registerOutPrecision;
    }

    String getJDBCParameterNumberStr() {
        return Integer.toString(this.pvs.getParameterNumber(this));
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        try {
            return this.value.getTraceString();
        }
        catch (StandardException standardException) {
            return "unexpected exception from getTraceString() - " + standardException;
        }
    }
}

