"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var globals_1 = require("../globals");
function rotateBarValueProps(chartRotation, chartDimensions, barDimensions, displayValueDimensions, displayValue, props) {
    var chartWidth = chartDimensions.width;
    var chartHeight = chartDimensions.height;
    var barWidth = barDimensions.width;
    var barHeight = barDimensions.height;
    var x = barDimensions.left;
    var y = barDimensions.top;
    var displayValueWidth = displayValueDimensions.width;
    var displayValueHeight = displayValueDimensions.height;
    var displayValueX = displayValueDimensions.left;
    var displayValueY = displayValueDimensions.top;
    var rotatedDisplayValueX = displayValueHeight > barWidth
        ? x - Math.abs(barWidth - displayValueHeight) / 2
        : x + Math.abs(barWidth - displayValueHeight) / 2;
    switch (chartRotation) {
        case 0:
            props.x = displayValueX;
            props.y = displayValueY;
            break;
        case 180:
            props.x = chartWidth - displayValueX - displayValueWidth;
            props.y = chartHeight - displayValueY - displayValueHeight;
            props.verticalAlign = 'bottom';
            break;
        case 90:
            props.x =
                barHeight >= displayValueWidth ? chartWidth - displayValueY - displayValueWidth : chartWidth - displayValueY;
            props.y = rotatedDisplayValueX;
            props.verticalAlign = 'middle';
            if (displayValue.isValueContainedInElement) {
                props.x = chartWidth - y - barHeight;
                props.y = x;
                props.width = barHeight >= displayValueWidth ? barHeight : 0;
                props.height = displayValue.height <= barWidth ? barWidth : 0;
                props.align = 'right';
            }
            break;
        case -90:
            props.x = barHeight >= displayValueWidth ? displayValueY : displayValueY - displayValueWidth;
            props.y = chartHeight - rotatedDisplayValueX - displayValueHeight;
            props.verticalAlign = 'middle';
            if (displayValue.isValueContainedInElement) {
                props.x = y;
                props.y = chartHeight - x - barWidth;
                props.width = barHeight >= displayValueWidth ? barHeight : 0;
                props.height = displayValue.height <= barWidth ? barWidth : 0;
                props.align = 'left';
            }
            break;
    }
    return props;
}
exports.rotateBarValueProps = rotateBarValueProps;
function getBarValueClipDimensions(displayValue, computedDimensions, barHeight, chartRotation) {
    var height = displayValue.isValueContainedInElement ? displayValue.height : computedDimensions.height;
    var width = displayValue.isValueContainedInElement ? displayValue.width : computedDimensions.width;
    var offsetY = chartRotation === 180 ? barHeight - displayValue.height : 0;
    var offsetX = chartRotation === 90 ? barHeight - displayValue.width : 0;
    return { height: height, width: width, offsetX: offsetX, offsetY: offsetY };
}
exports.getBarValueClipDimensions = getBarValueClipDimensions;
function isBarValueOverflow(chartDimensions, clip, valuePosition, hideClippedValue) {
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var isOverflowX = valuePosition.x + clip.width - valuePosition.offsetX > chartWidth ||
        valuePosition.x + clip.offsetX - valuePosition.offsetX < 0;
    var isOverflowY = valuePosition.y + clip.height - valuePosition.offsetY > chartHeight ||
        valuePosition.y + clip.offsetY - valuePosition.offsetY < 0;
    return !!hideClippedValue && (isOverflowX || isOverflowY);
}
exports.isBarValueOverflow = isBarValueOverflow;
function buildBarValueProps(_a) {
    var x = _a.x, y = _a.y, barHeight = _a.barHeight, barWidth = _a.barWidth, displayValueStyle = _a.displayValueStyle, displayValue = _a.displayValue, chartRotation = _a.chartRotation, chartDimensions = _a.chartDimensions;
    var padding = displayValueStyle.padding;
    var elementHeight = displayValue.isValueContainedInElement ? barHeight : displayValue.height;
    var displayValueHeight = elementHeight + padding;
    var displayValueWidth = displayValue.width + padding;
    var displayValueY = barHeight >= displayValueHeight ? y : y - displayValueHeight;
    var displayValueX = displayValueWidth > barWidth
        ? x - Math.abs(barWidth - displayValueWidth) / 2
        : x + Math.abs(barWidth - displayValueWidth) / 2;
    var displayValueOffsetY = displayValueStyle.offsetY || 0;
    var displayValueOffsetX = displayValueStyle.offsetX || 0;
    var baseProps = __assign({ align: 'center', verticalAlign: 'top' }, displayValueStyle, { text: displayValue.text, width: displayValueWidth, height: displayValueHeight, offsetY: displayValueOffsetY, x: displayValueX, y: displayValueY });
    var barDimensions = {
        width: barWidth,
        height: barHeight,
        left: x,
        top: y,
    };
    var displayValueDimensions = {
        width: displayValueWidth,
        height: displayValueHeight,
        left: displayValueX,
        top: displayValueY,
    };
    var props = rotateBarValueProps(chartRotation, chartDimensions, barDimensions, displayValueDimensions, displayValue, baseProps);
    var clip = getBarValueClipDimensions(displayValue, props, barHeight, chartRotation);
    var hideOverflow = isBarValueOverflow(chartDimensions, clip, { x: props.x, y: props.y, offsetX: displayValueOffsetX, offsetY: displayValueOffsetY }, displayValue.hideClippedValue);
    if (hideOverflow) {
        props.width = 0;
        props.height = 0;
    }
    return props;
}
exports.buildBarValueProps = buildBarValueProps;
/**
 * Return the style of a point.
 * The color value is used for stroke or fill if they are undefind in the PointStyle
 * @param color the series color
 * @param pointStyle the merged point style
 */
function buildPointStyleProps(color, pointStyle, geometryStyle) {
    var strokeWidth = pointStyle.strokeWidth, opacity = pointStyle.opacity;
    var stroke = pointStyle.stroke || color;
    var fill = pointStyle.fill || color;
    return __assign({ radius: pointStyle.radius, stroke: stroke,
        strokeWidth: strokeWidth, strokeEnabled: strokeWidth !== 0, fill: fill }, geometryStyle, { opacity: opacity * geometryStyle.opacity });
}
exports.buildPointStyleProps = buildPointStyleProps;
/**
 * Return the rendering props for a point
 * @param x the x position of the point
 * @param y the y position of the point
 * @param pointStyleProps the style props of the point
 */
function buildPointRenderProps(x, y, pointStyleProps) {
    return __assign({ x: x,
        y: y }, pointStyleProps, globals_1.GlobalKonvaElementProps);
}
exports.buildPointRenderProps = buildPointRenderProps;
/**
 * Return the rendering props for a line. The color of the line will be overwritten
 * by the stroke color of the lineStyle parameter if present
 * @param x the horizontal offset to place the line
 * @param linePath the SVG line path
 * @param color the computed color of the line for this series
 * @param lineStyle the line style
 * @param geometryStyle the highlight geometry style
 */
function buildLineRenderProps(x, linePath, color, lineStyle, geometryStyle) {
    var opacity = lineStyle.opacity * geometryStyle.opacity;
    return __assign({ x: x, data: linePath, stroke: lineStyle.stroke || color, strokeWidth: lineStyle.strokeWidth, lineCap: 'round', lineJoin: 'round' }, geometryStyle, { opacity: opacity }, globals_1.GlobalKonvaElementProps);
}
exports.buildLineRenderProps = buildLineRenderProps;
/**
 * Return the rendering props for an area. The color of the area will be overwritten
 * by the fill color of the areaStyle parameter if present
 * @param areaPath the SVG area path
 * @param x the horizontal offset to place the area
 * @param color the computed color of the line for this series
 * @param areaStyle the area style
 * @param geometryStyle the highlight geometry style
 */
function buildAreaRenderProps(xTransform, areaPath, color, areaStyle, geometryStyle) {
    var opacity = areaStyle.opacity * geometryStyle.opacity;
    return __assign({ x: xTransform, data: areaPath, fill: areaStyle.fill || color, lineCap: 'round', lineJoin: 'round' }, geometryStyle, { opacity: opacity }, globals_1.GlobalKonvaElementProps);
}
exports.buildAreaRenderProps = buildAreaRenderProps;
/**
 * Return the rendering props for a bar. The color of the bar will be overwritten
 * by the fill color of the rectStyle parameter if present
 * @param x the x position of the rect
 * @param y the y position of the rect
 * @param width the width of the rect
 * @param height the height of the rect
 * @param color the computed color of the rect for this series
 * @param rectStyle the rect style
 * @param geometryStyle the highlight geometry style
 */
function buildBarRenderProps(x, y, width, height, color, rectStyle, borderStyle, geometryStyle) {
    var opacity = rectStyle.opacity * geometryStyle.opacity;
    var stroke = borderStyle.stroke, visible = borderStyle.visible, strokeWidth = borderStyle.strokeWidth, _a = borderStyle.strokeOpacity, strokeOpacity = _a === void 0 ? 0 : _a;
    var offset = !visible || strokeWidth <= 0 || !stroke || strokeOpacity <= 0 || opacity <= 0 ? 0 : strokeWidth;
    return __assign({ x: x + offset, y: y + offset, width: width - 2 * offset, height: height - 2 * offset, fill: rectStyle.fill || color, strokeEnabled: false }, geometryStyle, { opacity: opacity }, globals_1.GlobalKonvaElementProps);
}
exports.buildBarRenderProps = buildBarRenderProps;
/**
 * Return the rendering props for a bar. The color of the bar will be overwritten
 * by the fill color of the rectStyle parameter if present
 * @param x the x position of the rect
 * @param y the y position of the rect
 * @param width the width of the rect
 * @param height the height of the rect
 * @param color the computed color of the rect for this series
 * @param rectStyle the rect style
 * @param borderStyle the border rect style
 * @param geometryStyle the highlight geometry style
 */
function buildBarBorderRenderProps(x, y, width, height, rectStyle, borderStyle, geometryStyle) {
    var stroke = borderStyle.stroke, visible = borderStyle.visible, strokeWidth = borderStyle.strokeWidth, _a = borderStyle.strokeOpacity, strokeOpacity = _a === void 0 ? rectStyle.opacity : _a;
    var opacity = strokeOpacity * geometryStyle.opacity;
    if (!visible || strokeWidth <= 0 || !stroke || opacity <= 0) {
        return null;
    }
    return __assign({ x: x + strokeWidth / 2, y: y + strokeWidth / 2, width: width - strokeWidth, height: height - strokeWidth, fillEnabled: false, strokeEnabled: true, strokeWidth: strokeWidth,
        stroke: stroke }, geometryStyle, { opacity: opacity }, globals_1.GlobalKonvaElementProps);
}
exports.buildBarBorderRenderProps = buildBarBorderRenderProps;
//# sourceMappingURL=rendering_props_utils.js.map