"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var ids_1 = require("../../../utils/ids");
var scales_1 = require("../../../utils/scales/scales");
var axis_utils_1 = require("../utils/axis_utils");
var domain_1 = require("../../../utils/domain");
var commons_1 = require("../../../utils/commons");
var d3_array_1 = require("d3-array");
function mergeYDomain(dataSeries, specs, domainsByGroupId) {
    // group specs by group ids
    var specsByGroupIds = splitSpecsByGroupId(specs);
    var specsByGroupIdsEntries = __spread(specsByGroupIds.entries());
    var globalId = ids_1.getGroupId(specs_1.DEFAULT_GLOBAL_ID);
    var yDomains = specsByGroupIdsEntries.map(function (_a) {
        var _b = __read(_a, 2), groupId = _b[0], groupSpecs = _b[1];
        var customDomain = domainsByGroupId.get(groupId);
        return mergeYDomainForGroup(dataSeries, groupId, groupSpecs, customDomain);
    });
    var globalGroupIds = specs.reduce(function (acc, _a) {
        var groupId = _a.groupId, useDefaultGroupDomain = _a.useDefaultGroupDomain;
        if (groupId !== globalId && useDefaultGroupDomain) {
            acc.add(groupId);
        }
        return acc;
    }, new Set());
    globalGroupIds.add(globalId);
    var globalYDomains = yDomains.filter(function (domain) { return globalGroupIds.has(domain.groupId); });
    var globalYDomain = [Number.MAX_SAFE_INTEGER, Number.MIN_SAFE_INTEGER];
    globalYDomains.forEach(function (domain) {
        globalYDomain = [Math.min(globalYDomain[0], domain.domain[0]), Math.max(globalYDomain[1], domain.domain[1])];
    });
    return yDomains.map(function (domain) {
        if (globalGroupIds.has(domain.groupId)) {
            return __assign({}, domain, { domain: globalYDomain });
        }
        return domain;
    });
}
exports.mergeYDomain = mergeYDomain;
function mergeYDomainForGroup(dataSeries, groupId, groupSpecs, customDomain) {
    var groupYScaleType = coerceYScaleTypes(__spread(groupSpecs.stacked, groupSpecs.nonStacked));
    var isPercentageStack = groupSpecs.isPercentageStack;
    var domain;
    if (isPercentageStack) {
        domain = domain_1.computeContinuousDataDomain([0, 1], commons_1.identity);
    }
    else {
        // compute stacked domain
        var isStackedScaleToExtent = groupSpecs.stacked.some(function (spec) {
            return spec.yScaleToDataExtent;
        });
        var stackedDataSeries = getDataSeriesOnGroup(dataSeries, groupSpecs.stacked);
        var stackedDomain = computeYStackedDomain(stackedDataSeries, isStackedScaleToExtent);
        // compute non stacked domain
        var isNonStackedScaleToExtent = groupSpecs.nonStacked.some(function (spec) {
            return spec.yScaleToDataExtent;
        });
        var nonStackedDataSeries = getDataSeriesOnGroup(dataSeries, groupSpecs.nonStacked);
        var nonStackedDomain = computeYNonStackedDomain(nonStackedDataSeries, isNonStackedScaleToExtent);
        // merge stacked and non stacked domain together
        domain = domain_1.computeContinuousDataDomain(__spread(stackedDomain, nonStackedDomain), commons_1.identity, isStackedScaleToExtent || isNonStackedScaleToExtent);
        var _a = __read(domain, 2), computedDomainMin = _a[0], computedDomainMax = _a[1];
        if (customDomain && axis_utils_1.isCompleteBound(customDomain)) {
            // Don't need to check min > max because this has been validated on axis domain merge
            domain = [customDomain.min, customDomain.max];
        }
        else if (customDomain && axis_utils_1.isLowerBound(customDomain)) {
            if (customDomain.min > computedDomainMax) {
                throw new Error("custom yDomain for " + groupId + " is invalid, custom min is greater than computed max");
            }
            domain = [customDomain.min, computedDomainMax];
        }
        else if (customDomain && axis_utils_1.isUpperBound(customDomain)) {
            if (computedDomainMin > customDomain.max) {
                throw new Error("custom yDomain for " + groupId + " is invalid, computed min is greater than custom max");
            }
            domain = [computedDomainMin, customDomain.max];
        }
    }
    return {
        type: 'yDomain',
        isBandScale: false,
        scaleType: groupYScaleType,
        groupId: groupId,
        domain: domain,
    };
}
function getDataSeriesOnGroup(dataSeries, specs) {
    return specs.reduce(function (acc, spec) {
        var ds = dataSeries.get(spec.id) || [];
        return __spread(acc, ds);
    }, []);
}
exports.getDataSeriesOnGroup = getDataSeriesOnGroup;
function computeYStackedDomain(dataseries, scaleToExtent) {
    var e_1, _a;
    var stackMap = new Map();
    dataseries.forEach(function (ds, index) {
        ds.data.forEach(function (datum) {
            var stack = stackMap.get(datum.x) || [];
            stack[index] = datum.y1;
            stackMap.set(datum.x, stack);
        });
    });
    var dataValues = [];
    try {
        for (var stackMap_1 = __values(stackMap), stackMap_1_1 = stackMap_1.next(); !stackMap_1_1.done; stackMap_1_1 = stackMap_1.next()) {
            var stackValues = stackMap_1_1.value;
            dataValues.push.apply(dataValues, __spread(stackValues[1]));
            if (stackValues[1].length > 1) {
                dataValues.push(d3_array_1.sum(stackValues[1]));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (stackMap_1_1 && !stackMap_1_1.done && (_a = stackMap_1.return)) _a.call(stackMap_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (dataValues.length === 0) {
        return [];
    }
    return domain_1.computeContinuousDataDomain(dataValues, commons_1.identity, scaleToExtent);
}
function computeYNonStackedDomain(dataseries, scaleToExtent) {
    var yValues = new Set();
    dataseries.forEach(function (ds) {
        ds.data.forEach(function (datum) {
            yValues.add(datum.y1);
            if (datum.y0 != null) {
                yValues.add(datum.y0);
            }
        });
    });
    if (yValues.size === 0) {
        return [];
    }
    return domain_1.computeContinuousDataDomain(__spread(yValues.values()), commons_1.identity, scaleToExtent);
}
function splitSpecsByGroupId(specs) {
    var specsByGroupIds = new Map();
    // split each specs by groupId and by stacked or not
    specs.forEach(function (spec) {
        var group = specsByGroupIds.get(spec.groupId) || {
            isPercentageStack: false,
            stacked: [],
            nonStacked: [],
        };
        if (spec.stackAccessors && spec.stackAccessors.length > 0) {
            group.stacked.push(spec);
        }
        else {
            group.nonStacked.push(spec);
        }
        if (spec.stackAsPercentage === true) {
            group.isPercentageStack = true;
        }
        specsByGroupIds.set(spec.groupId, group);
    });
    return specsByGroupIds;
}
exports.splitSpecsByGroupId = splitSpecsByGroupId;
/**
 * Coerce the scale types of a set of specification to a generic one.
 * If there is at least one bar series type, than the response will specity
 * that the coerced scale is a `scaleBand` (each point needs to have a surrounding empty
 * space to draw the bar width).
 * If there are multiple continuous scale types, is coerced to linear.
 * If there are at least one Ordinal scale type, is coerced to ordinal.
 * If none of the above, than coerce to the specified scale.
 * @returns {ChartScaleType}
 */
function coerceYScaleTypes(specs) {
    var scaleTypes = new Set();
    specs.forEach(function (spec) {
        scaleTypes.add(spec.yScaleType);
    });
    return coerceYScale(scaleTypes);
}
exports.coerceYScaleTypes = coerceYScaleTypes;
function coerceYScale(scaleTypes) {
    if (scaleTypes.size === 1) {
        var scales = scaleTypes.values();
        var value = scales.next().value;
        return value;
    }
    return scales_1.ScaleType.Linear;
}
//# sourceMappingURL=y_domain.js.map