/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.wildfly.security.SecurityFactory;

public class ClientConfigurationImpl
implements ModelControllerClientConfiguration {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private final String address;
    private final String clientBindAddress;
    private final int port;
    private final CallbackHandler handler;
    private final Map<String, String> saslOptions;
    private final SecurityFactory<SSLContext> sslContextFactory;
    private final ExecutorService executorService;
    private final String protocol;
    private final boolean shutdownExecutor;
    private final int connectionTimeout;
    private final URI authConfigUri;

    public ClientConfigurationImpl(String address, int port, CallbackHandler handler, Map<String, String> saslOptions, SecurityFactory<SSLContext> sslContextFactory, ExecutorService executorService, boolean shutdownExecutor, int connectionTimeout, String protocol, String clientBindAddress, URI authConfigUri) {
        this.address = address;
        this.port = port;
        this.handler = handler;
        this.saslOptions = saslOptions;
        this.sslContextFactory = sslContextFactory;
        this.executorService = executorService;
        this.shutdownExecutor = shutdownExecutor;
        this.protocol = protocol;
        this.clientBindAddress = clientBindAddress;
        this.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 5000;
        this.authConfigUri = authConfigUri;
    }

    @Override
    public String getHost() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    public Map<String, String> getSaslOptions() {
        return this.saslOptions;
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return this.sslContextFactory != null ? (SSLContext)this.sslContextFactory.create() : null;
        }
        catch (GeneralSecurityException e) {
            ControllerClientLogger.ROOT_LOGGER.trace("Unable to create SSLContext", e);
            return null;
        }
    }

    @Override
    public SecurityFactory<SSLContext> getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executorService;
    }

    @Override
    public void close() {
        if (this.shutdownExecutor && this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    public String getClientBindAddress() {
        return this.clientBindAddress;
    }

    @Override
    public URI getAuthenticationConfigUri() {
        return this.authConfigUri;
    }
}

