/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessageListener;

public abstract class RefCountMessage
implements Message {
    private static final AtomicIntegerFieldUpdater<RefCountMessage> DURABLE_REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "durableRefCount");
    private static final AtomicIntegerFieldUpdater<RefCountMessage> REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "refCount");
    private volatile int durableRefCount = 0;
    private volatile int refCount = 0;
    private RefCountMessageListener context;

    @Override
    public Message setContext(RefCountMessageListener context) {
        this.context = context;
        return this;
    }

    @Override
    public RefCountMessageListener getContext() {
        return this.context;
    }

    @Override
    public int getRefCount() {
        return this.refCount;
    }

    @Override
    public int incrementRefCount() throws Exception {
        int count = REF_COUNT_UPDATER.incrementAndGet(this);
        if (this.context != null) {
            this.context.nonDurableUp(this, count);
        }
        return count;
    }

    @Override
    public int incrementDurableRefCount() {
        int count = DURABLE_REF_COUNT_UPDATER.incrementAndGet(this);
        if (this.context != null) {
            this.context.durableUp(this, count);
        }
        return count;
    }

    @Override
    public int decrementDurableRefCount() {
        int count = DURABLE_REF_COUNT_UPDATER.decrementAndGet(this);
        if (this.context != null) {
            this.context.durableDown(this, count);
        }
        return count;
    }

    @Override
    public int decrementRefCount() throws Exception {
        int count = REF_COUNT_UPDATER.decrementAndGet(this);
        if (this.context != null) {
            this.context.nonDurableDown(this, count);
        }
        return count;
    }
}

