/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.ReferenceToken;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.PathValueOperation;

public final class AddOperation
extends PathValueOperation {
    private static final ReferenceToken LAST_ARRAY_ELEMENT = ReferenceToken.fromRaw((String)"-");

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return this.value;
        }
        JsonPatchOperation.SplitPointer split = new JsonPatchOperation.SplitPointer(this.path);
        JsonNode parentNode = (JsonNode)split.parent.path((TreeNode)node);
        if (parentNode.isMissingNode()) {
            throw new JsonPatchException("parent of node to add does not exist");
        }
        return parentNode.isArray() ? this.addToArray(split, node) : this.addToObject(split, node);
    }

    private JsonNode addToArray(JsonPatchOperation.SplitPointer split, JsonNode node) throws JsonPatchException {
        int index;
        JsonNode ret = node.deepCopy();
        ArrayNode target = (ArrayNode)split.parent.get((TreeNode)ret);
        TokenResolver<JsonNode> token = split.lastToken;
        if (token.getToken().equals((Object)LAST_ARRAY_ELEMENT)) {
            target.add(this.value);
            return ret;
        }
        int size = target.size();
        try {
            index = Integer.parseInt(token.toString());
        }
        catch (NumberFormatException ignored) {
            throw new JsonPatchException("reference token is not an array index");
        }
        if (index < 0 || index > size) {
            throw new JsonPatchException("no such index in target array");
        }
        target.insert(index, this.value);
        return ret;
    }

    private JsonNode addToObject(JsonPatchOperation.SplitPointer split, JsonNode node) {
        JsonNode ret = node.deepCopy();
        ObjectNode target = (ObjectNode)split.parent.get((TreeNode)ret);
        target.put(split.lastToken.getToken().getRaw(), this.value);
        return ret;
    }

    @Override
    public String toString() {
        return "add: " + super.toString();
    }
}

