/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.groovy.ant.CompileTaskSupport;
import org.codehaus.groovy.tools.javac.JavaStubCompilationUnit;

public class GenerateStubsTask
extends CompileTaskSupport {
    @Override
    protected void compile() {
        GroovyClassLoader gcl = this.createClassLoader();
        JavaStubCompilationUnit cu = new JavaStubCompilationUnit(this.config, gcl, this.destdir);
        int count = 0;
        for (String srcPath : this.src.list()) {
            File srcDir = this.getProject().resolveFile(srcPath);
            if (!srcDir.exists()) {
                throw new BuildException("Source directory does not exist: " + srcDir, this.getLocation());
            }
            DirectoryScanner scanner = this.getDirectoryScanner(srcDir);
            this.log.debug("Including files from: " + srcDir);
            for (String includeName : scanner.getIncludedFiles()) {
                this.log.debug("    " + includeName);
                File file = new File(srcDir, includeName);
                cu.addSource(file);
                if (includeName.endsWith(".java")) continue;
                ++count;
            }
        }
        if (count > 0) {
            this.log.info("Generating " + count + " Java stub" + (count > 1 ? "s" : "") + " to " + this.destdir);
            cu.compile();
            this.log.info("Generated " + cu.getStubCount() + " Java stub(s)");
        } else {
            this.log.info("No sources found for stub generation");
        }
    }
}

