/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class ECallLocal
extends AExpression {
    private final String name;
    private final List<AExpression> arguments;
    private Locals.LocalMethod localMethod = null;
    private PainlessMethod importedMethod = null;
    private PainlessClassBinding classBinding = null;
    private int classBindingOffset = 0;
    private PainlessInstanceBinding instanceBinding = null;

    public ECallLocal(Location location, String name, List<AExpression> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AExpression argument : this.arguments) {
            argument.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        ArrayList typeParameters;
        this.localMethod = locals.getMethod(this.name, this.arguments.size());
        if (this.localMethod == null) {
            this.importedMethod = locals.getPainlessLookup().lookupImportedPainlessMethod(this.name, this.arguments.size());
            if (this.importedMethod == null) {
                this.classBinding = locals.getPainlessLookup().lookupPainlessClassBinding(this.name, this.arguments.size());
                if (this.classBinding != null && !this.classBinding.typeParameters.isEmpty() && this.classBinding.typeParameters.get(0) == locals.getBaseClass()) {
                    this.classBinding = null;
                }
                if (this.classBinding == null) {
                    this.classBinding = locals.getPainlessLookup().lookupPainlessClassBinding(this.name, this.arguments.size() + 1);
                    if (this.classBinding != null) {
                        if (!this.classBinding.typeParameters.isEmpty() && this.classBinding.typeParameters.get(0) == locals.getBaseClass()) {
                            this.classBindingOffset = 1;
                        } else {
                            this.classBinding = null;
                        }
                    }
                    if (this.classBinding == null) {
                        this.instanceBinding = locals.getPainlessLookup().lookupPainlessInstanceBinding(this.name, this.arguments.size());
                        if (this.instanceBinding == null) {
                            throw this.createError(new IllegalArgumentException("Unknown call [" + this.name + "] with [" + this.arguments.size() + "] arguments."));
                        }
                    }
                }
            }
        }
        if (this.localMethod != null) {
            typeParameters = new ArrayList(this.localMethod.typeParameters);
            this.actual = this.localMethod.returnType;
        } else if (this.importedMethod != null) {
            typeParameters = new ArrayList(this.importedMethod.typeParameters);
            this.actual = this.importedMethod.returnType;
        } else if (this.classBinding != null) {
            typeParameters = new ArrayList(this.classBinding.typeParameters);
            this.actual = this.classBinding.returnType;
        } else if (this.instanceBinding != null) {
            typeParameters = new ArrayList(this.instanceBinding.typeParameters);
            this.actual = this.instanceBinding.returnType;
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = (Class)typeParameters.get(argument + this.classBindingOffset);
            expression.internal = true;
            expression.analyze(locals);
            this.arguments.set(argument, expression.cast(locals));
        }
        this.statement = true;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.localMethod != null) {
            for (AExpression argument : this.arguments) {
                argument.write(writer, globals);
            }
            writer.invokeStatic(WriterConstants.CLASS_TYPE, new Method(this.localMethod.name, this.localMethod.methodType.toMethodDescriptorString()));
        } else if (this.importedMethod != null) {
            for (AExpression argument : this.arguments) {
                argument.write(writer, globals);
            }
            writer.invokeStatic(Type.getType(this.importedMethod.targetClass), new Method(this.importedMethod.javaMethod.getName(), this.importedMethod.methodType.toMethodDescriptorString()));
        } else if (this.classBinding != null) {
            int argument;
            String name = globals.addClassBinding(this.classBinding.javaConstructor.getDeclaringClass());
            Type type = Type.getType(this.classBinding.javaConstructor.getDeclaringClass());
            int javaConstructorParameterCount = this.classBinding.javaConstructor.getParameterCount() - this.classBindingOffset;
            Label nonNull = new Label();
            writer.loadThis();
            writer.getField(WriterConstants.CLASS_TYPE, name, type);
            writer.ifNonNull(nonNull);
            writer.loadThis();
            writer.newInstance(type);
            writer.dup();
            if (this.classBindingOffset == 1) {
                writer.loadThis();
            }
            for (argument = 0; argument < javaConstructorParameterCount; ++argument) {
                this.arguments.get(argument).write(writer, globals);
            }
            writer.invokeConstructor(type, Method.getMethod(this.classBinding.javaConstructor));
            writer.putField(WriterConstants.CLASS_TYPE, name, type);
            writer.mark(nonNull);
            writer.loadThis();
            writer.getField(WriterConstants.CLASS_TYPE, name, type);
            for (argument = 0; argument < this.classBinding.javaMethod.getParameterCount(); ++argument) {
                this.arguments.get(argument + javaConstructorParameterCount).write(writer, globals);
            }
            writer.invokeVirtual(type, Method.getMethod((java.lang.reflect.Method)this.classBinding.javaMethod));
        } else if (this.instanceBinding != null) {
            String name = globals.addInstanceBinding(this.instanceBinding.targetInstance);
            Type type = Type.getType(this.instanceBinding.targetInstance.getClass());
            writer.loadThis();
            writer.getStatic(WriterConstants.CLASS_TYPE, name, type);
            for (int argument = 0; argument < this.instanceBinding.javaMethod.getParameterCount(); ++argument) {
                this.arguments.get(argument).write(writer, globals);
            }
            writer.invokeVirtual(type, Method.getMethod((java.lang.reflect.Method)this.instanceBinding.javaMethod));
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.name);
    }
}

