/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.navigator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaLibraries;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class WebJavaContentProvider
implements IPipelinedTreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String JAVA_EXTENSION_ID = "org.eclipse.jdt.java.ui.javaContent";
    private static Class INTERNAL_CONTAINER_CLASS;
    private CommonViewer commonViewer;
    private ITreeContentProvider delegateContentProvider;
    private final Map compressedNodes = new HashMap();

    static {
        try {
            INTERNAL_CONTAINER_CLASS = Class.forName("org.eclipse.jdt.internal.ui.packageview.ClassPathContainer");
        }
        catch (Throwable throwable) {
            INTERNAL_CONTAINER_CLASS = null;
        }
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        try {
            if (aParent instanceof IProject && ((IProject)aParent).hasNature("org.eclipse.jdt.core.javanature") && JavaEEProjectUtilities.isDynamicWebProject((IProject)((IProject)aParent))) {
                this.cleanJavaContribution(theCurrentChildren);
                theCurrentChildren.add(this.getCompressedNode((IProject)aParent));
            }
        }
        catch (CoreException e) {
            ServletUIPlugin.log((Exception)((Object)e));
        }
    }

    private void cleanJavaContribution(Set theCurrentChildren) {
        IJavaElement element = null;
        Iterator iter = theCurrentChildren.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child instanceof IResource && (element = JavaCore.create((IResource)((IResource)child))) != null && element.exists()) {
                iter.remove();
                continue;
            }
            if (child instanceof IJavaElement) {
                iter.remove();
                continue;
            }
            if (INTERNAL_CONTAINER_CLASS == null || !INTERNAL_CONTAINER_CLASS.isInstance(child)) continue;
            iter.remove();
        }
    }

    private CompressedJavaProject getCompressedNode(IProject project) {
        if (!JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            return null;
        }
        CompressedJavaProject result = (CompressedJavaProject)this.compressedNodes.get(project);
        if (result == null) {
            result = new CompressedJavaProject((StructuredViewer)this.commonViewer, project);
            this.compressedNodes.put(project, result);
        }
        return result;
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        try {
            if (anObject instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)anObject;
                if (!root.isExternal()) {
                    if (aSuggestedParent instanceof IJavaProject) {
                        return this.getCompressedNode(((IJavaProject)aSuggestedParent).getProject());
                    }
                    if (aSuggestedParent instanceof IProject && ((IProject)aSuggestedParent).hasNature("org.eclipse.jdt.core.javanature") && JavaEEProjectUtilities.isDynamicWebProject((IProject)((IProject)aSuggestedParent))) {
                        return this.getCompressedNode((IProject)aSuggestedParent);
                    }
                }
            } else if (INTERNAL_CONTAINER_CLASS.isInstance(anObject)) {
                if (aSuggestedParent instanceof IJavaProject) {
                    return this.getCompressedNode(((IJavaProject)aSuggestedParent).getProject()).getCompressedJavaLibraries();
                }
                if (aSuggestedParent instanceof IProject && ((IProject)aSuggestedParent).hasNature("org.eclipse.jdt.core.javanature") && JavaEEProjectUtilities.isDynamicWebProject((IProject)((IProject)aSuggestedParent))) {
                    return this.getCompressedNode((IProject)aSuggestedParent).getCompressedJavaLibraries();
                }
            }
        }
        catch (CoreException e) {
            ServletUIPlugin.log((Exception)((Object)e));
        }
        return null;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        CompressedJavaProject compressedNode;
        IPackageFragmentRoot sourceFolder;
        Object parent = anAddModification.getParent();
        if (parent instanceof IPackageFragmentRoot && JavaEEProjectUtilities.isDynamicWebProject((IProject)(sourceFolder = (IPackageFragmentRoot)parent).getJavaProject().getProject()) && (compressedNode = this.getCompressedNode(sourceFolder.getJavaProject().getProject())).isFlatteningSourceFolder()) {
            anAddModification.setParent((Object)compressedNode);
        }
        return anAddModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        CompressedJavaProject compressedNode;
        IPackageFragmentRoot sourceFolder;
        Object parent = aRemoveModification.getParent();
        Set children = aRemoveModification.getChildren();
        for (Object child : children) {
            if (!(child instanceof IFolder)) continue;
            try {
                IPackageFragment locatePackageFragment = this.locatePackageFragment((IFolder)child);
                if (locatePackageFragment == null) continue;
                aRemoveModification.getChildren().remove(child);
                aRemoveModification.getChildren().add(locatePackageFragment);
                return aRemoveModification;
            }
            catch (JavaModelException javaModelException) {}
        }
        if (parent instanceof IPackageFragmentRoot && JavaEEProjectUtilities.isDynamicWebProject((IProject)(sourceFolder = (IPackageFragmentRoot)parent).getJavaProject().getProject()) && (compressedNode = this.getCompressedNode(sourceFolder.getJavaProject().getProject())).isFlatteningSourceFolder()) {
            aRemoveModification.setParent((Object)compressedNode);
        }
        return aRemoveModification;
    }

    private IPackageFragment locatePackageFragment(IFolder child) throws JavaModelException {
        IJavaElement elem = JavaCore.create((IFolder)child);
        if (elem instanceof IPackageFragment) {
            IPackageFragment packageFragment;
            IPackageFragment javaElem = packageFragment = (IPackageFragment)elem;
            while (javaElem != null) {
                IPackageFragmentRoot fragmentRoot;
                if (javaElem instanceof IPackageFragmentRoot && !(fragmentRoot = (IPackageFragmentRoot)javaElem).isReadOnly() && !fragmentRoot.isExternal()) {
                    return packageFragment;
                }
                javaElem = javaElem.getParent();
            }
        }
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        Set refreshTargets = aRefreshSynchronization.getRefreshTargets();
        Iterator iter = refreshTargets.iterator();
        while (iter.hasNext()) {
            CompressedJavaProject compressedNode;
            IPackageFragmentRoot sourceFolder;
            Object refreshTarget = iter.next();
            if (!(refreshTarget instanceof IPackageFragmentRoot) || !JavaEEProjectUtilities.isDynamicWebProject((IProject)(sourceFolder = (IPackageFragmentRoot)refreshTarget).getJavaProject().getProject()) || !(compressedNode = this.getCompressedNode(sourceFolder.getJavaProject().getProject())).isFlatteningSourceFolder()) continue;
            iter.remove();
            refreshTargets.add(compressedNode);
            return true;
        }
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        Set refreshTargets = anUpdateSynchronization.getRefreshTargets();
        for (Object refreshTarget : refreshTargets) {
            CompressedJavaProject compressedNode;
            IPackageFragmentRoot sourceFolder;
            if (!(refreshTarget instanceof IPackageFragmentRoot) || (sourceFolder = (IPackageFragmentRoot)refreshTarget).getJavaProject() == null || !sourceFolder.getJavaProject().exists() || !sourceFolder.getJavaProject().isOpen() || !JavaEEProjectUtilities.isDynamicWebProject((IProject)sourceFolder.getJavaProject().getProject()) || !(compressedNode = this.getCompressedNode(sourceFolder.getJavaProject().getProject())).isFlatteningSourceFolder()) continue;
            refreshTargets.add(compressedNode);
            return true;
        }
        return false;
    }

    public void init(ICommonContentExtensionSite aSite) {
    }

    public Object[] getChildren(Object parentElement) {
        if (this.delegateContentProvider != null) {
            if (parentElement instanceof CompressedJavaProject) {
                return ((CompressedJavaProject)parentElement).getChildren(this.delegateContentProvider);
            }
            if (parentElement instanceof CompressedJavaLibraries) {
                return ((CompressedJavaLibraries)parentElement).getChildren(this.delegateContentProvider);
            }
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof CompressedJavaProject) {
            return ((CompressedJavaProject)element).getProject();
        }
        if (element instanceof CompressedJavaLibraries) {
            return ((CompressedJavaLibraries)element).getCompressedProject();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CompressedJavaProject || element instanceof CompressedJavaLibraries;
    }

    public Object[] getElements(Object inputElement) {
        return NO_CHILDREN;
    }

    public void dispose() {
        this.compressedNodes.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof CommonViewer) {
            this.commonViewer = (CommonViewer)viewer;
            INavigatorContentService service = this.commonViewer.getNavigatorContentService();
            INavigatorContentExtension javaext = service.getContentExtensionById(JAVA_EXTENSION_ID);
            if (javaext != null) {
                this.delegateContentProvider = javaext.getContentProvider();
            }
            this.compressedNodes.clear();
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public boolean isClasspathContainer(Object o) {
        return INTERNAL_CONTAINER_CLASS != null && INTERNAL_CONTAINER_CLASS.isInstance(o);
    }
}

